<?php
    $categories = App\Models\Category::whereNull('parent_id')->get();
    $manufacturers = App\Models\Manufacturer::get();
    $categories = Cache::remember('categories', 10, function () {
        return \App\Models\Category::whereNull('parent_id')->get();
    });
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(URL::asset('assets/images/favicon.ico?v=1.1')); ?>">
<?php echo $__env->yieldContent('meta'); ?>
    <link rel="apple-touch-icon" href="<?php echo e(URL::asset('assets/images/apple-touch-icon.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-57x57.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-72x72.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-76x76.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="114x114"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-114x114.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="120x120"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-120x120.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="144x144"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-144x144.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="152x152"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-152x152.png?v=1.1')); ?>" />
    <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-180x180.png?v=1.1')); ?>" />
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/toastify.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.min.css?v=1.2')); ?>">
    <?php echo $__env->yieldContent('styles'); ?>
    <title>SIMMA SHOP - ВСЕ ДЛЯ АВТОМОБИЛЯ</title>
    
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-351QSD314K"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'G-351QSD314K');
    </script>
</head>

<body>
    
    <header class="header">
        <div class="header__top">
            <div class="container">
                <div class="header__top-content">
                    <div class="header__top-checked">
                        <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 24 24"
                            fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                            stroke-linejoin="round" class="feather feather-phone-call" style="margin-right: 9px">
                            <path
                                d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z" />
                        </svg>
                        <span class="mr-sm"><a href="tel:<?php echo e(str_replace(' ', '',App\Models\Setting::where('atribute', 'phone_1')->first()->value_one)); ?>"><?php echo e(App\Models\Setting::where('atribute', 'phone_1')->first()->value_one); ?></a></span>
                        <span><a href="tel:<?php echo e(str_replace(' ', '',App\Models\Setting::where('atribute', 'phone_2')->first()->value_one)); ?>"><?php echo e(App\Models\Setting::where('atribute', 'phone_2')->first()->value_one); ?></a></span>
                    </div>
                    <div class="header__top-right">
                        <a href="<?php echo e(route('page.show', 'oplata-i-dostavka')); ?>" class="header__links"><?php echo app('translator')->get('main.top.delivery_and_payment'); ?></a>
                        <a href="<?php echo e(route('help')); ?>" class="header__links"> Вопрос-ответ </a>
                        <a href="<?php echo e(auth()->check() ? route('frontend.cabinet.index', '/#/orders') : route('frontend.user.getLogin')); ?>" class="header__links">Мои заказы </a>
                        <div class="dropdown">
                            <a href="#">
                                <img src="/assets/images/<?php echo e(app()->getLocale()); ?>.png" alt="">
                                <p class="d-inline-block">
                                    <?php echo e(LaravelLocalization::getSupportedLocales()[app()->getLocale()]['native']); ?></p>
                            </a>
                            <div class="dropdown-nav">
                                <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($code != LaravelLocalization::getCurrentLocale()): ?>
                                        <a href="<?php echo e($lang == config()->get('app.locale') ? LaravelLocalization::getNonLocalizedURL() : LaravelLocalization::getLocalizedURL($code)); ?>"
                                            class="dropdown-links">
                                            <img src="/assets/images/<?php echo e($code); ?>.png" alt="">
                                            <?php echo e($lang['native']); ?>

                                        </a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="header__bottom">
            <div class="container">
                <div class="header__bottom-content">
                    <div class="header__bottom-left">
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset('assets/images/logo.svg')); ?>" alt=""
                                class="header__bottom-logo">
                        </a>
                        <button class="header__catalog js-menu">
                            <div class="hamburger">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                            <span>Каталог</span>
                        </button>
                        <div class="header__bottom-input">
                            <i class="icon-search"></i>
                            <input type="text" class="js-search-input" placeholder="<?php echo app('translator')->get('main.navbar.search'); ?>">
                            <ul class="header__bottom-search">

                            </ul>
                        </div>
                    </div>
                    <div class="header__bottom-right">
                        <div class="header__bottom-blog">
                            <button class="js-login header__bottom-link">
                                <svg class="mr-xs" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                    <circle cx="12" cy="6" r="4" stroke="currentColor" stroke-width="1.5"/>
                                    <path d="M19.9975 18C20 17.8358 20 17.669 20 17.5C20 15.0147 16.4183 13 12 13C7.58172 13 4 15.0147 4 17.5C4 19.9853 4 22 12 22C14.231 22 15.8398 21.8433 17 21.5634" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                </svg>
                                <div>
                                    
                                    <p><?php echo e(auth()->check() ? auth()->user()->first_name : trans('main.navbar.login')); ?></p>
                                </div>
                            </button>
                            <div class="header__bottom-modal js-login-modal hide">
                                <?php if(auth()->check()): ?>
                                    <div class="text-black text-upper mb-sm"><?php echo app('translator')->get('main.hello'); ?>,
                                        <?php echo e(auth()->user()->first_name); ?></div>
                                    <a href="<?php echo e(route('frontend.cabinet.index')); ?>/#/orders"
                                        class="text-blue mb-sm d-block"><?php echo app('translator')->get('main.my_order'); ?></a>
                                    <a href="<?php echo e(route('frontend.cabinet.index')); ?>/#/profile"
                                        class="text-blue mb-sm d-block"><?php echo app('translator')->get('main.settings'); ?></a>
                                    <a href="<?php echo e(route('frontend.user.logout')); ?>"
                                        class="header__bottom-btn text-white bg-blue"><?php echo app('translator')->get('main.navbar.logout'); ?></a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('frontend.user.getLogin')); ?>"
                                        class="header__bottom-btn text-white bg-blue"><?php echo app('translator')->get('main.navbar.login'); ?></a>
                                    <a href="<?php echo e(route('frontend.user.getRegister')); ?>"
                                        class="header__bottom-btn"><?php echo app('translator')->get('main.navbar.register'); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="header__bottom-blog">
                            <a href="<?php echo e(route('product.favorite')); ?>" class="header__bottom-link">
                                <svg class="mr-xs" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                    <path d="M8.96173 18.9109L9.42605 18.3219L8.96173 18.9109ZM12 5.50063L11.4596 6.02073C11.601 6.16763 11.7961 6.25063 12 6.25063C12.2039 6.25063 12.399 6.16763 12.5404 6.02073L12 5.50063ZM15.0383 18.9109L15.5026 19.4999L15.0383 18.9109ZM7.00061 16.4209C6.68078 16.1577 6.20813 16.2036 5.94491 16.5234C5.68169 16.8432 5.72758 17.3159 6.04741 17.5791L7.00061 16.4209ZM2.34199 13.4115C2.54074 13.7749 2.99647 13.9084 3.35988 13.7096C3.7233 13.5108 3.85677 13.0551 3.65801 12.6917L2.34199 13.4115ZM2.75 9.1371C2.75 6.98623 3.96537 5.18252 5.62436 4.42419C7.23607 3.68748 9.40166 3.88258 11.4596 6.02073L12.5404 4.98053C10.0985 2.44352 7.26409 2.02539 5.00076 3.05996C2.78471 4.07292 1.25 6.42503 1.25 9.1371H2.75ZM8.49742 19.4999C9.00965 19.9037 9.55954 20.3343 10.1168 20.6599C10.6739 20.9854 11.3096 21.25 12 21.25V19.75C11.6904 19.75 11.3261 19.6293 10.8736 19.3648C10.4213 19.1005 9.95208 18.7366 9.42605 18.3219L8.49742 19.4999ZM15.5026 19.4999C16.9292 18.3752 18.7528 17.0866 20.1833 15.4758C21.6395 13.8361 22.75 11.8026 22.75 9.1371H21.25C21.25 11.3345 20.3508 13.0282 19.0617 14.4798C17.7469 15.9603 16.0896 17.1271 14.574 18.3219L15.5026 19.4999ZM22.75 9.1371C22.75 6.42503 21.2153 4.07292 18.9992 3.05996C16.7359 2.02539 13.9015 2.44352 11.4596 4.98053L12.5404 6.02073C14.5983 3.88258 16.7639 3.68748 18.3756 4.42419C20.0346 5.18252 21.25 6.98623 21.25 9.1371H22.75ZM14.574 18.3219C14.0479 18.7366 13.5787 19.1005 13.1264 19.3648C12.6739 19.6293 12.3096 19.75 12 19.75V21.25C12.6904 21.25 13.3261 20.9854 13.8832 20.6599C14.4405 20.3343 14.9903 19.9037 15.5026 19.4999L14.574 18.3219ZM9.42605 18.3219C8.63014 17.6945 7.82129 17.0963 7.00061 16.4209L6.04741 17.5791C6.87768 18.2624 7.75472 18.9144 8.49742 19.4999L9.42605 18.3219ZM3.65801 12.6917C3.0968 11.6656 2.75 10.5033 2.75 9.1371H1.25C1.25 10.7746 1.66995 12.1827 2.34199 13.4115L3.65801 12.6917Z" fill="currentColor"/>
                                </svg>
                                <div class="d-flex align-items-center">
                                    <p>Избранное</p>
                                    <?php
                                        $favorite_count = collect(json_decode(request()->cookie('user_favorite_list', '[]')))->count();
                                    ?>
                                    <span
                                        class="header__bottom-count js-total-favorite"><?php echo e($favorite_count ? $favorite_count : '0'); ?>

                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="header__bottom-blog">
                            <a href="<?php echo e(route('frontend.cart.list')); ?>" class="header__bottom-link">
                                <svg class="mr-xs" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                    <path d="M3.864 16.4552C4.40967 18.6379 4.68251 19.7292 5.49629 20.3646C6.31008 21 7.435 21 9.68486 21H14.3155C16.5654 21 17.6903 21 18.5041 20.3646C19.3179 19.7292 19.5907 18.6379 20.1364 16.4552C20.9943 13.0234 21.4233 11.3075 20.5225 10.1538C19.6217 9 17.853 9 14.3155 9H9.68486C6.14745 9 4.37875 9 3.47791 10.1538C2.94912 10.831 2.87855 11.702 3.08398 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                    <path d="M19.5 9.5L18.7896 6.89465C18.5157 5.89005 18.3787 5.38775 18.0978 5.00946C17.818 4.63273 17.4378 4.34234 17.0008 4.17152C16.5619 4 16.0413 4 15 4M4.5 9.5L5.2104 6.89465C5.48432 5.89005 5.62128 5.38775 5.90221 5.00946C6.18199 4.63273 6.56216 4.34234 6.99922 4.17152C7.43808 4 7.95872 4 9 4" stroke="currentColor" stroke-width="1.5"/>
                                    <path d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4C15 4.55228 14.5523 5 14 5H10C9.44772 5 9 4.55228 9 4Z" stroke="currentColor" stroke-width="1.5"/>
                                </svg>
                                
                                <div class="d-flex align-items-center">
                                    <p><?php echo app('translator')->get('main.navbar.cart'); ?></p>
                                    <span
                                    class="header__bottom-count js-cart-count"><?php echo e(Cart::getContent()->count()); ?></span>
                                    
                                </div>
                            </a>
                        </div>
                        
                    </div>
                </div>
                <div class="d-flex align-content-center justify-content-between">
                    <div class="header__bottom-input header__bottom-input--sm">
                        <i class="icon-search"></i>
                        <input type="text" class="js-search-input" placeholder="<?php echo app('translator')->get('main.navbar.search'); ?>">
                        <ul class="header__bottom-search">
    
                        </ul>
                    </div>
                    <button class="header__catalog header__catalog--sm js-menu">
                        <div class="hamburger">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <span>Каталог</span>
                    </button>
                </div>
            </div>
        </div>

        

        <div class="menu dropdown-menu" role="menu">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <ul class="menu__nav">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu__nav-item" data-menu="link-<?php echo e($key); ?>">
                                    <div class="d-flex align-content-center justify-content-between full-width">
                                        <div class="menu__nav-text">
                                            <a href="<?php echo e(route('frontend.product.index', [$category->alias])); ?>">
                                                <img src="<?php echo e(Upload::hasFile('category', $category->id) ? Upload::getFile('category', $category->id) : ''); ?>"
                                                    alt="" class="menu__nav-img">
                                                <?php echo e($category->name); ?>

                                            </a>
                                        </div>
                                        <i class="icon-arrow-right"></i>
                                    </div>
                                    <?php if(!$category->isLeaf()): ?>
                                        <ul class="menu__nav-sub">
                                            <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <a
                                                        href="<?php echo e(route('frontend.product.index', [$category->alias, $subcat->alias])); ?>"><?php echo e($subcat->name); ?></a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="col-md-9 menu-sm-hide">
                        <div class="menu__content">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="menu__content-item" id="link-<?php echo e($key); ?>">
                                    <?php if(!$category->isLeaf()): ?>
                                        <div class="menu__content-blog">
                                            <?php $__currentLoopData = $category->children->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="menu__content-links">
                                                    <ul>
                                                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li>
                                                                <a
                                                                    href="<?php echo e(route('frontend.product.index', [$category->alias, $subcat->alias])); ?>"><?php echo e($subcat->name); ?></a>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    

    <?php echo $__env->yieldContent('content'); ?>

    

    <footer class="footer">
        <div class="container">
            <div class="footer__content py-layout-xs">
                <div class="footer__blog">
                    <p class="footer__blog-title"><?php echo app('translator')->get('main.car_brands'); ?></p>
                    <ul>
                        <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a
                                    href="<?php echo e(route('frontend.product.manufacturer', $manufacturer->alias)); ?>"><?php echo e($manufacturer->name); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="footer__blog">
                    <p class="footer__blog-title">Компания</p>
                    <ul>
                        <li>
                            <a href="<?php echo e(route('page.show', 'o-nas')); ?>"><?php echo app('translator')->get('main.about'); ?></a>
                        </li>
                        
                        <li>
                            <a href="<?php echo e(route('frontend.blog.index')); ?>"><?php echo app('translator')->get('main.our_blog'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.contact.index')); ?>"><?php echo app('translator')->get('main.top.contact'); ?></a>
                        </li>
                    </ul>
                </div>
                <div class="footer__blog">
                    <p class="footer__blog-title">Помощь покупателю</p>
                    <ul>            
                        <li>
                            <a href="<?php echo e(route('page.show', 'oplata-i-dostavka')); ?>"><?php echo app('translator')->get('main.top.delivery_and_payment'); ?></a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('help')); ?>">Вопрос-ответ</a>
                        </li>
                        
                        <li>
							<a href="<?php echo e(route('page.show', 'publicnaia-oferat')); ?>">Публичная оферта</a>
						</li>
                    </ul>
                </div>
                <div class="footer__blog">    
                    <p class="footer__blog-title">Для связи</p>
                    <div class="d-flex mb-sm">
                        <svg class="mr-xs" xmlns="http://www.w3.org/2000/svg" width="25px" height="23px" viewBox="0 0 24 24" fill="none">
                            <path d="M4.00655 7.93309C3.93421 9.84122 4.41713 13.0817 7.6677 16.3323C8.45191 17.1165 9.23553 17.7396 10 18.2327M5.53781 4.93723C6.93076 3.54428 9.15317 3.73144 10.0376 5.31617L10.6866 6.4791C11.2723 7.52858 11.0372 8.90532 10.1147 9.8278C10.1147 9.8278 10.1147 9.8278 10.1147 9.8278C10.1146 9.82792 8.99588 10.9468 11.0245 12.9755C13.0525 15.0035 14.1714 13.8861 14.1722 13.8853C14.1722 13.8853 14.1722 13.8853 14.1722 13.8853C15.0947 12.9628 16.4714 12.7277 17.5209 13.3134L18.6838 13.9624C20.2686 14.8468 20.4557 17.0692 19.0628 18.4622C18.2258 19.2992 17.2004 19.9505 16.0669 19.9934C15.2529 20.0243 14.1963 19.9541 13 19.6111" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                        </svg>
                        <div>
                            <a href="tel:<?php echo e(str_replace(' ', '',App\Models\Setting::where('atribute', 'phone_1')->first()->value_one)); ?>"><?php echo e(App\Models\Setting::where('atribute', 'phone_1')->first()->value_one); ?></a><br>
                            <a href="tel:<?php echo e(str_replace(' ', '',App\Models\Setting::where('atribute', 'phone_2')->first()->value_one)); ?>"><?php echo e(App\Models\Setting::where('atribute', 'phone_2')->first()->value_one); ?></a>
                        </div>
                    </div>
                    <p class="d-flex align-items-center mb-sm">
                        <svg class="mr-xs" xmlns="http://www.w3.org/2000/svg" width="25px" height="20px" viewBox="0 0 24 24" fill="none">
                            <path d="M22 14.0001C22 17.7713 22 19.6569 20.8284 20.8285C19.6569 22.0001 17.7712 22.0001 14 22.0001H10C6.22876 22.0001 4.34315 22.0001 3.17157 20.8285C2 19.6569 2 17.7713 2 14.0001C2 10.2288 2 8.34322 3.17157 7.17164C3.82475 6.51846 4.69989 6.22944 6 6.10156M18 6.10156C19.3001 6.22944 20.1752 6.51846 20.8284 7.17164C21.4816 7.82481 21.7706 8.69993 21.8985 10" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M10 6H14" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M11 9H13" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M14 2.00195C15.7066 2.01642 16.6474 2.11117 17.2678 2.73158C18 3.46381 18 4.64232 18 6.99935V9.0626C18 9.52324 18 9.75356 17.9056 9.95513C17.8112 10.1567 17.6342 10.3041 17.2804 10.599L16.5607 11.1987M10 2.00195C8.29344 2.01642 7.35264 2.11117 6.73223 2.73158C6 3.46381 6 4.64232 6 6.99935V9.0626C6 9.52324 6 9.75356 6.09441 9.95513C6.18882 10.1567 6.36576 10.3041 6.71963 10.599L8.1589 11.7984C9.99553 13.329 10.9139 14.0942 12 14.0942C12.6493 14.0942 13.2386 13.8207 14 13.2738" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                        </svg>
                        <a href="">simmastar@mail.ru</a>
                    </p>
                    <p class="d-flex mb-sm">
                        <svg class="mr-xs" xmlns="http://www.w3.org/2000/svg" width="25px" height="20px" viewBox="0 0 24 24" fill="none">
                            <path d="M5.875 12.5729C5.30847 11.2498 5 9.84107 5 8.51463C5 4.9167 8.13401 2 12 2C15.866 2 19 4.9167 19 8.51463C19 12.0844 16.7658 16.2499 13.2801 17.7396C12.4675 18.0868 11.5325 18.0868 10.7199 17.7396C9.60664 17.2638 8.62102 16.5151 7.79508 15.6" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M14 9C14 10.1046 13.1046 11 12 11C10.8954 11 10 10.1046 10 9C10 7.89543 10.8954 7 12 7C13.1046 7 14 7.89543 14 9Z" stroke="#fff" stroke-width="1.5"/>
                            <path d="M20.9605 15.5C21.6259 16.1025 22 16.7816 22 17.5C22 18.4251 21.3797 19.285 20.3161 20M3.03947 15.5C2.37412 16.1025 2 16.7816 2 17.5C2 19.9853 6.47715 22 12 22C13.6529 22 15.2122 21.8195 16.5858 21.5" stroke="#fff" stroke-width="1.5" stroke-linecap="round"/>
                        </svg>
                        <?php echo app('translator')->get('main.address_info'); ?>
                    </p>

                    <div class="footer__blog-social">
                        <a href="">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#fff" preserveAspectRatio="xMidYMid" width="14.906" height="19" viewBox="0 0 14.906 32">
                                <path d="M14.874,11.167 L14.262,14.207 C14.062,15.208 13.100,15.992 12.072,15.992 L10.000,15.992 L10.000,30.000 C10.000,31.104 9.159,32.000 8.049,32.000 L5.030,32.000 C3.920,32.000 3.017,31.102 3.017,29.999 L3.017,15.992 L2.011,15.992 C0.901,15.992 -0.002,15.095 -0.002,13.991 L-0.002,10.990 C-0.002,9.887 0.901,8.989 2.011,8.989 L3.017,8.989 L3.017,6.003 C3.017,2.716 5.693,0.041 8.994,0.013 C9.015,0.012 9.033,0.001 9.055,0.001 L13.081,0.001 C13.636,0.001 14.000,0.448 14.000,1.000 L14.000,6.000 C14.000,6.553 13.636,7.004 13.081,7.004 L10.061,7.004 L10.060,8.989 L13.079,8.989 C13.645,8.989 14.167,9.228 14.509,9.644 C14.852,10.059 14.985,10.615 14.874,11.167 ZM9.092,10.990 C9.078,10.991 9.067,10.998 9.053,10.998 L9.053,10.998 C8.497,10.997 8.046,10.549 8.047,9.997 L8.047,9.990 C8.047,9.990 8.047,9.990 8.047,9.990 C8.047,9.990 8.047,9.990 8.047,9.990 L8.049,6.003 C8.049,5.450 8.499,5.003 9.055,5.003 L12.074,5.003 L12.074,2.002 L9.094,2.002 C9.077,2.002 9.063,2.011 9.045,2.011 C6.831,2.011 5.030,3.802 5.030,6.003 L5.030,10.005 C5.030,10.558 4.579,11.006 4.023,11.006 C3.996,11.006 3.973,10.992 3.946,10.990 L2.011,10.990 L2.011,13.991 L4.023,13.991 C4.579,13.991 5.030,14.439 5.030,14.992 C5.030,15.044 5.008,15.088 5.000,15.138 L5.000,30.000 L8.049,29.999 L8.049,15.002 C8.049,14.998 8.047,14.995 8.047,14.992 C8.047,14.439 8.497,13.991 9.053,13.991 L12.072,13.991 C12.145,13.991 12.275,13.886 12.288,13.816 L12.857,10.990 L9.092,10.990 Z"/>
                            </svg>
                        </a>
                        <a href="https://www.instagram.com/simma_auto_star_/" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48" fill="#fff">
                                <title>instagram</title>
                                <g id="Layer_2" data-name="Layer 2">
                                  <g id="invisible_box" data-name="invisible box">
                                    <rect width="48" height="48" fill="none"/>
                                    <rect width="48" height="48" fill="none"/>
                                  </g>
                                  <g id="icons_Q2" data-name="icons Q2">
                                    <path d="M24,7.6h8.1a10.8,10.8,0,0,1,3.7.7,6.7,6.7,0,0,1,3.8,3.8,10.8,10.8,0,0,1,.7,3.7c.1,2.1.1,2.8.1,8.1s0,6-.1,8.1a10.8,10.8,0,0,1-.7,3.7,6.7,6.7,0,0,1-3.8,3.8,10.8,10.8,0,0,1-3.7.7H15.9a10.8,10.8,0,0,1-3.7-.7,6.7,6.7,0,0,1-3.8-3.8,10.8,10.8,0,0,1-.7-3.7c-.1-2.1-.1-2.8-.1-8.1s0-6,.1-8.1a10.8,10.8,0,0,1,.7-3.7,6.7,6.7,0,0,1,3.8-3.8,10.8,10.8,0,0,1,3.7-.7H24M24,4H15.8a17.9,17.9,0,0,0-4.9.9A10,10,0,0,0,7.4,7.4a8.5,8.5,0,0,0-2.3,3.5,14.5,14.5,0,0,0-1,4.9C4,17.9,4,18.6,4,24s0,6.1.1,8.2a14.5,14.5,0,0,0,1,4.9,8.5,8.5,0,0,0,2.3,3.5,8.5,8.5,0,0,0,3.5,2.3,14.5,14.5,0,0,0,4.9,1H32.2a14.5,14.5,0,0,0,4.9-1,8.5,8.5,0,0,0,3.5-2.3A10,10,0,0,0,43,37.1a17.9,17.9,0,0,0,.9-4.9c.1-2.1.1-2.8.1-8.2s0-6.1-.1-8.2a17.9,17.9,0,0,0-.9-4.9,10,10,0,0,0-2.4-3.5A10,10,0,0,0,37.1,5a17.9,17.9,0,0,0-4.9-.9H24"/>
                                    <path d="M24,13.7A10.3,10.3,0,1,0,34.3,24,10.3,10.3,0,0,0,24,13.7m0,17A6.7,6.7,0,1,1,30.7,24,6.7,6.7,0,0,1,24,30.7"/>
                                    <path d="M37.1,13.3a2.4,2.4,0,1,1-2.4-2.4,2.4,2.4,0,0,1,2.4,2.4"/>
                                  </g>
                                </g>
                            </svg>
                        </a>
                        <a href="https://t.me/simma_autoStar" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#fff" viewBox="0 0 32 32"><path d="M 26.070313 3.996094 C 25.734375 4.011719 25.417969 4.109375 25.136719 4.21875 L 25.132813 4.21875 C 24.847656 4.332031 23.492188 4.902344 21.433594 5.765625 C 19.375 6.632813 16.703125 7.757813 14.050781 8.875 C 8.753906 11.105469 3.546875 13.300781 3.546875 13.300781 L 3.609375 13.277344 C 3.609375 13.277344 3.25 13.394531 2.875 13.652344 C 2.683594 13.777344 2.472656 13.949219 2.289063 14.21875 C 2.105469 14.488281 1.957031 14.902344 2.011719 15.328125 C 2.101563 16.050781 2.570313 16.484375 2.90625 16.722656 C 3.246094 16.964844 3.570313 17.078125 3.570313 17.078125 L 3.578125 17.078125 L 8.460938 18.722656 C 8.679688 19.425781 9.949219 23.597656 10.253906 24.558594 C 10.433594 25.132813 10.609375 25.492188 10.828125 25.765625 C 10.933594 25.90625 11.058594 26.023438 11.207031 26.117188 C 11.265625 26.152344 11.328125 26.179688 11.390625 26.203125 C 11.410156 26.214844 11.429688 26.21875 11.453125 26.222656 L 11.402344 26.210938 C 11.417969 26.214844 11.429688 26.226563 11.441406 26.230469 C 11.480469 26.242188 11.507813 26.246094 11.558594 26.253906 C 12.332031 26.488281 12.953125 26.007813 12.953125 26.007813 L 12.988281 25.980469 L 15.871094 23.355469 L 20.703125 27.0625 L 20.8125 27.109375 C 21.820313 27.550781 22.839844 27.304688 23.378906 26.871094 C 23.921875 26.433594 24.132813 25.875 24.132813 25.875 L 24.167969 25.785156 L 27.902344 6.65625 C 28.007813 6.183594 28.035156 5.742188 27.917969 5.3125 C 27.800781 4.882813 27.5 4.480469 27.136719 4.265625 C 26.769531 4.046875 26.40625 3.980469 26.070313 3.996094 Z M 25.96875 6.046875 C 25.964844 6.109375 25.976563 6.101563 25.949219 6.222656 L 25.949219 6.234375 L 22.25 25.164063 C 22.234375 25.191406 22.207031 25.25 22.132813 25.308594 C 22.054688 25.371094 21.992188 25.410156 21.667969 25.28125 L 15.757813 20.75 L 12.1875 24.003906 L 12.9375 19.214844 C 12.9375 19.214844 22.195313 10.585938 22.59375 10.214844 C 22.992188 9.84375 22.859375 9.765625 22.859375 9.765625 C 22.886719 9.3125 22.257813 9.632813 22.257813 9.632813 L 10.082031 17.175781 L 10.078125 17.15625 L 4.242188 15.191406 L 4.242188 15.1875 C 4.238281 15.1875 4.230469 15.183594 4.226563 15.183594 C 4.230469 15.183594 4.257813 15.171875 4.257813 15.171875 L 4.289063 15.15625 L 4.320313 15.144531 C 4.320313 15.144531 9.53125 12.949219 14.828125 10.71875 C 17.480469 9.601563 20.152344 8.476563 22.207031 7.609375 C 24.261719 6.746094 25.78125 6.113281 25.867188 6.078125 C 25.949219 6.046875 25.910156 6.046875 25.96875 6.046875 Z"/></svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__copyright">
            <div class="container">
                <div class="footer__bottom">
                    <?php echo app('translator')->get('main.capyright'); ?>
                    
                </div>
            </div>
        </div>
    </footer>
    
    <div class="overlay"></div>
    
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mask.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('assets/js/jquery.rateyo.min.js')); ?>"></script>
    <script src="<?php echo e(mix('frontend/main.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/toastify.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/shop.js?v=1.2')); ?>"></script>
    
    <script src="<?php echo e(mix('frontend/search.min.js')); ?>"></script>
    
    <?php echo $__env->yieldContent('scripts'); ?>
    
    <script type="text/javascript">
        new Shop({
            favoriteUrl: "<?php echo e(route('product.sync-favorite')); ?>",
            addCartUrl: "<?php echo e(route('cart.add')); ?>",
            cartListUrl: "<?php echo e(route('frontend.cart.list')); ?>",
            toCart: "<?php echo app('translator')->get('main.to_cart'); ?>"
        }).init()

        new Search({
            container: '.header__bottom-search',
            input: '.js-search-input',
            url: "<?php echo e(route('frontend.product.search')); ?>"
        })
        new Main()
        // Toastify({
        //     text: 'Сайт находится в тестовом режиме',
        //     className: "toastify",
        //     duration: 20000,
        //     gravity: "bottom",
        //     position: "right",
        //     close: false,
        //     newWindow: true,
        //     style: {
        //         background: '#0643DA',
        //     }
        // }).showToast()
    </script>
</body>

</html>
<?php /**PATH /home/simmaautostar/public_html/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>