<?php $__env->startSection('content'); ?>
    <section class="login pb-layout pt-layout-xs">
        <div class="container">
            <h1 class="title text-center"><?php echo app('translator')->get('auth.login.title'); ?></h1>
            <div class="row">
                <form action="<?php echo e(route('frontend.user.postLogin')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="col-lg-6 col-lg-push-3">
                        <div class="login__blog bg-white">
                            <div class="form-group">
                                <input type="text" name="phone" value="<?php echo e(request()->old('phone', '998')); ?>" class="input js-phone-mask" placeholder="<?php echo app('translator')->get('auth.login.phone'); ?>">
                            </div>
                            <div class="form-group">
                                <input type="password" name="password" class="input" placeholder="<?php echo app('translator')->get('auth.login.password'); ?>">                                
                            </div>
                            <?php if(session()->has('error')): ?>
                                <div class="form-group--error">
                                    <label class="form-group__error"><?php echo e(session()->get('error')); ?></label>
                                </div>
                            <?php endif; ?>
                            <div class="login__blog-checkbox">
                                <label class="checkbox"><?php echo app('translator')->get('auth.login.remember'); ?>
                                    <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <span class="checkmark"></span>
                                </label>
                                
                            </div>
                            <button type="submit" class="btn"><?php echo app('translator')->get('auth.login.submit'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/jquery.mask.min.js')); ?>"></script>
<script>
    $(".js-phone-mask").mask("+999(99)999-99-99", { autoclear: false });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/simmaautostar/public_html/resources/views/frontend/user/login.blade.php ENDPATH**/ ?>