<?php $__env->startSection('content'); ?>
<div id="app"> 
	<section class="cabinet py-layout-xs">
		
		<div class="container">
			<ul class="breadcrumb">
		    	<li class="breadcrumb__item">
                    <a href="<?php echo e(route('home')); ?>">Главная</a>
		    	</li>
		    	<li class="breadcrumb__item">
                    <a href="<?php echo e(route('frontend.cabinet.index')); ?>">Кабинет</a>
		    	</li>
		 	</ul>
		</div>
		
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-4">
					<div class="cabinet__content rounded b-a">
						<div class="cabinet__user p-sm ml-xs mt-xs">
                            <h1 class="cabinet__user-title"><?php echo e($user->first_name); ?></h1>
                            <p class="cabinet__user-id">ID: <?php echo e($user->id); ?></p>
						</div>
						<ul class="cabinet__nav">
							<li class="cabinet__nav-item b-b">
                                <router-link :to="{ name: 'orders'}" class="cabinet__nav-link"
                                    exact-active-class="active">
                                    <i class="icon-box"></i>
                                    <?php echo app('translator')->getFromJson('cabinet.navbar.order'); ?>
                                </router-link>
							</li>
							<li class="cabinet__nav-item b-b">								
                                <router-link :to="{ name: 'favorite'}" class="cabinet__nav-link"
                                    exact-active-class="active">
                                    <i class="icon-heart-o"></i>
                                    <?php echo app('translator')->getFromJson('cabinet.navbar.favorite'); ?>
                                </router-link>
							</li>
							<li class="cabinet__nav-item b-b">								
                                <router-link :to="{ name: 'profile'}" class="cabinet__nav-link"
                                    exact-active-class="active">
                                    <i class="icon-resume"></i>
                                    <?php echo app('translator')->getFromJson('cabinet.navbar.profile'); ?>
                                </router-link>								
							</li>
							<li class="cabinet__nav-item b-b">								
                                <router-link :to="{ name: 'address'}" class="cabinet__nav-link"
                                    exact-active-class="active">
                                    <i class="icon-location-point"></i>
                                    <?php echo app('translator')->getFromJson('cabinet.navbar.address'); ?>
                                </router-link>								
							</li>
							<li class="cabinet__nav-item">
                                <router-link :to="{ name: 'notification'}" class="cabinet__nav-link"
                                exact-active-class="active">
									<i class="icon-alarm"></i>
									<?php echo app('translator')->getFromJson('cabinet.navbar.notification'); ?>
                                </router-link>								
							</li>
						</ul>
					</div>
				</div>
				<div class="col-lg-9 col-md-8">
                    <!-- set router view -->
                    <router-view></router-view>                    
				</div>
			</div>
		</div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('js/cabinet.js')); ?>"></script>
<script>
    window.trans = <?php
        $cabinet = File::glob(resource_path('lang/' . app()->getLocale() . '/cabinet.php'));
        $trans = [];        
        foreach ($cabinet as $f) {
            $filename = basename($f, '.php');
            $trans[$filename] = trans($filename);
        }
        echo json_encode($trans);        
    ?>;    
    window.lang = '<?php echo e(app()->getLocale()); ?>'
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbook/domains/parts/resources/views/frontend/cabinet/main.blade.php ENDPATH**/ ?>