<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://fonts.googleapis.com/css?family=Lato:400,700|Roboto:400,500,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.min.css')); ?>">
    <?php echo $__env->yieldContent('styles'); ?>
    <title>Parts</title>
</head>
<body>
	
    <header class="header">
    	<div class="header__top">
    		<div class="container">
	    		<div class="header__top-content">
	    			<ul class="header__top-nav">
	    				<li class="js-menu">
	    					<div class="hamburger">
				                <span></span>
				                <span></span>
				                <span></span>
				            </div>
	    					<button><?php echo app('translator')->getFromJson('main.top.catalog'); ?></button>
	    				</li>
	    				<li>
	    					<a href=""><?php echo app('translator')->getFromJson('main.top.delivery_and_payment'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('help')); ?>"><?php echo app('translator')->getFromJson('main.top.help'); ?></a>
	    				</li>
	    				<li>
                            <a href="<?php echo e(route('frontend.contact.index')); ?>"><?php echo app('translator')->getFromJson('main.top.contact'); ?></a>
	    				</li>
	    			</ul>
	    			<div class="header__top-right">
	    				<div class="header__top-checked">
	    					<img src="<?php echo e(asset('assets/images/checked.svg')); ?>" alt="checked">
	    					<span><?php echo app('translator')->getFromJson('main.top.check_vin'); ?></span>
	    				</div>
	    				<div class="dropdown">
	                        <a href="#">                            
	                            <p class="d-inline-block"><?php echo e(LaravelLocalization::getSupportedLocales()[app()->getLocale()]['native']); ?></p>
	                            <i class="icon-dropdown"></i>
	                        </a>
	                        <div class="dropdown-nav">
                                <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($code != LaravelLocalization::getCurrentLocale()): ?>
                                    <a href="<?php echo e($lang == config()->get('app.locale') ? LaravelLocalization::getNonLocalizedURL() : LaravelLocalization::getLocalizedURL($code)); ?>" class="dropdown-links"><?php echo e($lang['native']); ?></a>
                                    <?php endif; ?>      
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                
	                        </div>
	                    </div>
	    			</div>
	    		</div>
	    	</div>
    	</div>
    	<div class="header__bottom">
    		<div class="container">
    			<div class="header__bottom-content">
    				<div class="header__bottom-left">
                        <a href="<?php echo e(route('home')); ?>">
    						<img src="<?php echo e(asset('assets/images/logo.jpg')); ?>" alt="" class="header__bottom-logo">
    					</a>
    					<div class="header__bottom-input">
    						<i class="icon-search"></i>
    						<input type="text" placeholder="<?php echo app('translator')->getFromJson('main.navbar.search'); ?>">
    					</div>
    				</div>
    				<div class="header__bottom-right">
    					<div class="header__bottom-blog">
    						<div>
    							<p>+998 (78) 141-77-77</p>
    							<span><?php echo app('translator')->getFromJson('main.navbar.call'); ?></span>
    						</div>
    					</div>
    					<div class="header__bottom-blog">
    						<button class="js-login header__bottom-link">
    							<img src="<?php echo e(asset('assets/images/user.svg')); ?>" alt="">
    							<div>
	    							<p><?php echo app('translator')->getFromJson('main.navbar.cabinet'); ?></p>
                                    <span><?php echo e(auth()->check() ? auth()->user()->first_name : trans('main.navbar.login')); ?></span>
	    						</div>
                            </button>                            
    						<div class="header__bottom-modal js-login-modal hide">
                                <?php if(auth()->check()): ?>
                                <div class="text-black text-upper mb-sm">ЗДРАВСТВУЙТЕ, <?php echo e(auth()->user()->first_name); ?></div>
                                <a href="<?php echo e(route('frontend.cabinet.index')); ?>/#/orders" class="text-blue mb-sm d-block">МОИ ЗАКАЗЫ</a>
                                <a href="<?php echo e(route('frontend.cabinet.index')); ?>/#/profile" class="text-blue mb-sm d-block">НАСТРОЙКИ</a>
                                <a href="<?php echo e(route('frontend.user.logout')); ?>" class="header__bottom-btn text-white bg-blue"><?php echo app('translator')->getFromJson('main.navbar.logout'); ?></a>
                                <?php else: ?>
                                <a href="<?php echo e(route('frontend.user.getLogin')); ?>" class="header__bottom-btn text-white bg-blue"><?php echo app('translator')->getFromJson('main.navbar.login'); ?></a>
                                <a href="<?php echo e(route('frontend.user.getRegister')); ?>" class="header__bottom-btn"><?php echo app('translator')->getFromJson('main.navbar.register'); ?></a>
                                <?php endif; ?>
                            </div>
    					</div>
    					<div class="header__bottom-blog">
                            <a href="<?php echo e(route('frontend.cart.index')); ?>" class="header__bottom-link">
    							<img src="<?php echo e(asset('assets/images/cart.svg')); ?>" alt="">
    							<span class="header__bottom-count">0</span>
	    						<div>
	    							<p><?php echo app('translator')->getFromJson('main.navbar.cart'); ?></p>
	    							<span><?php echo app('translator')->getFromJson('main.navbar.empty_cart'); ?></span>
	    						</div>
    						</a>
    					</div>
    				</div>
    			</div>
    		</div>
    	</div>
    	<div class="menu dropdown-menu" role="menu">
    		<div class="container">
    			<div class="row">
    				<div class="col-xs-3">
    					<ul class="menu__nav">
							<?php $__currentLoopData = [0,1,2,3,4,5,6,7,8]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    						<li class="menu__nav-item" data-menu="link-<?php echo e($key); ?>">
								<div class="menu__nav-text">
	    							<img src="<?php echo e(asset('assets/images/avto.svg')); ?>" alt="" class="menu__nav-img">
	    							Авто
								</div>
								<i class="icon-arrow-right"></i>
    						</li>
    						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    					</ul>
    				</div>
    				<div class="col-xs-9">
    					<div class="menu__content">
    						<?php $__currentLoopData = [0,1,2,3,4,5,6,7,8]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<div class="menu__content-item" id="link-<?php echo e($key); ?>">
								<h2 class="title">Авто</h2>
								<div class="menu__content-blog">
									<?php $__currentLoopData = [0,1,2,3,4]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<div class="menu__content-links">
											<p class="text-black font-medium mb-xs">Шины и диски</p>
											<ul>
												<li>
													<a href="">Шины</a>
												</li>
												<li>
													<a href="">Колесные диски</a>
												</li>
												<li>
													<a href="">Грузовые шины</a>
												</li>
												<li>
													<a href="">Мотошины</a>
												</li>
												<li>
													<a href="">Цепи противоскольжения</a>
												</li>
											</ul>
										</div>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</div>
							</div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</div>	
    				</div>
    			</div>
    		</div>
    	</div>
    </header>
    

	<?php echo $__env->yieldContent('content'); ?>
	
	
	<footer class="footer">
		<div class="container">
			<div class="footer__content py-layout-xs">
				<div class="footer__blog">
					<img src="<?php echo e(asset('assets/images/logo.svg')); ?>" alt="" class="footer__blog-logo">
					<p class="text-silver text-sm mb-sm font-medium">ЕСТЬ ВОПРОСЫ? ЗВОНИТЕ!</p>
					<p class="footer__blog-number">+998(78) 141-77-77</p>
					<p class="text-silver text-sm">Указанная стоимость товаров и условия их<br> приобретения действительны по состоянию<br> на текущую дату. </p>
				</div>
				<div class="footer__blog">
					<p class="footer__blog-title">Производители</p>
					<ul>
						<li>
							<a href="">АО "UzAutoMotors"</a>
						</li>
						<li>
							<a href="">АО "MAN"</a>
						</li>
						<li>
							<a href="">АО "KAMAZ"</a>
						</li>
						<li>
							<a href="">АО "UzAuto Trailer"</a>
						</li>
						<li>
							<a href="">АО "SamAuto"</a>
						</li>
					</ul>
				</div>
				<div class="footer__blog">
					<p class="footer__blog-title">UzAutoMarket</p>
					<ul>
						<li>
							<a href=""><?php echo app('translator')->getFromJson('main.top.catalog'); ?></a>
						</li>
						<li>
							<a href=""><?php echo app('translator')->getFromJson('main.top.delivery_and_payment'); ?></a>
						</li>
						<li>
							<a href="<?php echo e(route('frontend.contact.index')); ?>"><?php echo app('translator')->getFromJson('main.top.contact'); ?></a>
						</li>
						<li>
							<a href="<?php echo e(route('help')); ?>"><?php echo app('translator')->getFromJson('main.top.help'); ?></a>
						</li>
						<li>
							<a href="">Пользовательское соглашение</a>
						</li>
					</ul>
				</div>
				<div class="footer__blog">
					<p class="footer__blog-title">Мы принимаем</p>
					<div class="footer__blog-pay">
						<a href="">
							<img src="<?php echo e(asset('assets/images/click.svg')); ?>" alt="">
						</a>
						<a href="">
							<img src="<?php echo e(asset('assets/images/payme.svg')); ?>" alt="" class="mr-0">
						</a>
					</div>
					<p class="text-black font-bold mb-sm">Адрес</p>
					<p class="text-silver text-sm">г.Ташкент, Мирабадский<br> район, ул. Нукус,8</p>
					<div class="footer__blog-social">
						<a href="">
							<img src="<?php echo e(asset('assets/images/instagram.svg')); ?>" alt="">
						</a>
						<a href="">
							<img src="<?php echo e(asset('assets/images/facebook.svg')); ?>" alt="">
						</a>
						<a href="">
							<img src="<?php echo e(asset('assets/images/telegram.svg')); ?>" alt="">
						</a>
					</div>
				</div>
			</div>
		</div>
		<div class="footer__bottom">
			2019 © UzAutoMarket. Все права защищены.
		</div>
	</footer>
	<div class="overlay"></div>
	
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>    
    <script src="<?php echo e(asset('assets/js/slick.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.menu-aim.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.rateyo.min.js')); ?>"></script>    
    <?php echo $__env->yieldContent('scripts'); ?>
    <script type="text/javascript">
    	var $menu = $(".dropdown-menu");

        // jQuery-menu-aim: <meaningful part of the example>
        // Hook up events to be fired on menu row activation.
        $menu.menuAim({
            activate: activateSubmenu,
            deactivate: deactivateSubmenu
        });
        // jQuery-menu-aim: </meaningful part of the example>

        // jQuery-menu-aim: the following JS is used to show and hide the submenu
        // contents. Again, this can be done in any number of ways. jQuery-menu-aim
        // doesn't care how you do this, it just fires the activate and deactivate
        // events at the right times so you know when to show and hide your submenus.
        function activateSubmenu(row) {
            var $row = $(row),
                submenuId = $row.data("submenuId"),
                $submenu = $("#" + submenuId),
                height = $menu.outerHeight(),
                width = $menu.outerWidth();

            // Show the submenu
            $submenu.css({
                display: "block",
                top: -1,
                left: width - 3,  // main should overlay submenu
                height: height - 4  // padding for main dropdown's arrow
            });

            // Keep the currently activated row's highlighted look
            $row.find("a").addClass("maintainHover");
        }

        function deactivateSubmenu(row) {
            var $row = $(row),
                submenuId = $row.data("submenuId"),
                $submenu = $("#" + submenuId);

            // Hide the submenu and remove the row's highlighted look
            $submenu.css("display", "none");
            $row.find("a").removeClass("maintainHover");
        }

        // Bootstrap's dropdown menus immediately close on document click.
        // Don't let this event close the menu if a submenu is being clicked.
        // This event propagation control doesn't belong in the menu-aim plugin
        // itself because the plugin is agnostic to bootstrap.
        $(".dropdown-menu li").click(function(e) {
            e.stopPropagation();
        });

        $(document).click(function() {
            // Simply hide the submenu on any click. Again, this is just a hacked
            // together menu/submenu structure to show the use of jQuery-menu-aim.
            $(".popover").css("display", "none");
            $("a.maintainHover").removeClass("maintainHover");
        });
    </script>
</body>
</html><?php /**PATH /Users/macbook/domains/parts/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>