<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <div class="row m-0">
                <div class="col-sm-6">
                    <h4 class="m-t-0 m-b-30 header-title">Блог (Акция)</h4>            
                </div>
                <div class="col-sm-6">
                    <a href="<?php echo e(route('backend.blog.getform')); ?>" class="btn btn-success pull-right"><i class="fa fa-plus"></i> Добавить</a>
                </div>
            </div>
            <table id="datatable" class="table table-bordered table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                <thead>
                    <tr>                        
                        <th>ID</th>
                        <th>Заголовок</th>
                        <th>Краткое описание</th>
                        <th>Статуc</th>                        
                        <th style="width:120px;"></th>                   
                    </tr>
                </thead>
                <tbody>                   
                </tbody>
            </table>
        </div>
    </div>
</div> <!-- end row -->
<?php echo $__env->make('partials.ajax-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link href="<?php echo e(asset('backend/plugins/datatables/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css"/>
<link href="<?php echo e(asset('backend/plugins/datatables/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/crud.js')); ?>"></script>
<script>  
    var is_waiting = false;
    var form = "<?php echo e(route('backend.blog.getform')); ?>";
    var crud = new Crud({
        filter: true,
        list: {
            url: "<?php echo e(route('backend.blog.data')); ?>",
            datatable: {            
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'title_ru', name: 'title_ru'},
                    {data: 'short_text_ru', name: 'short_text_ru'}                    
                ],
                columnDefs: [
                    {
                        targets: 4,
                        data: null,
                        searchable:false, 
                        render: function (row, type, val, meta) {                        
                            return  '<a href="'+ form + '/' + val.id +'" class="btn btn-primary"><i class="fa fa-pencil"></i></a> '
                                 + crud.makeButton(val, 'btn-danger', '<i class="fa fa-trash"></i>', [
                                    ['toggle', 'modal'],
                                    ['target', '#removeModal']
                                ]);
                        }                        
                    },
                    {
                        targets: 3,
                        data: null,
                        searchable:false, 
                        render: function (row, type, val, meta) {
                            if (val.is_active) {
                               return '<a href="#" data-id="'+ val.id +'">'+ '<button class="btn btn-success js-status">Активен</button>' +'</a>'; 
                            } else {
                              return '<a href="#" data-id="'+ val.id +'">'+ '<button class="btn btn-danger js-status">Не активен</button>' +'</a>'; 
                            } 
                        }
                    },
                ]
            }
        },

        remove: {
            url: "<?php echo e(route('backend.blog.delete')); ?>",
        }
    });
    $('body').on('click', '.js-status', function(e) {
        e.preventDefault();
        var _ = $(this);        
        var status = _.parent(),
            id = status.data('id');       
        if(!is_waiting) {
            _.prepend('<i class="fa fa-spinner fa-spin"></i> ');
            _.prop('disabled', true);
            is_waiting = true;
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("backend.blog.status")); ?>',
                dataType: 'JSON',
                data: {'id': id},
                success:function(data) {
                    if (data.status) {
                        status.html('<button class="btn btn-success js-status">Активен</button>'); 
                    } else {
                        status.html('<button class="btn btn-danger js-status">Не активен</button>'); 
                    }
                    is_waiting = false;           
                }
            })
        }        
    })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/simmaautostar/public_html/resources/views/backend/blog/index.blade.php ENDPATH**/ ?>