<?php $__env->startSection('content'); ?>
    <div id="app">
        <section class="cabinet py-layout-xs">
            
            <div class="container">
                <ul class="breadcrumb">
                    <li class="breadcrumb__item">
                        <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('main.home'); ?></a>
                    </li>
                    <li class="breadcrumb__item">
                        <a href="<?php echo e(route('frontend.cabinet.index')); ?>"><?php echo app('translator')->get('main.navbar.cabinet'); ?></a>
                    </li>
                </ul>
            </div>
            
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-4">
                        <div class="cabinet__content rounded b-a">
                            <div class="cabinet__user p-sm ml-xs mt-xs">
                                <h1 class="cabinet__user-title"><?php echo e($user->full_name); ?></h1>
                                <p class="cabinet__user-id">ID: <?php echo e($user->id); ?></p>
                            </div>
                            <ul class="cabinet__nav">
                                <li class="cabinet__nav-item b-b">
                                    <router-link :to="{ name: 'orders' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <i class="icon-box"></i>
                                        <?php echo app('translator')->get('cabinet.navbar.order'); ?>
                                    </router-link>
                                </li>
                                <li class="cabinet__nav-item b-b">
                                    <router-link :to="{ name: 'mycar' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <img src="<?php echo e(asset('assets/images/sidebar-car.png')); ?>" alt=""
                                            height="21px">
                                        <?php echo app('translator')->get('main.my_cars'); ?>
                                    </router-link>
                                </li>
                                <li class="cabinet__nav-item b-b">
                                    <router-link :to="{ name: 'profile' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <i class="icon-resume"></i>
                                        <?php echo app('translator')->get('cabinet.navbar.profile'); ?>
                                    </router-link>
                                </li>
                                
                                <li class="cabinet__nav-item">
                                    <router-link :to="{ name: 'notification' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <i class="icon-alarm"></i>
                                        <?php echo app('translator')->get('cabinet.navbar.notification'); ?>
                                    </router-link>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-9 col-md-8">
                        <!-- set router view -->
                        <router-view></router-view>
                        <vue-progress-bar></vue-progress-bar>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        window.trans = <?php
        $lang_files = File::glob(resource_path('lang/' . App::getLocale() . '/*'));
        $trans = [];
        foreach ($lang_files as $f) {
            $filename = basename($f, '.php');
            $trans[$filename] = trans($filename);
        }
        echo json_encode($trans);
        ?>;
        window.lang = '<?php echo e(App::getLocale()); ?>';
    </script>
    <script src="<?php echo e(mix('js/cabinet.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/simmaautostar/public_html/resources/views/frontend/cabinet/main.blade.php ENDPATH**/ ?>