<?php $__env->startSection('content'); ?>
<?php if(Session::has('error')): ?>
    <div class="alert alert-danger alert-dismissable">
        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>
        <p class="mb-0"><?php echo Session::get('error'); ?></p>
    </div>
<?php endif; ?>

<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="alert alert-danger alert-dismissable">
        <button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>
        <p class="mb-0"><?php echo e($message); ?></p>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <div class="row m-0">
                <div class="col-sm-6">
                    <h4 class="m-t-0 m-b-30 header-title">Продукты</h4>            
                </div>
                <div class="col-sm-6">
                    <a href="<?php echo e(route('backend.product.getform')); ?>" class="btn btn-success pull-right"><i class="fa fa-plus"></i> Добавить</a>
                    
                </div>
                <table id="datatable" class="table table-bordered table-bordered dt-responsive nowrap" cellspacing="0"
                    width="100%">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Наименование</th>
                            <th>Цена</th>
                            <th>К-во на складе</th>
                            <th style="width:120px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div> <!-- end row -->
<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <form action="<?php echo e(route('import.product')); ?>" enctype="multipart/form-data" method="POST">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
               
                <div class="modal-body">
                    <?php echo csrf_field(); ?>
                    <input type="file" class="form-control" style="padding: 3px;" name="products" required />
                    <span for="">Тип файла: xlx,xls,xlsx</span>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Отменить</button>
                    <button type="submit" class="btn btn-primary">Сохранить</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php echo $__env->make('partials.ajax-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('backend/plugins/datatables/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('backend/plugins/datatables/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/crud.js')); ?>"></script>
    <script>
        var is_waiting = false;
        var form = "<?php echo e(route('backend.product.getform')); ?>";
        var crud = new Crud({
            filter: true,
            list: {
                url: "<?php echo e(route('backend.product.data')); ?>",
                datatable: {
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'name_ru',
                            name: 'name_ru'
                        },
                        {
                            data: 'price',
                            name: 'price'
                        },
                        {
                            data: 'quantity',
                            name: 'quantity',
                            searchable: false
                        }
                    ],
                    columnDefs: [{
                            targets: 3,
                            data: null,
                            class: 'text-nowrap',
                            render: function(row, type, val, meta) {
                                return "<input type='number' min='0' onKeyDown='return false' class='form-control js-change-quantity' value='" +
                                    val
                                    .quantity + "' data-id='" + val.id +
                                    "'/>";
                            }
                        },
                        {
                            targets: 4,
                            data: null,
                            searchable: false,
                            render: function(row, type, val, meta) {
                                console.log(val)
                                return '<a href="' + form + '/' + val.id +
                                    '" class="btn btn-primary"><i class="fa fa-pencil"></i></a> ' +
                                    (val.order_products_count == 0 ? crud.makeButton(val, 'btn-danger', '<i class="fa fa-trash"></i>', [
                                        ['toggle', 'modal'],
                                        ['target', '#removeModal']
                                    ]) : '');
                            }
                        },
                    ]
                }
            },

            remove: {
                url: "<?php echo e(route('backend.product.delete')); ?>",
            }
        });
        $('body').on('change', '.js-change-quantity', function(e) {
            e.preventDefault();
            var _ = $(this),
                id = _.data('id'),
                quantity = _.val();
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route('backend.product.change-quantity')); ?>',
                dataType: 'JSON',
                data: {
                    'id': id,
                    'quantity': quantity
                },
                success: function(data) {
                    if (data.status) {
                        crud.datatable.draw();
                    } else {
                        alert(data.message);
                    }
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbook/domains/parts/resources/views/backend/product/index.blade.php ENDPATH**/ ?>