<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card-box">
				<div class="row">
					<div class="col-md-6">
						<h4 class="header-title m-t-0 m-b-30">Заказ №:<?php echo e($order->id); ?></h4>
					</div>
					<div class="col-md-6 text-right">
						<a href="<?php echo e(route('backend.order.index')); ?>" class="btn btn-primary">Назад</a>
					</div>				
				</div>                
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-group pr-3">
                            <li class="list-group-item"><span class="font-bold">Ф.И.Ш:</span> <span
                                    class="ml-2"><?php echo e($order->full_name); ?></span></li>
                            <li class="list-group-item"><span class="font-bold">Номер телефона:</span> <span
                                    class="ml-2"><?php echo e($order->phone_number); ?></span></li>
                            <li class="list-group-item"><span class="font-bold">Дополнительный номер телефона:</span> <span
                                    class="ml-2"><?php echo e($order->additional_number); ?></span></li>
                            <?php if($order->delivery_type == 'express'): ?>
                                <li class="list-group-item"><span class="font-bold">Адрес:</span> <span
                                        class="ml-2"><?php echo e($order->address_format); ?></span></li>
                            <?php endif; ?>
                            <li class="list-group-item"><span class="font-bold">Комментарий:</span> <span
                                    class="ml-2"><?php echo e($order->comment); ?></span></li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="list-group pl-3">
                            <li class="list-group-item"><span class="font-bold">Время заказа:</span> <span
                                    class="ml-2"><?php echo e($order->created_at_format); ?></span></li>
                            <li class="list-group-item"><span class="font-bold">Вид доставки:</span> <span
                                    class="ml-2"><?php echo e($order->delivery_type_format); ?></span></li>
                            <li class="list-group-item"><span class="font-bold">Способы оплаты:</span> <span
                                    class="ml-2"><?php echo e($order->payment_type_format); ?> 
									<?php if($detail): ?>
									<button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#formModal">
									<i class="fa fa-cog"></i> Детали</button>
									<?php endif; ?>
									</span></li>
                            <li class="list-group-item"><span class="font-bold">Общая стоимость:</span> <span
                                    class="ml-2"><?php echo e($order->total_cost_format); ?> сум</span></li>
                            <li class="list-group-item"><span class="font-bold">Статус:</span> <span
                                    class="ml-2"><?php echo e($order->status_format); ?></span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php if($detail): ?>
	<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel">Детали платежа</h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				</div>
				<div class="modal-body">
					<ul class="list-group pl-3">
						<li class="list-group-item"><span class="font-bold">Общая стоимость:</span> <span class="ml-2"><?php echo e(number_format($detail->amount, 0, ',', ' ')); ?> сум</span></li>						
						<li class="list-group-item"><span class="font-bold">ID транзакции:</span> <span class="ml-2"><?php echo e($detail->system_transaction_id ?? ''); ?></span></li>
						<li class="list-group-item"><span class="font-bold">Статус:</span> <span class="ml-2"><?php echo e($detail->status ?? ''); ?></span></li>
						<li class="list-group-item"><span class="font-bold">Время создания в системе Paycom:</span> <span class="ml-2"><?php echo e($detail->paycom_system_time_created); ?></span></li>
						<li class="list-group-item"><span class="font-bold">Время создания в нашей системе:</span> <span class="ml-2"><?php echo e($detail->paycom_time_created); ?></span></li>
						<li class="list-group-item"><span class="font-bold">Время подтверждения:</span> <span class="ml-2"><?php echo e($detail->paycom_time_preform); ?></span></li>
						<?php if(in_array($detail->state, ['canceled_after_commit', 'canceled']) && $detail->paycom_cancel_reason != '-'): ?>
						<li class="list-group-item"><span class="font-bold">Время отмены:</span> <span class="ml-2"><?php echo e($detail->paycom_time_canceled); ?></span></li>
						<li class="list-group-item"><span class="font-bold">Причина отказа:</span> <span class="ml-2"><?php echo e($detail->cancel_reason); ?></span></li>
						<?php endif; ?>
					</ul>						
				</div>            
			</div>
		</div>
	</div>
	<?php endif; ?>

    <div class="card-box">
        <h4 class="header-title m-t-0 m-b-30">Продукты</h4>
        <table class="table">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Изображения</th>
                    <th scope="col">Название</th>
                    <th scope="col">Цена</th>
                    <th scope="col">Скидка %</th>
                    <th scope="col">Цена со скидкой</th>
                    <th scope="col">Количество</th>
                    <th scope="col">Общая стоимость</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th scope="row"><?php echo e($key + 1); ?></th>
                        <td>
                            <?php if(Upload::hasFile('product', $product->product?->id)): ?>
                                <img src="<?php echo e($product->product->image); ?>" alt="" height="70" width="70">
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($product?->product?->name ?? 'Удалено'); ?>

                        </td>
                        <td>
                            <?php echo e($product->original_price_format); ?> сум
                        </td>
                        <td>
                            <?php echo e($product->discount); ?>

                        </td>
                        <td>
                            <?php echo e($product->price_format); ?> сум
                        </td>
                        <td><?php echo e($product->quantity); ?></td>
                        <td><?php echo e($product->total_cost_format); ?> сум</td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="card-box">
        <div class="row">
            <div class="col-md-8">
                <h4 class="header-title m-t-0 m-b-30">История заказа</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Пользователь</th>
                            <th scope="col">Статус</th>
                            <th scope="col">Дата и время изменения</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->histories()->latest()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th scope="row"><?php echo e($key + 1); ?></th>
                                <td><?php echo e($history->user->full_name ?? $history->order->full_name); ?></td>
                                <td><?php echo e($history->status_format); ?></td>
                                <td><?php echo e($history->created_at_format); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="col-md-4">
                <h4 class="header-title m-t-0 m-b-30">Изменить статус</h4>
                <form action="<?php echo e(route('backend.order.change-status')); ?>" method="POST">
                    <input type="hidden" name="order_id" value="<?php echo e($order->id); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label for="manufacturer">Статус</label>
                        <select name="status" class="form-control" <?php echo e(!$can_change_status ? 'disabled' : ''); ?>>
                            <?php $__currentLoopData = __('cabinet.order.statuses'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status_key => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($status_key == 'pending' ? 'disabled' : ''); ?> value="<?php echo e($status_key); ?>"
                                    <?php echo e($order->status == $status_key ? 'selected' : ''); ?>>
                                    <?php echo e($status); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php if(!$can_change_status): ?>
                        <button type="submit" class="btn btn-primary waves-effect waves-light">
                            Сохранить
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .list-group-item {
            border-color: #ccc;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbook/domains/parts/resources/views/backend/order/view.blade.php ENDPATH**/ ?>