<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Coderthemes">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>SIMMA SHOP | ADMIN PANEL</title>
    <!-- App css -->
    <link href="<?php echo e(asset('backend/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('backend/css/icons.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('backend/css/style.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="shortcut icon" href="<?php echo e(URL::asset('assets/images/favicon.ico')); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(URL::asset('assets/images/apple-touch-icon.png')); ?>" />
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-57x57.png')); ?>" />
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-72x72.png')); ?>" />
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-76x76.png')); ?>" />
    <link rel="apple-touch-icon" sizes="114x114"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-114x114.png')); ?>" />
    <link rel="apple-touch-icon" sizes="120x120"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-120x120.png')); ?>" />
    <link rel="apple-touch-icon" sizes="144x144"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-144x144.png')); ?>" />
    <link rel="apple-touch-icon" sizes="152x152"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-152x152.png')); ?>" />
    <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-180x180.png')); ?>" />
    <!-- Select2 css -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/select2.min.css')); ?>">
    <!-- Sweet alert -->
    <link href="<?php echo e(asset('backend/plugins/sweet-alert/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,700" rel="stylesheet">
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="fixed-left">
    <!-- Begin page -->
    <div id="wrapper">
        <!-- Top Bar Start -->
        <div class="topbar">
            <!-- LOGO -->
            <div class="topbar-left">
                <a href="<?php echo e(route('backend.home')); ?>" class="m-t-0">
                    <img src="<?php echo e(asset('assets/images/logo.svg')); ?>" alt="logo" class="logo-brend">
                </a>
            </div>
            <!-- Button mobile view to collapse sidebar menu -->
            <div class="navbar navbar-default" role="navigation">
                <div class="container-flex-justify-end container-fluid p-0">
                    <nav class="navbar-custom">
                        <ul>
                            
                            <li>
                                <a href="<?php echo e(route('frontend.user.logout')); ?>">
                                    <i class="fa fa-sign-out"></i>
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div><!-- end container -->
            </div><!-- end navbar -->
        </div>
        <!-- Top Bar End -->

        <!-- ========== Left Sidebar Start ========== -->
        <div class="left side-menu">
            <div class="sidebar-inner slimscrollleft">
                <div id="sidebar-menu">
                    <ul>
                        <li>
                            <a href="<?php echo e(route('backend.home')); ?>" class="waves-effect">
                                <i class="mdi mdi-view-dashboard"></i>
                                <span>Dashboard</span>
                            </a>
                        </li>
                        
                        <li class="has_sub">
                            <a href="javascript:void(0);" class="waves-effect">
                                <i class="fa fa-image"></i><span>Главная страница</span><span class="menu-arrow"></span>
                            </a>
                            <ul class="list-unstyled">
                                <li><a href="<?php echo e(route('backend.slider.index')); ?>">Слайдер</a></li>
                                <li><a href="<?php echo e(route('backend.banner.index')); ?>">Баннер</a></li>
                                <li><a href="<?php echo e(route('backend.main_page.index')); ?>">Товары</a></li>
                            </ul>
                        </li>
                        <li class="has_sub">
                            <a href="javascript:void(0);" class="waves-effect">
                                <i class="fa fa-users"></i><span>Пользователи</span><span class="menu-arrow"></span>
                            </a>
                            <ul class="list-unstyled">
                                <li><a href="<?php echo e(route('backend.user.index')); ?>">Пользователи</a></li>
                                <li><a href="<?php echo e(route('backend.role.index')); ?>">Роли</a></li>
                            </ul>
                        </li>

                        
                        <li class="has_sub">
                            <a href="javascript:void(0);" class="waves-effect">
                                <i class="fa fa-list"></i><span>Словари</span><span class="menu-arrow"></span>
                            </a>
                            <ul class="list-unstyled">
                                <li><a href="<?php echo e(route('backend.page.index')); ?>">Страницы</a></li>
                                <li><a href="<?php echo e(route('backend.category.index')); ?>">Категории</a></li>
                                <li><a href="<?php echo e(route('backend.manufacturer.index')); ?>">Марки автомобиля</a></li>
                                <li><a href="<?php echo e(route('backend.car.index')); ?>">Автомобилы</a></li>
                                <li><a href="<?php echo e(route('backend.region.index')); ?>">Регионы</a></li>
                                
                                <li><a href="<?php echo e(route('backend.help.index')); ?>">Помощь</a></li>
                                <li><a href="<?php echo e(route('backend.payme-setting.index')); ?>">Настройка Payme</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="<?php echo e(route('backend.product.index')); ?>" class="waves-effect">
                                <i class="fa fa-shopping-bag"></i>
                                <span>Продукты</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('backend.order.index')); ?>" class="waves-effect">
                                <i class="fa fa-cart-plus"></i>
                                <span>Заказы</span>
                            </a>
                        </li>
                        
                        
                        
                        

                        
                        <li>
                            <a href="<?php echo e(route('backend.comment.index')); ?>" class="waves-effect">
                                <i class="fa fa-comments"></i>
                                <span>Отзывы</span>
                            </a>
                        </li>
                        
                        <li>
                            <a href="<?php echo e(route('backend.blog.index')); ?>" class="waves-effect">
                                <i class="fa fa-newspaper-o"></i>
                                <span>Блог (Акция)</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('backend.feedback.index')); ?>" class="waves-effect">
                                <i class="fa fa-phone"></i>
                                <span>Обратная связь</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('backend.page.filemanager')); ?>" class="waves-effect">
                                <i class="fa fa-folder-open"></i>
                                <span>Файл менеджер</span>
                            </a>
                        </li>
                    </ul>
                    <div class="clearfix"></div>
                </div>
                <!-- Sidebar -->
                <div class="clearfix"></div>
            </div>
        </div>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="content-page">
            <!-- Start content -->
            <div class="content">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
            <!-- content -->

            <footer class="footer text-right">
                © ESYS
            </footer>
        </div>
        <!-- ============================================================== -->
        <!-- End Right content here -->
        <!-- ============================================================== -->
    </div>
    <!-- END wrapper -->
    <!-- jQuery  -->
    <script src="<?php echo e(asset('backend/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/detect.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/fastclick.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery.blockUI.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/waves.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery.nicescroll.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery.slimscroll.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery.scrollTo.min.js')); ?>"></script>

    <script type="text/javascript" src="<?php echo e(asset('backend/plugins/jquery-knob/excanvas.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/jquery-knob/jquery.knob.js')); ?>"></script>

    <!-- App js -->
    <script src="<?php echo e(asset('backend/js/jquery.core.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery.app.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/tinymce/tinymce.min.js')); ?>"></script>

    <!-- Select2 js -->
    <script src="<?php echo e(asset('backend/js/select2.full.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/app.js')); ?>"></script>

    <!-- Sweetalert js -->
    <script src="<?php echo e(asset('backend/plugins/sweet-alert/sweetalert2.min.js')); ?>"></script>
    <script>
        <?php if(session()->has('success')): ?>
            swal({
                title: '<i class="fa fa-thumbs-up"></i>',
                text: '<?php echo e(session()->get('success')); ?>',
                type: 'success',
                confirmButtonColor: '#4fa7f3'
            });
        <?php endif; ?>
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /Users/macbook/domains/simma/resources/views/layouts/backend.blade.php ENDPATH**/ ?>