<div class="product-blog">
    <a href="<?php echo e(route('frontend.product.show', $product->alias)); ?>">
        <div class="product-blog__image">
            <img src="<?php echo e($product->image ? $product->image : asset('assets/images/no-image.png?v=1.1')); ?>" alt="<?php echo e($product->name); ?>">
            <button class="product-blog__info-like <?php echo e($product->is_favorite ? 'active' : ''); ?>"
                data-favorite="<?php echo e($product->is_favorite ? 'true' : 'false'); ?>" data-id="<?php echo e($product->id); ?>">
                <?php if($product->is_favorite): ?>
                    <svg data-v-57aaf377="" width="22" height="22" viewBox="0 0 19 16" fill="none"
                        xmlns="http://www.w3.org/2000/svg" class="ui-icon ">
                        <path
                            d="M5.45 0.169434C8.01792 0.169434 9.5 2.32178 9.5 2.32178C9.5 2.32178 10.985 0.169434 13.55 0.169434C16.205 0.169434 18.5 2.23943 18.5 5.11943C18.5 9.34995 12.0604 13.7892 9.86509 15.7297C9.65819 15.9126 9.34179 15.9126 9.13488 15.7297C6.94056 13.7903 0.5 9.34976 0.5 5.11943C0.5 2.23943 2.795 0.169434 5.45 0.169434Z"
                            fill="#193E85"></path>
                    </svg>
                <?php else: ?>
                    <svg data-v-b3e9397c="" width="22" height="22" viewBox="0 0 20 20" fill="none"
                        xmlns="http://www.w3.org/2000/svg" alt="like" class="ui-icon ">
                        <path
                            d="M5.95 2C8.51792 2 10 4.15234 10 4.15234C10 4.15234 11.485 2 14.05 2C16.705 2 19 4.07 19 6.95C19 11.1805 12.5604 15.6197 10.3651 17.5603C10.1582 17.7432 9.84179 17.7432 9.63488 17.5603C7.44056 15.6209 1 11.1803 1 6.95C1 4.07 3.295 2 5.95 2Z"
                            fill="white" fill-opacity="0.8"></path>
                        <path
                            d="M1 6.86486C1 4.20297 3.15017 2 5.86486 2C7.98685 2 9.35921 3.35876 10 4.18673C10.6408 3.35876 12.0132 2 14.1351 2C16.8506 2 19 4.20302 19 6.86486C19 8.02987 18.5328 9.18622 17.8534 10.265C17.1716 11.3476 16.252 12.3903 15.29 13.3377C13.9567 14.6508 12.4757 15.8387 11.4134 16.6907C10.9618 17.0529 10.5859 17.3544 10.3293 17.579C10.1407 17.7439 9.85926 17.7439 9.67075 17.579C9.41405 17.3544 9.03815 17.0529 8.58659 16.6907C7.52431 15.8387 6.04326 14.6508 4.70997 13.3377C3.74802 12.3903 2.82836 11.3476 2.14659 10.265C1.46724 9.18622 1 8.02987 1 6.86486ZM5.86486 3C3.70929 3 2 4.74838 2 6.86486C2 7.76743 2.36553 8.73607 2.99277 9.73208C3.61759 10.7242 4.47833 11.706 5.41165 12.6252C6.71033 13.9042 8.08423 15.005 9.13396 15.8461C9.45728 16.1052 9.74985 16.3396 10 16.547C10.2501 16.3396 10.5427 16.1052 10.866 15.8461C11.9158 15.005 13.2897 13.9042 14.5883 12.6252C15.5217 11.706 16.3824 10.7242 17.0072 9.73208C17.6345 8.73607 18 7.76743 18 6.86486C18 4.74833 16.2914 3 14.1351 3C12.0406 3 10.8181 4.70211 10.5033 5.21028C10.2727 5.5825 9.72727 5.58249 9.4967 5.21027C9.1819 4.7021 7.95944 3 5.86486 3Z"
                            fill="#15151A"></path>
                    </svg>
                <?php endif; ?>
            </button>
            
            <?php if($product && !empty($product->discount)): ?>
                <span class="product-blog__image-discount"><?php echo app('translator')->get('main.discount'); ?> <?php echo e($product->discount); ?>%</span>
            <?php endif; ?>
        </div>
    </a>
    <div class="product-blog__info">
        <a href="<?php echo e(route('frontend.product.show', $product->alias)); ?>"
            class="product-blog__info-link"><?php echo e($product->name); ?></a>
        <div class="product-blog__info-rateyo">
            <div class="rateyo" data-rating="<?php echo e($product->rating); ?>"></div>
            <p class="text-silver text-sm ml-xs"><?php echo e($product->count_comment); ?> <?php echo app('translator')->get('main.reviews'); ?></p>
        </div>
        <div class="product-blog__info-price">
            <?php if($product->quantity > 0): ?>
                <div>
                    <span class=""><?php echo e($product->discount > 0 ? $product->price_format : ''); ?></span>
                    <p class="font-medium text-lg">
                        <?php echo e($product->discount > 0 ? $product->discount_price_format : $product->price_format); ?>

                    </p>
                </div>
                <button type="button" data-id="<?php echo e($product->id); ?>" class="product-blog__info-add js-add-cart">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" class="feather feather-shopping-cart text-silver">
                        <circle cx="9" cy="21" r="1" />
                        <circle cx="20" cy="21" r="1" />
                        <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6" />
                    </svg>
                </button>
            <?php else: ?>
                <div>
                    <span class="text-sm"></span>
                    <p class="font-medium text-lg">
                        <?php echo app('translator')->get('main.not_available'); ?>
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /Users/macbook/domains/parts/resources/views/partials/product.blade.php ENDPATH**/ ?>