<?php $__env->startSection('content'); ?>
    <section class="cart py-layout-xs">
        <div class="container">
            <ul class="breadcrumb">
                <li class="breadcrumb__item">
                    <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('main.home'); ?></a>
                </li>
                <li class="breadcrumb__item">
                    <a href="#"><?php echo app('translator')->get('main.navbar.cart'); ?></a>
                </li>
            </ul>
            <h1 class="title"><?php echo app('translator')->get('main.navbar.cart'); ?></h1>

            <div class="js-cartContent" style="display: <?php echo e(Cart::getContent()->count() > 0 ? 'block' : 'none'); ?>">
                <div class="cart__product box-shadow">
                    <table>
                        <thead>
                            <tr>
                                <td><?php echo app('translator')->get('main.product'); ?></td>
                                <td><?php echo app('translator')->get('main.sum'); ?></td>
                                <td><?php echo app('translator')->get('main.quantity'); ?></td>
                                <td><?php echo app('translator')->get('main.total_sum'); ?></td>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $content; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(asset($product->attributes['link'])); ?>">
                                            <div class="cart__info">
                                                <img src="<?php echo e(asset($product->attributes['image'])); ?>" alt="">
                                                <div>
                                                    <p class="text-silver text-sm"><?php echo e($product->attributes['category']); ?>

                                                    </p>
                                                    <p><?php echo e($product->name); ?></p>
                                                </div>
                                            </div>
                                        </a>
                                    </td>
                                    <td>
                                        <?php echo e(number_format($product->price, 0, ',', ' ')); ?> <?php echo app('translator')->get('main.summ'); ?>
                                    </td>
                                    <td>
                                        <div class="cart__count">
                                            <button class="cart__count-minus js-minus js-qty-btn">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="24"
                                                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="feather feather-minus">
                                                    <line x1="5" y1="12" x2="19" y2="12" />
                                                </svg>
                                            </button>
                                            <input type="number" class="js-qty-value" data-id=<?php echo e($product->id); ?>

                                                value="<?php echo e($product->quantity); ?>" />
                                            <button
                                                <?php echo e($product->quantity >= $product->attributes['quantity'] ? 'disabled' : ''); ?>

                                                class="cart__count-plus js-plus js-qty-btn">
                                                <i class="icon-gm-plus"></i>
                                            </button>
                                        </div>
                                    </td>
                                    <td>
                                        <span
                                            class="js-item-total"><?php echo e(number_format($product->price * $product->quantity, 0, ',', ' ')); ?>

                                        </span> <?php echo app('translator')->get('main.summ'); ?>
                                    </td>
                                    <td>
                                        <button class="js-cart-remove" data-id=<?php echo e($product->id); ?>>
                                            <i class="icon-trash cart__count-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="cart__checkout mt-md">
                    <div class="row">
                        <div class="col-lg-6">
                            
                        </div>
                        <div class="col-lg-6">
                            <div class="text-right">
                                <p class="mb-xs"><?php echo app('translator')->get('main.total_payable'); ?>:</p>
                                <h2 class="mb-sm"><span
                                        class="js-cartTotal"><?php echo e(number_format($cartTotal, 0, ',', ' ')); ?></span> <?php echo app('translator')->get('main.summ'); ?></h2>
                                <a href="<?php echo e(route('cart.checkout')); ?>" class="btn"><?php echo app('translator')->get('main.go_checkout'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="favorite__like js-cartEmpty"
                style="display: <?php echo e(Cart::getContent()->count() > 0 ? 'none' : 'block'); ?>">
                <i class="icon-box-empty d-block"></i>
                <h2 class="my-sm"><?php echo e(trans('cabinet.favorite.empty')); ?></h2>
                <a href="<?php echo e(route('home')); ?>" class="text-blue"><?php echo e(trans('cabinet.favorite.to_buy')); ?></a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        	$('.js-minus').click(function () {
                var $input = $(this).parent().find('input');
                var count = parseInt($input.val()) - 1;
                count = count < 1 ? 1 : count;
                $input.val(count);
                $input.change();
                return false;
            });

            $('.js-plus').click(function () {
                var $input = $(this).parent().find('input');
                $input.val(parseInt($input.val()) + 1);
                $input.change();
                return false;
            });
        $('.js-cart-remove').click(function(e) {
            e.preventDefault();
            var _ = $(this),
                id = _.data('id')
            _.attr('disabled', true);
            $.ajax({
                type: "POST",
                url: '<?php echo e(route('cart.remove')); ?>',
                dataType: 'JSON',
                data: {
                    id: id
                },

                success: function(data) {
                    if (data.status) {
                        _.closest('tr').remove();
                        $('.js-cartTotal').html(data.cartTotal)
                        $('.js-cart-count').html(data.count)

                        let total = isNaN(data.count) ? 0 : data.count;
                        if (total > 0) {
                            $('.js-cartEmpty').hide()
                        } else {
                            $('.js-cartContent').hide()
                            $('.js-cartEmpty').show()
                        }
                    }
                },
                error: function(ajaxContext) {
                    alert(ajaxContext.responseText)
                }
            });
        });

        $('.js-qty-value').change(function() {
            var _ = $(this),
                id = _.data('id'),
                qty = _.val();
            $('.js-qty-btn').attr('disabled', true);

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('cart.change')); ?>',
                dataType: 'JSON',
                data: {
                    id: id,
                    qty: qty
                },
                success: function(data) {
                    $('.js-qty-btn').attr('disabled', false);
                    if (data.status) {
                        $('.js-plus').attr('disabled', data.disabled)
                        _.closest('tr').find('.js-item-total').html(data.itemTotal);
                        $('.js-cartTotal').html(data.cartTotal)
                    }
                },
                error: function(ajaxContext) {
                    alert(ajaxContext.responseText)
                }
            });
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbook/domains/parts/resources/views/frontend/cart/index.blade.php ENDPATH**/ ?>