<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/select2.min.css')); ?>">
    <style>
        .box {
            padding: 18px;
            border: 1px solid rgba(0, 0, 0, .125);
            background-color: #fff;
            position: relative;
            overflow: hidden;
            margin-bottom: 30px;
        }

        .product-img {
            position: relative;
            display: inline-block;
        }

        .product-img:hover {
            border: 1px solid #0000cc;
        }

        .product-remove {
            right: 0;
            padding: 3px 9px;
            font-size: 12px;

        }

        .product-remove,
        .product-label {
            position: absolute;
            top: 0;
        }

        .product-label {
            left: 0;
        }

        .product-remove {
            right: 0;
        }

        body.dragging,
        body.dragging * {
            cursor: move !important;
        }

        .dragged {
            position: absolute;
            opacity: 0.5;
            z-index: 2000;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


    <form action="<?php echo e(route('backend.product.postform', ['id' => $id])); ?>" method="POST" enctype="multipart/form-data">

        <?php echo csrf_field(); ?>
        <div class="card">
            <div class="card-body">
                <!-- Title and language start  -->
                <div class="row">
                    <div class="col-sm-10 big-input">
                        <div class="tab-content">
                            <?php $__currentLoopData = config()->get('app.supported_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div role="tabpanel" class="tab-pane js-lang js-lang-<?php echo e($v); ?>">
                                    <div class="form-group mb-0 <?php echo e($errors->has('name_' . $v) ? 'has-error' : ''); ?>">
                                        <input type="text" name="name_<?php echo e($v); ?>"
                                            value="<?php echo e(empty($product) ? null : $product->{'name_' . $v}); ?>"
                                            class="form-control" placeholder="Введите название продукта">
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <select class="form-control js-lang-selector">
                                <?php $__currentLoopData = config()->get('app.supported_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($lang); ?>"><?php echo e(strtoupper($lang)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <!-- Title and language end  -->
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a href="#basic" aria-controls="basic" role="tab" data-toggle="tab"
                            class="nav-link active show">Основной</a>
                    </li>
                    <li class="nav-item">
                        <a href="#seo" aria-controls="seo" role="tab" data-toggle="tab" class="nav-link">SEO</a>
                    </li>
                </ul>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="tab-content">
                            <!-- Basic start -->
                            <div role="tabpanel" class="tab-pane fade show active" id="basic">
                                <div class="row">
                                    <div class="col-sm-8">
                                        <div class="form-group">
                                            <label for="image">Изображения (600x600)px</label>
                                            <input type="file" name="images[]" class="form-control" multiple>
                                        </div>
                                        
                                        <div class="tab-content">
                                            <?php if(!empty($product) && Upload::hasFiles('product', $product->id)): ?>
                                                <div class="box">
                                                    <?php $__currentLoopData = Upload::getFiles('product', $product->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a href="#" class="img-thumbnail product-img"
                                                            data-key="<?php echo e($key); ?>">
                                                            <img src="<?php echo asset($file); ?>?cacheimg=<?php echo e(rand(11111, 99999)); ?>"
                                                                class="js-product-img" height="100">
                                                            <button type="button"
                                                                class="btn btn-xs btn-danger product-remove js-product-remove"><i
                                                                    class="fa fa-trash" tabindex="-1"></i></button>
                                                        </a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endif; ?>
                                            <div class="form-group">
                                                <label for="image">Видео (600x600)px</label>
                                                <input type="file" name="video" class="form-control">
                                                <?php $__errorArgs = ['video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="error"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <?php if(!empty($product) && Upload::hasFiles('product_video', $product->id)): ?>
                                            <video controls="" muted height="150">
                                                <source src="<?php echo e(Upload::getFile('product_video', $product->id)); ?>">
                                            </video>
                                            <?php endif; ?>
                                            <input type="hidden" name="main_image" class="js-main-image">
                                            <input type="hidden" name="removed_images" class="js-removed-images">
                                            <?php $__currentLoopData = config()->get('app.supported_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div role="tabpanel" class="tab-pane js-lang js-lang-<?php echo e($v); ?>">

                                                    <div
                                                        class="form-group <?php echo e($errors->has('short_description_' . $v) ? 'has-error' : ''); ?>">
                                                        <label for="short_description">Краткий текст</label>
                                                        <textarea name="short_description_<?php echo e($v); ?>" cols="4" rows="3" class="form-control"><?php echo e(empty($product) ? null : $product->{'short_description_' . $v}); ?></textarea>
                                                    </div>

                                                    <div
                                                        class="form-group <?php echo e($errors->has('description_' . $v) ? 'has-error' : ''); ?>">
                                                        <label for="description">Описание</label>
                                                        <input type="text" name="description_<?php echo e($v); ?>"
                                                            value="<?php echo e(empty($product) ? null : $product->{'description_' . $v}); ?>"
                                                            class="js-selector">
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="category">Категории</label><br />
                                            <div class="box mb-0"
                                                style="border-color: <?php echo e($errors->has('category') ? '#ff5b5b' : ''); ?>">
                                                <small class="pull-right">Основной</small>
                                                <hr>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo App\Library\Helper::renderNode(
                                                        $category,
                                                        'category',
                                                        empty($product)
                                                            ? []
                                                            : $product->categories()->pluck('id')->toArray(),
                                                        empty($product) ? 0 : $product->category_id,
                                                    ); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <?php if($errors->has('category')): ?>
                                                <span class="help-block" style="color: #ff5b5b; margin-top: 5px">
                                                    Выберите категорию
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="form-group">
                                            <label for="manufacturer">Производитель</label>
                                            <select name="manufacturer_id" class="form-control js-brand">
                                                <option selected disabled>Выберите производитель</option>
                                                <?php $__empty_1 = true; $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <option value="<?php echo e($manufacturer->id); ?>"
                                                        <?php echo e(!empty($product) && $product->manufacturer_id == $manufacturer->id ? 'selected' : ''); ?>>
                                                        <?php echo e($manufacturer->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <option value="null" disabled>Пожалуйста добавьте производитель в
                                                        пункте "Производители"</option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="car">Автомобили</label>
                                            <select name="cars[]" class="form-control js-cars" multiple>
                                                <?php if(!empty($product)): ?>
                                                    <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($car->id); ?>"
                                                            <?php echo e($product->cars->contains($car->id) ? 'selected' : ''); ?>>
                                                            <?php echo e($car->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($car->id); ?>"><?php echo e($car->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="checkbox-second checkbox-second--textless">
                                                        <input type="checkbox" name="to_1" value="1"
                                                            <?php echo e(!empty($product->to_1) ? 'checked' : ''); ?>>
                                                        <span></span>
                                                    </label>
                                                    ТО 1
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="checkbox-second checkbox-second--textless">
                                                        <input type="checkbox" name="to_2" value="1"
                                                            <?php echo e(!empty($product->to_2) ? 'checked' : ''); ?>>
                                                        <span></span>
                                                    </label>
                                                    ТО 2
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-9">
                                                <div class="form-group <?php echo e($errors->has('price') ? 'has-error' : ''); ?>">
                                                    <label for="price">Цена</label>
                                                    <input type="text" name="price"
                                                        value="<?php echo e(empty($product) ? null : $product->price); ?>"
                                                        class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group <?php echo e($errors->has('discount') ? 'has-error' : ''); ?>">
                                                    <label for="discount">Скидка %</label>
                                                    <input type="text" name="discount"
                                                        value="<?php echo e(empty($product) ? null : $product->discount); ?>"
                                                        class="form-control">
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!-- Basic end -->

                            <!-- SEO fields start -->
                            <div role="tabpanel" class="tab-pane fade" id="seo">
                                <div class="tab-content">
                                    <?php $__currentLoopData = config()->get('app.supported_locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div role="tabpanel" class="tab-pane js-lang js-lang-<?php echo e($v); ?>">

                                            <div class="form-group">
                                                <label for="meta_description">Meta - Описание</label>
                                                <textarea name="meta_description_<?php echo e($v); ?>" rows="2" class="form-control">
                                            <?php echo e(empty($product) ? null : $product->{'meta_description_' . $v}); ?>

                                        </textarea>
                                            </div>

                                            <div class="form-group">
                                                <label for="meta_title">Meta - Заголовок</label>
                                                <input type="text" name="meta_title_<?php echo e($v); ?>"
                                                    value="<?php echo e(empty($product) ? null : $product->{'meta_title_' . $v}); ?>"
                                                    class="form-control">
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <!-- SEO fields end -->
                        </div>
                        <div class="form-group m-b-0">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Сохранить
                            </button>
                            <a href="<?php echo e(route('backend.product.index')); ?>"
                                class="btn btn-secondary waves-effect waves-light m-l-5">
                                Отменить
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('backend/js/product.form.js')); ?>"></script>
    <script>
        $('.js-cars').select2();
        ProductForm.init();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbook/domains/parts/resources/views/backend/product/form.blade.php ENDPATH**/ ?>