<?php
    $categories = App\Models\Category::whereNull('parent_id')->get();
    $manufacturers = App\Models\Manufacturer::get();
    $categories = Cache::remember('categories', 10, function () {
        return \App\Models\Category::whereNull('parent_id')->get();
    });
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(URL::asset('assets/images/favicon.ico')); ?>">
    <link rel="apple-touch-icon" href="<?php echo e(URL::asset('assets/images/apple-touch-icon.png')); ?>" />
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-57x57.png')); ?>" />
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-72x72.png')); ?>" />
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(URL::asset('assets/images/apple-touch-icon-76x76.png')); ?>" />
    <link rel="apple-touch-icon" sizes="114x114"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-114x114.png')); ?>" />
    <link rel="apple-touch-icon" sizes="120x120"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-120x120.png')); ?>" />
    <link rel="apple-touch-icon" sizes="144x144"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-144x144.png')); ?>" />
    <link rel="apple-touch-icon" sizes="152x152"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-152x152.png')); ?>" />
    <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo e(URL::asset('assets/images/apple-touch-icon-180x180.png')); ?>" />
    <link href="https://fonts.googleapis.com/css?family=Lato:400,700|Roboto:400,500,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/toastify.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/styles.min.css?v=1.5')); ?>">
    <?php echo $__env->yieldContent('styles'); ?>
    <title>DRIVERS SHOP - ВСЕ ДЛЯ АВТОМОБИЛЯ</title>
</head>

<body>
    
    <header class="header">
        <div class="header__top">
            <div class="container">
                <div class="header__top-content">
                    <ul class="header__top-nav">
                        <li class="js-menu">
                            <div class="hamburger">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                            <button><?php echo app('translator')->get('main.top.catalog'); ?></button>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.show', 'kak-rabotaet')); ?>"><?php echo app('translator')->get('main.about'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.show', 'oplata-i-dostavka')); ?>"><?php echo app('translator')->get('main.top.delivery_and_payment'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('help')); ?>"><?php echo app('translator')->get('main.top.help'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.blog.index')); ?>"><?php echo app('translator')->get('main.our_blog'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.contact.index')); ?>"><?php echo app('translator')->get('main.top.contact'); ?></a>
                        </li>
                    </ul>
                    <div class="header__top-right">
                        <div class="header__top-checked">
                            
                            <svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="1.3" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-phone-call" style="margin-right: 9px">
                                <path
                                    d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z" />
                            </svg>
                            <span><a href="tel:+998712007070">+998 71 200 70 70</a></span>
                        </div>
                        <div class="dropdown">
                            <a href="#">
                                <p class="d-inline-block">
                                    <?php echo e(LaravelLocalization::getSupportedLocales()[app()->getLocale()]['native']); ?></p>
                                <i class="icon-dropdown"></i>
                            </a>
                            <div class="dropdown-nav">
                                <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($code != LaravelLocalization::getCurrentLocale()): ?>
                                        <a href="<?php echo e($lang == config()->get('app.locale') ? LaravelLocalization::getNonLocalizedURL() : LaravelLocalization::getLocalizedURL($code)); ?>"
                                            class="dropdown-links"><?php echo e($lang['native']); ?></a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header__bottom">
            <div class="container">
                <div class="header__bottom-content">
                    <div class="header__bottom-left">
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset('assets/images/logo.svg')); ?>" alt=""
                                class="header__bottom-logo">
                        </a>
                        <div class="header__bottom-input">
                            <i class="icon-search"></i>
                            <input type="text" class="js-search-input" placeholder="<?php echo app('translator')->get('main.navbar.search'); ?>">
                            <ul class="header__bottom-search">

                            </ul>
                        </div>
                    </div>
                    <div class="header__bottom-right">
                        <div class="header__bottom-blog">
                            <a href="<?php echo e(route('product.favorite')); ?>" class="header__bottom-link">
                                <img src="<?php echo e(asset('assets/images/heart.png')); ?>" alt="" height="35">
                                
                                <div>
                                    <p><?php echo app('translator')->get('main.favorite'); ?></p>
                                    <?php
                                        $favorite_count = collect(json_decode(request()->cookie('user_favorite_list', '[]')))->count();
                                    ?>
                                    <span
                                        class="js-total-favorite"><?php echo e($favorite_count ? $favorite_count . __('main.products') : __('main.navbar.empty_cart')); ?>

                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="header__bottom-blog">
                            <a href="<?php echo e(route('frontend.cart.list')); ?>" class="header__bottom-link">
                                <img src="<?php echo e(asset('assets/images/cart.svg')); ?>" alt="">
                                <span
                                    class="header__bottom-count js-cart-count"><?php echo e(Cart::getContent()->count()); ?></span>
                                <div>
                                    <p><?php echo app('translator')->get('main.navbar.cart'); ?></p>
                                    <span><?php echo app('translator')->get('main.navbar.empty_cart'); ?></span>
                                </div>
                            </a>
                        </div>
                        <div class="header__bottom-blog">
                            <button class="js-login header__bottom-link">
                                <img src="<?php echo e(asset('assets/images/user.svg')); ?>" alt="">
                                <div>
                                    <p><?php echo app('translator')->get('main.navbar.cabinet'); ?></p>
                                    <span><?php echo e(auth()->check() ? auth()->user()->first_name : trans('main.navbar.login')); ?></span>
                                </div>
                            </button>
                            <div class="header__bottom-modal js-login-modal hide">
                                <?php if(auth()->check()): ?>
                                    <div class="text-black text-upper mb-sm"><?php echo app('translator')->get('main.hello'); ?>,
                                        <?php echo e(auth()->user()->first_name); ?></div>
                                    <a href="<?php echo e(route('frontend.cabinet.index')); ?>/#/orders"
                                        class="text-blue mb-sm d-block"><?php echo app('translator')->get('main.my_order'); ?></a>
                                    <a href="<?php echo e(route('frontend.cabinet.index')); ?>/#/profile"
                                        class="text-blue mb-sm d-block"><?php echo app('translator')->get('main.settings'); ?></a>
                                    <a href="<?php echo e(route('frontend.user.logout')); ?>"
                                        class="header__bottom-btn text-white bg-blue"><?php echo app('translator')->get('main.navbar.logout'); ?></a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('frontend.user.getLogin')); ?>"
                                        class="header__bottom-btn text-white bg-blue"><?php echo app('translator')->get('main.navbar.login'); ?></a>
                                    <a href="<?php echo e(route('frontend.user.getRegister')); ?>"
                                        class="header__bottom-btn"><?php echo app('translator')->get('main.navbar.register'); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="header__bottom-input header__bottom-input--sm">
                    <i class="icon-search"></i>
                    <input type="text" class="js-search-input" placeholder="<?php echo app('translator')->get('main.navbar.search'); ?>">
                    <ul class="header__bottom-search">

                    </ul>
                </div>
            </div>
        </div>
        <div class="menu dropdown-menu" role="menu">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <ul class="menu__nav">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu__nav-item" data-menu="link-<?php echo e($key); ?>">
                                    <div class="d-flex align-content-center justify-content-between full-width">
                                        <div class="menu__nav-text">
                                            <a href="<?php echo e(route('frontend.product.index', [$category->alias])); ?>">
                                                <img src="<?php echo e(Upload::hasFile('category', $category->id) ? Upload::getFile('category', $category->id) : ''); ?>"
                                                    alt="" class="menu__nav-img">
                                                <?php echo e($category->name); ?>

                                            </a>
                                        </div>
                                        <i class="icon-arrow-right"></i>
                                    </div>
                                    <?php if(!$category->isLeaf()): ?>
                                        <ul class="menu__nav-sub">
                                            <?php $__currentLoopData = $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <a
                                                        href="<?php echo e(route('frontend.product.index', [$category->alias, $subcat->alias])); ?>"><?php echo e($subcat->name); ?></a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="col-md-9 menu-sm-hide">
                        <div class="menu__content">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="menu__content-item" id="link-<?php echo e($key); ?>">
                                    <?php if(!$category->isLeaf()): ?>
                                        <div class="menu__content-blog">
                                            <?php $__currentLoopData = $category->children->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="menu__content-links">
                                                    <ul>
                                                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li>
                                                                <a
                                                                    href="<?php echo e(route('frontend.product.index', [$category->alias, $subcat->alias])); ?>"><?php echo e($subcat->name); ?></a>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    

    <?php echo $__env->yieldContent('content'); ?>

    

    <footer class="footer">
        <div class="container">
            <div class="footer__content py-layout-xs">
                <div class="footer__blog">
                    <img src="<?php echo e(asset('assets/images/logo.svg')); ?>" alt="" class="footer__blog-logo">
                    <p class="text-silver text-sm mb-sm font-medium"><?php echo app('translator')->get('main.if_has_question'); ?></p>
                    <p class="footer__blog-number"><a href="tel:+998712007070">+998 (71) 200 70 70</a></p>
                    <p class="text-silver text-sm"><?php echo app('translator')->get('main.footer_desc'); ?></p>
                </div>
                <div class="footer__blog">
                    <p class="footer__blog-title"><?php echo app('translator')->get('main.car_brands'); ?></p>
                    <ul>
                        <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a
                                    href="<?php echo e(route('frontend.product.manufacturer', $manufacturer->alias)); ?>"><?php echo e($manufacturer->name); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="footer__blog">
                    <p class="footer__blog-title">Driver's SHOP</p>
                    <ul>
                        
                        <li>
                            <a href="<?php echo e(route('page.show', 'kak-rabotaet')); ?>"><?php echo app('translator')->get('main.about'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.blog.index')); ?>"><?php echo app('translator')->get('main.our_blog'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('page.show', 'oplata-i-dostavka')); ?>"><?php echo app('translator')->get('main.top.delivery_and_payment'); ?></a>
                        </li>

                        <li>
                            <a href="<?php echo e(route('help')); ?>"><?php echo app('translator')->get('main.top.help'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.contact.index')); ?>"><?php echo app('translator')->get('main.top.contact'); ?></a>
                        </li>
                        
                    </ul>
                </div>
                <div class="footer__blog">
                    <p class="footer__blog-title"><?php echo app('translator')->get('main.we_accept'); ?></p>
                    <div class="footer__blog-pay">
                        
                        
                            <img src="<?php echo e(asset('assets/images/payme.svg')); ?>" alt="" class="">
                        
                        
                    </div>
                    <p class="text-black font-bold mb-xs"><?php echo app('translator')->get('main.address'); ?></p>
                    <p class="text-silver text-sm"><?php echo app('translator')->get('main.address_info'); ?></p>
                    <div class="footer__blog-social">
                        <a href="https://www.instagram.com/driversvillageuz/">
                            <img src="<?php echo e(asset('assets/images/instagram.svg')); ?>" alt="">
                        </a>
                        <a href="https://www.facebook.com/driversvillageuz/">
                            <img src="<?php echo e(asset('assets/images/facebook.svg')); ?>" alt="">
                        </a>
                        <a href="https://t.me/driversvillage_uzb">
                            <img src="<?php echo e(asset('assets/images/telegram.svg')); ?>" alt="">
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer__bottom">
            <?php echo app('translator')->get('main.capyright'); ?>
        </div>
    </footer>
    <div class="overlay"></div>
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.mask.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('assets/js/jquery.rateyo.min.js')); ?>"></script>
    <script src="<?php echo e(mix('frontend/main.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/toastify.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/shop.js?v=1.7')); ?>"></script>
    <script src="<?php echo e(mix('frontend/search.min.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <script type="text/javascript">
        new Shop({
            favoriteUrl: "<?php echo e(route('product.sync-favorite')); ?>",
            addCartUrl: "<?php echo e(route('cart.add')); ?>",
            cartListUrl: "<?php echo e(route('frontend.cart.list')); ?>",
            toCart: "<?php echo app('translator')->get('main.to_cart'); ?>"
        }).init()

        new Search({
            container: '.header__bottom-search',
            input: '.js-search-input',
            url: "<?php echo e(route('frontend.product.search')); ?>"
        })
        new Main()
        Toastify({
            text: 'Сайт находится в тестовом режиме',
            className: "toastify",
            duration: 20000,
            gravity: "bottom",
            position: "right",
            close: false,
            newWindow: true,
            style: {
                background: '#0643DA',
            }
        }).showToast()
    </script>
</body>

</html>
<?php /**PATH /Users/macbook/domains/parts/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>