<?php $__env->startSection('content'); ?>
    <div class="preloader js-filter-preloader">
        <div class="preloader-content">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <section class="products py-layout-xs">
        <div class="container">
            <?php echo $breadcrumbs; ?>

        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-3 products__sidebar">
                    <div class="products__filter box-shadow">
                        <div class="products__filter-item">
                            <?php if($category == 'all'): ?>
                                <p class="products__filter-title"><?php echo app('translator')->get('main.categories'); ?></p>
                                <ul class="products__filter-category">
                                    <?php $__currentLoopData = $parent_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a
                                                href="<?php echo e(route('frontend.product.index', $parent_category->alias)); ?>"><?php echo e($parent_category->name); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <ul class="products__filter-category mt-sm">
                                    <li>
                                        <a href="<?php echo e(route('frontend.product.index', 'all')); ?>"
                                            class="d-flex align-items-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-chevron-left mr-xxs">
                                                <polyline points="15 18 9 12 15 6" />
                                            </svg>
                                            <?php echo app('translator')->get('main.all_category'); ?>
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="<?php echo e(route('frontend.product.index', $category->parent ? $category?->parent?->alias : $category->alias)); ?>"><b>
                                                <?php echo e($category->parent ? $category?->parent?->name : $category->name); ?>

                                            </b></a>
                                    </li>
                                    <?php $__currentLoopData = $category->parent ? $category?->parent?->children : $category->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="pl-sm">
                                            <a href="<?php echo e(route('frontend.product.index', [$category->parent ? $category->parent->alias : $category->alias, $child->alias])); ?>"
                                                class="<?php echo e($category->id == $child->id ? 'active' : ''); ?>"><?php echo e($child->name); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="products__filter-item">
                            <p class="products__filter-title"><?php echo app('translator')->get('main.price'); ?></p>
                            <div class="products__filter-summ">
                                <div class="relative">
                                    <input type="text" name="price_min" class="input bg-gray js-filter js-filter-price"
                                        placeholder="<?php echo app('translator')->get('main.from'); ?>" value="<?php echo e($inputs['price_min'] ?? ''); ?>">
                                </div>
                                <div class="relative">
                                    <input type="text" value="<?php echo e($inputs['price_max'] ?? ''); ?>" name="price_max"
                                        class="input bg-gray js-filter js-filter-price" placeholder="<?php echo app('translator')->get('main.to'); ?>">
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="categories[]"
                            value="<?php echo e($category != 'all' ? $category->id : $category); ?>" class="js-filter">
                        <?php if(count($manufacturers) > 0): ?>
                            <div class="products__filter-item">
                                <p class="products__filter-title"><?php echo app('translator')->get('main.car_brands'); ?></p>
                                <?php $__currentLoopData = $manufacturers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m_key => $manufacturer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="mb-sm">
                                        <label class="checkbox" for="mnf_<?php echo e($m_key); ?>"><?php echo e($manufacturer->name); ?>

                                            <input type="checkbox" name="manufacturers[]" id="mnf_<?php echo e($m_key); ?>"
                                                value="<?php echo e($manufacturer->id); ?>"
                                                class="js-filter"<?php echo e(isset($inputs['manufacturers']) && in_array($manufacturer->id, $inputs['manufacturers']) ? ' checked="checked"' : ''); ?>>
                                            <span class="checkmark"></span>
                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                        <?php if(count($cars) > 0): ?>
                            <div class="products__filter-item">
                                <p class="products__filter-title"><?php echo app('translator')->get('main.cars'); ?></p>
                                <div class="js-list-filter">
                                    <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c_key => $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-sm">
                                            <label class="checkbox" for="car_<?php echo e($c_key); ?>"><?php echo e($car->name); ?>

                                                <input type="checkbox" name="cars[]" id="car_<?php echo e($c_key); ?>"
                                                    value="<?php echo e($car->id); ?>"
                                                    class="js-filter"<?php echo e(isset($inputs['cars']) && in_array($car->id, $inputs['cars']) ? ' checked="checked"' : ''); ?>>
                                                <span class="checkmark"></span>
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="mb-sm">
                            <label class="checkbox" for="spare_part_1"><?php echo app('translator')->get('main.to_1'); ?>
                                <input type="checkbox" name="spare_part[]" id="spare_part_1" value="1"
                                    class="js-filter"<?php echo e(isset($inputs['spare_part']) && in_array(1, $inputs['spare_part']) ? ' checked="checked"' : ''); ?>>
                                <span class="checkmark"></span>
                            </label>
                        </div>
                        <div class="mb-sm">
                            <label class="checkbox" for="spare_part_2"><?php echo app('translator')->get('main.to_2'); ?>
                                <input type="checkbox" name="spare_part[]" id="spare_part_2" value="2"
                                    class="js-filter"<?php echo e(isset($inputs['spare_part']) && in_array(2, $inputs['spare_part']) ? ' checked="checked"' : ''); ?>>
                                <span class="checkmark"></span>
                            </label>
                        </div>
                        <button class="full-width products__sidebar-btn">Показать<br>(300)</button>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="products__sort">
                        <div class="d-flex align-items-center">
                            <p class="products__sort-title"><?php echo app('translator')->get('main.sort'); ?>:</p>
                            <select name="sort_by" class="js-select js-filter">
                                <option value="popular"
                                    <?php echo e(isset($inputs['sort_by']) && $inputs['sort_by'] == 'popular' ? 'selected' : ''); ?>>
                                    <?php echo app('translator')->get('main.popularity'); ?></option>
                                <option value="price_asc"
                                    <?php echo e(isset($inputs['sort_by']) && $inputs['sort_by'] == 'price_asc' ? 'selected' : ''); ?>>
                                    <?php echo app('translator')->get('main.cheaper'); ?></option>
                                <option value="price_desc"
                                    <?php echo e(isset($inputs['sort_by']) && $inputs['sort_by'] == 'price_desc' ? 'selected' : ''); ?>>
                                    <?php echo app('translator')->get('main.expensive'); ?></option>
                                <option value="rating"
                                    <?php echo e(isset($inputs['sort_by']) && $inputs['sort_by'] == 'rating' ? 'selected' : ''); ?>>
                                    <?php echo app('translator')->get('main.high_rating'); ?></option>
                            </select>
                        </div>
                        <div class="products__sort-toggle">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-filter js-filter-btn">
                                <polygon points="22 3 2 3 10 12.46 10 19 14 21 14 12.46 22 3" />
                            </svg>
                            <i class="icon-bullet-list products__sort-icons js-list"></i>
                            <i
                                class="icon-four-grid-layout-design-interface-symbol products__sort-icons js-grid active"></i>
                        </div>
                    </div>
                    <div class="products__content">
                        <div class="row js-products-container">
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 col-xs-6 js-blog">
                                    <div class="mb-md">
                                        <?php echo $__env->make('partials.product', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="text-right mt-md js-pagination">
                        <?php echo $products->appends(array_filter(Request::except('categories')))->links('partials.paginate'); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(mix('frontend/filter.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/select.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            new Filter({
                container: '.js-products-container',
                current_url: '<?php echo URL::current(); ?>',
                url: '<?php echo e(route('frontend.product.filter')); ?>',
                trans: {
                    btn_reset: '<?php echo app('translator')->get('filter.btn.reset'); ?>'
                }
            })
        });
        $(document).ready(function() {
            $('.js-list-filter').each(function() {
                var LiN = $(this).find('div').length;
                if (LiN > 4) {
                    $('div', this).eq(4).nextAll().hide().addClass('toggleable');
                    $(this).append(
                        '<div class="more"><?php echo app('translator')->get("main.show_all"); ?> <i class="icon-dropdown ml-2"></i></div>');
                }
            });
            $('.js-list-filter').on('click', '.more', function() {
                if ($(this).hasClass('less')) {
                    $(this).html('<?php echo app('translator')->get("main.show_all"); ?> <i class="icon-dropdown ml-2"></i>').removeClass('less');
                } else {
                    $(this).html('<?php echo app('translator')->get("main.hide"); ?> <i class="icon-dropdown up ml-2"></i>').addClass('less');
                }
                $(this).siblings('div.toggleable').slideToggle(80);
            });
        });

        $('.js-select').niceSelect();
        $('.js-filter-btn').click(function() {
            $('.products__sidebar').slideDown(200)
        })
        $('.products__sidebar-btn').click(function() {
            $('.products__sidebar').slideUp(200)
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/macbook/domains/parts/resources/views/frontend/product/index.blade.php ENDPATH**/ ?>