<?php $__env->startSection('content'); ?>
    <div class="preloader js-checkout-preloader">
        <div class="preloader-content">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <section class="checkout py-layout-xs">
        <div class="container">
            <ul class="breadcrumb">
                <li class="breadcrumb__item">
                    <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('main.home'); ?></a>
                </li>
                <li class="breadcrumb__item">
                    <a href="<?php echo e(route('frontend.cart.list')); ?>"><?php echo app('translator')->get('main.navbar.cart'); ?></a>
                </li>
                <li class="breadcrumb__item">
                    <a href="#"><?php echo app('translator')->get('main.checkout'); ?></a>
                </li>
            </ul>
        </div>
        <form action="<?php echo e(route('cart.checkout-form')); ?>" method="POST" class="js-checkout-form">
            <?php echo csrf_field(); ?>
            <div class="container">
                <h1 class="title text-black mb-lg"><?php echo app('translator')->get('main.checkout'); ?></h1>
                <div class="row">
                    <div class="col-md-8">
                        <div class="checkout__content box-shadow--silver rounded">
                            <h2 class="title-lg"><?php echo app('translator')->get('main.contact_info'); ?></h2>
                            <div class="row mb-sm">
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" value="<?php echo e(auth()->user()->last_name ?? ''); ?>" class="input"
                                            placeholder="<?php echo app('translator')->get('cabinet.profile.last_name'); ?>" name="last_name">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" value="<?php echo e(auth()->user()->first_name ?? ''); ?>" class="input"
                                            placeholder="<?php echo app('translator')->get('cabinet.profile.name'); ?>" name="first_name">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="relative">
                                            <input <?php echo e(auth()->check() ? 'disabled' : ''); ?> type="text"
                                                value="<?php echo e(auth()->user()->phone ?? old('phone', 998)); ?>"
                                                class="input js-phone-mask" placeholder="<?php echo app('translator')->get('main.phone_number'); ?>"
                                                name="phone_number">
                                            
                                        </div>
                                        
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" class="input js-phone-mask"
                                            value="<?php echo e(old('additional_number')); ?>"
                                            placeholder="<?php echo app('translator')->get('main.phone_number_dop'); ?>" name="additional_number">
                                    </div>
                                </div>
                            </div>

                            <div class="checkout__access access-hide">
                                <h2 class="title-lg"><?php echo app('translator')->get('main.choose_type_delivery'); ?></h2>
                                <div class="checkout__pay">
                                    <div class="row mb-md">
                                        <div class="col-lg-6">
                                            <label class="js-check">
                                                <input type="radio" name="delivery_type"
                                                    class="checkout__pay-radio js-delivery-type" data-text="Самовывоз"
                                                    checked value="pickup" />
                                                <div class="checkout__pay-item">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="37"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="feather feather-user-check checkout__pay-icon">
                                                        <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2" />
                                                        <circle cx="8.5" cy="7" r="4" />
                                                        <polyline points="17 11 19 13 23 9" />
                                                    </svg>
                                                    <p class="checkout__pay-title">
                                                        <?php echo app('translator')->get('main.pick_up'); ?><br>
                                                        <span><?php echo app('translator')->get('main.pick_up_desc'); ?></span>
                                                    </p>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-lg-6">
                                            <label class="js-check">
                                                <input type="radio" name="delivery_type" data-text="Доставка"
                                                    class="checkout__pay-radio js-delivery-type" value="express" />
                                                <div class="checkout__pay-item">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="37"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="1" stroke-linecap="round" stroke-linejoin="round"
                                                        class="feather feather-truck">
                                                        <rect x="1" y="3" width="15" height="13" />
                                                        <polygon points="16 8 20 8 23 11 23 16 16 16 16 8" />
                                                        <circle cx="5.5" cy="18.5" r="2.5" />
                                                        <circle cx="18.5" cy="18.5" r="2.5" />
                                                    </svg>
                                                    <p class="checkout__pay-title">
                                                        <?php echo app('translator')->get('main.express'); ?><br>
                                                        <span><?php echo app('translator')->get('main.express_desc'); ?></span>
                                                    </p>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="js-delivery-address hide">
                                    <h2 class="title-lg"><?php echo app('translator')->get('cabinet.address.add'); ?></h2>
                                    <div class="row mb-sm">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <select name="region_id" class="input" disabled>
                                                    
                                                    
                                                    <option value="<?php echo e($region->id); ?>" selected><?php echo e($region->name); ?>

                                                    </option>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <input type="hidden" name="region_id" value="<?php echo e($region->id); ?>">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <select name="district_id" class="input">
                                                    <option value="0" selected disabled><?php echo app('translator')->get('main.choose_region'); ?></option>
                                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="text" class="input" placeholder="Узбекистан, 100088, Ташкент, Янгихаётский район, ул. Навруз, 22"
                                                    name="address">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="js-payment-types hide">
                                    <div class="checkout__systems">
                                        
                                        <label class="radio d-flex align-items-center mr-md"><img
                                                src="<?php echo e(asset('assets/images/payme.svg')); ?>"
                                                class="checkout__systems-image" alt="">
                                            <input type="radio" name="payment_type" value="payme">
                                            <span class="radio__checkmark"></span>
                                        </label>
                                        
                                    </div>
                                </div>
                                <h2 class="title-lg"><?php echo app('translator')->get('main.order_feedback'); ?></h2>
                                <textarea name="comment" cols="30" rows="5" class="input"
                                    placeholder="<?php echo app('translator')->get('main.order_feedback_desc'); ?>"><?php echo e(old('comment')); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="checkout__info box-shadow--silver rounded" id="sticker">
                            <h2 class="title-lg font-roboto"><?php echo app('translator')->get('main.acc_summ'); ?></h2>
                            
                            <div class="d-flex align-items-center justify-content-between mb-sm b-b pb-sm">
                                <p class="text-silver text"><?php echo app('translator')->get('main.type_delivery'); ?>:</p>
                                <p class="js-delivery-type-text"></p>
                            </div>
                            
                            <div class="d-flex align-items-center justify-content-between">
                                <p class="title-lg font-medium"><?php echo app('translator')->get('main.total_pay'); ?>:</p>
                                <p class="title-lg font-medium js-total-text">
                                    <?php echo e(number_format($cartTotal, 0, ',', ' ')); ?> <?php echo app('translator')->get('main.summ'); ?></p>
                            </div>
                            <label class="checkbox text-sm mb-sm"><?php echo app('translator')->get('main.offer_info'); ?> <a
                                    href="<?php echo e(route('page.show', 'publicnaia-oferat')); ?>" class="text-blue text-xs checkout__info-link"><?php echo app('translator')->get('main.offer_btn'); ?></a>
                                <input type="checkbox" name="check" class="js-check-oferta">
                                <span class="checkmark"></span>
                            </label>
                            <button class="btn text-upper js-send-btn full-width" disabled><?php echo app('translator')->get('main.go_checkout'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/jquery.mask.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.sticky.js')); ?>"></script>
    <script src="<?php echo e(mix('frontend/checkout.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            new Checkout({
                checkoutForm: '.js-checkout-form',
                deliveryType: '.js-delivery-type',
                deliveryTypeText: '.js-delivery-type-text',
                deliveryAddress: '.js-delivery-address',
                paymentType: '.js-payment-type',
                paymentTypeText: '.js-payment-type-text',
                paymentTypes: '.js-payment-types',
                checkOferta: '.js-check-oferta',
                sendBtn: '.js-send-btn',
                preloader: '.js-checkout-preloader'
            })
        })
        if ($(window).width() > 992) {
            $("#sticker").sticky({
                topSpacing: 20,
                bottomSpacing: 400
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/simmaautostar/public_html/resources/views/frontend/cart/checkout.blade.php ENDPATH**/ ?>