<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <div class="row m-0">
                <div class="col-sm-6">
                    <h4 class="m-t-0 m-b-30 header-title">Пользователи</h4>            
                </div>
                <div class="col-sm-6">
                    <button type="button" class="btn btn-success m-b-sm btn-add pull-right" data-toggle="modal" data-target="#formModal">
                        <i class="fa fa-plus"></i> Добавить
                    </button>
                </div>
            </div>
            <table id="datatable" class="table table-bordered table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th><input type="text" class="form-control input-sm"></th>
                        <th><input type="text" class="form-control input-sm"></th>
                        <th><input type="text" class="form-control input-sm"></th>
                        <th>
                            <select name="gender" class="form-control">
                                <option value="" selected>Все</option>
                                <option value="1">Мужской</option>
                                <option value="0">Женский</option>
                            </select>
                        </th>
                        <th></th>
                        <th></th>
                    </tr>
                    <tr>
                        <th>ID</th> 
                        <th>ФИО</th>
                        <th>Телефон</th>
                        <th>Пол</th>
                        <th>Роли</th>                      
                        <th style="width:40px;"></th>                   
                    </tr>
                </thead>
                <tbody>                   
                </tbody>
            </table>
        </div>
    </div>
</div> <!-- end row -->
<!-- Form Modal -->
<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel">Добавить</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body">                             
                <form action="" id="form" enctype="multipart/form-data">
                    <input type="hidden" name="id" value="null">                    
                    <div class="form-group">
                        <label for="name">ФИО</label>
                        <input type="text" name="name" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="email">Телефон</label>
                        <input type="text" name="phone" readonly class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="password">Пароль</label>
                        <input type="password" name="password" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="password">Подтверждение пароля</label>
                        <input type="password" name="password_confirmation" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="roles">Роль</label>
                        <select name="roles[]" class="form-control select2 role" multiple>
                            <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->name_ru); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <option value="null" disabled>Пожалуйста добавьте роль в разделе "Роли"</option>
                            <?php endif; ?>
                        </select>
                    </div>                
                    <div class="js-progress-bar d-none text-left">
                        <div class="progress progress-lg">
                            <div class="progress-bar progress-bar-info"></div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Отменить</button>
                <button type="submit" class="btn btn-success ajax-form">Сохранить</button>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('partials.ajax-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<link href="<?php echo e(asset('backend/plugins/datatables/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css"/>
<link href="<?php echo e(asset('backend/plugins/datatables/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/plugins/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/crud.js')); ?>"></script>
<script>         
    var crud = new Crud({
        filter: true,
        form: {
            url: "<?php echo e(route('backend.user.form')); ?>",
        },
        list: {
            url: "<?php echo e(route('backend.user.data')); ?>",
            datatable: {            
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'name', name: 'name'},
                    {data: 'phone', name: 'phone'},
                    {data: 'gender', name: 'gender'},
                    {data: 'role_name', name: 'role_id'}
                ],
                columnDefs: [                   
                    {
                        targets: 5,
                        data: null,
                        searchable:false, 
                        render: function (row, type, val, meta) {                                                        
                            return crud.makeButton(val, 'btn-primary btn-edit', '<i class="fa fa-pencil"></i>', [
                                    ['toggle', 'modal'],
                                    ['target', '#formModal']
                                ]);
                        }                        
                    }
                ]
            }
        },

        remove: {
            url: "<?php echo e(route('backend.user.delete')); ?>",
        }
    });
    $(document).on('click', '.btn-edit', function() {
        var data = crud.datatable.row($(this).closest('tr')).data();
        var ids = data.roles.split(',');
        $('.role').val(ids).select2();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/simmaautostar/public_html/resources/views/backend/user/index.blade.php ENDPATH**/ ?>