<div class="product-blog">
    <a href="<?php echo e(route('frontend.product.show', $product->alias)); ?>">
        <div class="product-blog__image">
            
            <?php if($product && !empty($product->discount)): ?>
                <span class="product-blog__image-discount">-<?php echo e($product->discount); ?>%</span>
            <?php endif; ?>
            
            <img src="<?php echo e($product->image ? $product->image : asset('assets/images/no-image.png?v=1.1')); ?>" alt="<?php echo e($product->name); ?>">
            
            
            
            <button class="product-blog__info-like <?php echo e($product->is_favorite ? 'active' : ''); ?>"
                data-favorite="<?php echo e($product->is_favorite ? 'true' : 'false'); ?>" data-id="<?php echo e($product->id); ?>">
            
                <?php if($product->is_favorite): ?>
                    <svg data-v-57aaf377=""  viewBox="0 0 19 16" fill="none"
                        xmlns="http://www.w3.org/2000/svg" class="ui-icon ">
                        <path
                            d="M5.45 0.169434C8.01792 0.169434 9.5 2.32178 9.5 2.32178C9.5 2.32178 10.985 0.169434 13.55 0.169434C16.205 0.169434 18.5 2.23943 18.5 5.11943C18.5 9.34995 12.0604 13.7892 9.86509 15.7297C9.65819 15.9126 9.34179 15.9126 9.13488 15.7297C6.94056 13.7903 0.5 9.34976 0.5 5.11943C0.5 2.23943 2.795 0.169434 5.45 0.169434Z"
                            fill="#e47600"></path>
                    </svg>
                <?php else: ?>
                    <svg data-v-b3e9397c=""  viewBox="0 0 20 20" fill="none"
                        xmlns="http://www.w3.org/2000/svg" alt="like" class="ui-icon ">
                        <path 
                            d="M5.95 2C8.51792 2 10 4.15234 10 4.15234C10 4.15234 11.485 2 14.05 2C16.705 2 19 4.07 19 6.95C19 11.1805 12.5604 15.6197 10.3651 17.5603C10.1582 17.7432 9.84179 17.7432 9.63488 17.5603C7.44056 15.6209 1 11.1803 1 6.95C1 4.07 3.295 2 5.95 2Z"
                            fill="" fill-opacity="0.8"></path>
                        <path
                            d="M1 6.86486C1 4.20297 3.15017 2 5.86486 2C7.98685 2 9.35921 3.35876 10 4.18673C10.6408 3.35876 12.0132 2 14.1351 2C16.8506 2 19 4.20302 19 6.86486C19 8.02987 18.5328 9.18622 17.8534 10.265C17.1716 11.3476 16.252 12.3903 15.29 13.3377C13.9567 14.6508 12.4757 15.8387 11.4134 16.6907C10.9618 17.0529 10.5859 17.3544 10.3293 17.579C10.1407 17.7439 9.85926 17.7439 9.67075 17.579C9.41405 17.3544 9.03815 17.0529 8.58659 16.6907C7.52431 15.8387 6.04326 14.6508 4.70997 13.3377C3.74802 12.3903 2.82836 11.3476 2.14659 10.265C1.46724 9.18622 1 8.02987 1 6.86486ZM5.86486 3C3.70929 3 2 4.74838 2 6.86486C2 7.76743 2.36553 8.73607 2.99277 9.73208C3.61759 10.7242 4.47833 11.706 5.41165 12.6252C6.71033 13.9042 8.08423 15.005 9.13396 15.8461C9.45728 16.1052 9.74985 16.3396 10 16.547C10.2501 16.3396 10.5427 16.1052 10.866 15.8461C11.9158 15.005 13.2897 13.9042 14.5883 12.6252C15.5217 11.706 16.3824 10.7242 17.0072 9.73208C17.6345 8.73607 18 7.76743 18 6.86486C18 4.74833 16.2914 3 14.1351 3C12.0406 3 10.8181 4.70211 10.5033 5.21028C10.2727 5.5825 9.72727 5.58249 9.4967 5.21027C9.1819 4.7021 7.95944 3 5.86486 3Z"
                            fill="#e47600"></path>
                    </svg>
                <?php endif; ?>
            </button>
        </div>
    </a>
    
    <div class="product-blog__info">
        <div class="product-blog__info-price">
            <?php if($product->quantity > 0): ?>
            <div>
                <span class=""><?php echo e($product->discount > 0 ? $product->price_format .' ' .__('main.summ') : ''); ?></span>
                <div class="font-medium text-lg d-flex align-items-end">
                    <?php echo e($product->discount > 0 ? $product->discount_price_format : $product->price_format); ?> <p><?php echo app('translator')->get('main.summ'); ?></p>
                </div>
            </div>
            <?php else: ?>
            <div>
                <span class="text-sm"></span>
                <p class="font-medium text-lg">
                    <?php echo app('translator')->get('main.not_available'); ?>
                </p>
            </div>
            <?php endif; ?>
        </div>
        <a href="<?php echo e(route('frontend.product.show', $product->alias)); ?>"
            class="product-blog__info-link"><?php echo e($product->name); ?></a>
        <div class="product-blog__info-rateyo">
            <div class="rateyo" data-rating="<?php echo e($product->rating); ?>"></div>
            
        </div>
        <div class="d-flex justify-content-center">
            
            
            <button class="product-blog__info-add js-add-cart" data-id="<?php echo e($product->id); ?>">
                
                <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 24 24" fill="none">
                    <path d="M7.5 18C8.32843 18 9 18.6716 9 19.5C9 20.3284 8.32843 21 7.5 21C6.67157 21 6 20.3284 6 19.5C6 18.6716 6.67157 18 7.5 18Z" stroke="currentColor" stroke-width="1.5"/>
                    <path d="M16.5 18.0001C17.3284 18.0001 18 18.6716 18 19.5001C18 20.3285 17.3284 21.0001 16.5 21.0001C15.6716 21.0001 15 20.3285 15 19.5001C15 18.6716 15.6716 18.0001 16.5 18.0001Z" stroke="currentColor" stroke-width="1.5"/>
                    <path d="M11 9H8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                    <path d="M2 3L2.26491 3.0883C3.58495 3.52832 4.24497 3.74832 4.62248 4.2721C5 4.79587 5 5.49159 5 6.88304V9.5C5 12.3284 5 13.7426 5.87868 14.6213C6.75736 15.5 8.17157 15.5 11 15.5H13M19 15.5H17" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                    <path d="M5 6H8M5.5 13H16.0218C16.9812 13 17.4609 13 17.8366 12.7523C18.2123 12.5045 18.4013 12.0636 18.7792 11.1818L19.2078 10.1818C20.0173 8.29294 20.4221 7.34853 19.9775 6.67426C19.5328 6 18.5054 6 16.4504 6H12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                </svg>
                
                В корзину
            
            </button>
        </div>
    </div>
</div>
<?php /**PATH /home/simmaautostar/public_html/resources/views/partials/product.blade.php ENDPATH**/ ?>