<?php

use App\Http\Controllers\CartController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProductController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(
    [
        'prefix' => LaravelLocalization::setLocale(),
        'middleware' => [ 'localizationRedirect', 'localeViewPath' ]
    ],
    function()
    {
        // Page
        Route::get('/', 'PageController@index')->name('home');
        Route::get('/help', 'PageController@help')->name('help');
        // Contact
        Route::get('/contact', 'PageController@contact')->name('frontend.contact.index');
        Route::post('/contact', 'PageController@postContact')->name('frontend.contact.form');
        Route::get('/page/view/{alias}', 'PageController@show')->name('page.show');

        Route::group(['middleware' => 'guest'], function() {
			Route::get('user/login', [UserController::class, 'getLogin'])->name('frontend.user.getLogin');
			Route::post('user/login', [UserController::class, 'postLogin'])->name('frontend.user.postLogin');
			Route::get('user/register', [UserController::class, 'getRegister'])->name('frontend.user.getRegister');
			Route::post('user/register', [UserController::class, 'postRegister'])->name('frontend.user.postRegister');
            Route::get('user/reset-password', [UserController::class, 'resetPassword'])->name('frontend.user.reset');
			Route::post('user/reset-password', [UserController::class, 'resetPasswordForm'])->name('frontend.user.reset.form');
			Route::post('user/reset-password/send-code', [UserController::class, 'resetPasswordSendCode'])->name('frontend.user.reset.send-code');
		});

		Route::get('user/logout', [UserController::class, 'logout'])->name('frontend.user.logout')->middleware('auth');
        // Cart
        Route::post('cart/add-product', [CartController::class, 'add'])->name('cart.add');
        Route::get('cart', [CartController::class, 'cartList'])->name('frontend.cart.list');
        Route::post('cart/remove', [CartController::class, 'cartRemove'])->name('cart.remove');
        Route::post('cart/change', [CartController::class, 'cartChange'])->name('cart.change');
        Route::get('checkout', [CartController::class, 'checkout'])->name('cart.checkout');
		Route::post('checkout', [CartController::class, 'postCheckout'])->name('cart.checkout-form');
        Route::get('complete/{order}', [CartController::class, 'complete'])->name('cart.complete');

        // Product
		Route::get('category/{alias1?}/{alias2?}', [ProductController::class, 'index'])->name('frontend.product.index');
		Route::post('products/filter', [ProductController::class, 'postFilter'])->name('frontend.product.filter');

        Route::get('product/show/{alias}', [ProductController::class, 'show'])->name('frontend.product.show');
        Route::get('product/manufacturer/{alias}', [ProductController::class, 'manufacturer'])->name('frontend.product.manufacturer');
        Route::get('product/manufacturer/categories/{alias}', [ProductController::class, 'category'])->name('frontend.product.category');
		Route::post('products/search', [ProductController::class, 'search'])->name('frontend.product.search');
        //Favorite
        Route::get('product/favorite', 'ProductController@favorite')->name('product.favorite');
        Route::post('product/sync-favorite', 'ProductController@syncFavorite')->name('product.sync-favorite');

        Route::post('product/comment/{product_id}', 'ProductController@comment')->name('product.comment');

        Route::get('/blogs', 'BlogController@index')->name('frontend.blog.index');
        Route::get('/blog/show/{alias}', 'BlogController@show')->name('frontend.blog.show');
        
        /*
        |--------------------------------------------------------------------------
        | User verify routes
        |--------------------------------------------------------------------------
        |
        | All routes checking with auth middleware
        |
        */
        Route::group(['middleware' => 'auth'], function() {			
            Route::get('user/verify', 'VerificationController@index')->name('frontend.verify.index');
            Route::post('user/verify', 'VerificationController@verify')->name('frontend.verify');
            Route::post('user/verify/send-code', 'VerificationController@sendCode')->name('frontend.verify.send-code');
        });
    });

