<?php

use App\Http\Controllers\CabinetController;

Route::group(
    [
        'prefix' => LaravelLocalization::setLocale(),
        'middleware' => [ 'localizationRedirect', 'localeViewPath' ]
    ],
    function()
    {		
		Route::get('/cabinet', [CabinetController::class, 'index'])->name('frontend.cabinet.index');		

		// get user addresses
		Route::post('/cabinet/address', 'CabinetController@address')->name('frontend.cabinet.address');
		Route::post('/cabinet/address/region', 'CabinetController@region')->name('frontend.cabinet.address.region');
		Route::post('/cabinet/address/district', 'CabinetController@district')->name('frontend.cabinet.address.district');
		Route::post('/cabinet/address/create', 'CabinetController@createAddress')->name('frontend.cabinet.address.create');

		// edit address
		Route::post('/cabinet/address/edit/{id?}', 'CabinetController@editAddress')->name('frontend.cabinet.address.edit');
		Route::post('/cabinet/address/edit/form/{id?}', 'CabinetController@updateAddress')->name('frontend.cabinet.address.edit.form');
		// delete address
		Route::post('/cabinet/address/delete/{id?}', 'CabinetController@deleteAddress')->name('frontend.cabinet.address.delete');
		// change main address
		Route::post('/cabinet/address/change/{id?}', 'CabinetController@changeMainAddress');
		// Route::post('/cabinet/mycar', 'CabinetController@myCar')->name('frontend.cabinet.my-car');

		Route::get('cabinet/orders/{type}', [CabinetController::class, 'getOrders']);
		Route::get('cabinet/active/orders', [CabinetController::class, 'getActiveOrders']);
		Route::get('cabinet/completion/orders', [CabinetController::class, 'getCompletionOrders']);

		// profile update
		Route::post('/cabinet/profile', [CabinetController::class, 'profile'])->name('frontend.cabinet.profile');
		Route::post('/cabinet/profile/update', [CabinetController::class, 'updateProfile'])->name('frontend.cabinet.profile.update');
		Route::post('cabinet/profile/get/districts', [CabinetController::class, 'getDistricts']);

		Route::get('cabinet/notifications', [CabinetController::class, 'notifications']);

		// cars
		Route::get('cabinet/cars', [CabinetController::class, 'cars']);
		Route::get('cabinet/cars/form/{id?}', [CabinetController::class, 'carForm']);
		Route::post('cabinet/cars/form/{id?}',[CabinetController::class, 'postCarForm']);
	});