<?php

use App\Http\Controllers\Backend\CarController;
use App\Http\Controllers\Backend\SettingController;
use App\Http\Controllers\Backend\BlogController;
use App\Http\Controllers\Backend\HelpController;
use App\Http\Controllers\Backend\PageController;
use App\Http\Controllers\Backend\RoleController;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\YearController;
use App\Http\Controllers\Backend\OrderController;
use App\Http\Controllers\Backend\BannerController;
use App\Http\Controllers\Backend\RegionController;
use App\Http\Controllers\Backend\SliderController;
use App\Http\Controllers\Backend\CommentController;
use App\Http\Controllers\Backend\ProductController;
use App\Http\Controllers\Backend\CategoryController;
use App\Http\Controllers\Backend\FeedbackController;
use App\Http\Controllers\Backend\MainPageController;
use App\Http\Controllers\Backend\ManufacturerController;
use App\Http\Controllers\Backend\PaymeSettingController;

    /*
	|--------------------------------------------------------------------------
	| Backend Routes
	|--------------------------------------------------------------------------
	|
	| Here is where you can register backend routes for your application. These
	| routes are loaded by the RouteServiceProvider within a group which
	| contains the "web" and "auth" middleware group. Now create something great!
	|
    */
    // Dashboard
    Route::get('/',  [PageController::class, 'dashboard'])->name('backend.home');
    // Page
    Route::get('page', [PageController::class, 'index'])->name('backend.page.index');
    Route::get('page/data', [PageController::class, 'data'])->name('backend.page.data');
    Route::get('page/form/{id?}', [PageController::class, 'getForm'])->name('backend.page.getform');
    Route::post('page/form/{id?}', [PageController::class, 'postForm'])->name('backend.page.postform');
    Route::post('page/delete', [PageController::class, 'delete'])->name('backend.page.delete');

    // Users
    Route::get('user', [UserController::class, 'index'])->name('backend.user.index');
    Route::get('user/data', [UserController::class, 'data'])->name('backend.user.data');
    Route::post('user/form', [UserController::class, 'form'])->name('backend.user.form');
    Route::post('user/delete', [UserController::class, 'delete'])->name('backend.user.delete');

    // Products
    Route::get('product', [ProductController::class, 'index'])->name('backend.product.index');
    Route::get('product/data', [ProductController::class, 'data'])->name('backend.product.data');
    Route::get('product/form/{id?}', [ProductController::class, 'getForm'])->name('backend.product.getform');
    Route::post('product/form/{id?}', [ProductController::class, 'postForm'])->name('backend.product.postform');
    Route::post('product/delete', [ProductController::class, 'delete'])->name('backend.product.delete');
	Route::post('product/change-quantity', [ProductController::class, 'changeQuantity'])->name('backend.product.change-quantity');
    Route::post('/import','ProductController@import')->name('import.product');
    Route::get('/product_excel_export', [ProductController::class, 'product_excel_export'])->name('product_excel_export');
    
    //Route::get('product_excel', [PageController::class, 'newproduct'])->name('backend.newproduct.index');

    // Categories
    Route::get('category',  [CategoryController::class, 'index'])->name('backend.category.index');
    Route::get('category/data',  [CategoryController::class, 'data'])->name('backend.category.data');
    Route::post('category/form',  [CategoryController::class, 'form'])->name('backend.category.form');
    Route::post('category/delete',  [CategoryController::class, 'delete'])->name('backend.category.delete');

    // Regions
    Route::get('region', [RegionController::class, 'index'])->name('backend.region.index');
    Route::get('region/data', [RegionController::class, 'data'])->name('backend.region.data');
    Route::post('region/form', [RegionController::class, 'form'])->name('backend.region.form');
    Route::post('region/delete', [RegionController::class, 'delete'])->name('backend.region.delete');
    
    // Setting
    
    Route::get('setting',  [SettingController::class, 'index'])->name('backend.setting.index');
    Route::get('setting/data',  [SettingController::class, 'data'])->name('backend.setting.data');
    Route::get('setting/form/{id?}',  [SettingController::class, 'getForm'])->name('backend.setting.getform');
    Route::post('setting/form/{id?}',  [SettingController::class, 'postForm'])->name('backend.setting.postform');
    Route::post('setting/delete',  [SettingController::class, 'delete'])->name('backend.setting.delete');
    Route::post('setting/status',  [SettingController::class, 'status'])->name('backend.setting.status');

    // Cars
    Route::get('car', [CarController::class, 'index'])->name('backend.car.index');
    Route::get('car/data', [CarController::class, 'data'])->name('backend.car.data');
    Route::post('car/form', [CarController::class, 'form'])->name('backend.car.form');
    Route::post('car/delete', [CarController::class, 'delete'])->name('backend.car.delete');

    // Manufacturers
    Route::get('manufacturer', [ManufacturerController::class, 'index'])->name('backend.manufacturer.index');
    Route::get('manufacturer/data', [ManufacturerController::class, 'data'])->name('backend.manufacturer.data');
    Route::post('manufacturer/form', [ManufacturerController::class, 'form'])->name('backend.manufacturer.form');
    Route::post('manufacturer/delete', [ManufacturerController::class, 'delete'])->name('backend.manufacturer.delete');

    // MainPage
    Route::get('main-page', [MainPageController::class, 'index'])->name('backend.main_page.index');
    Route::get('main-page/data', [MainPageController::class, 'data'])->name('backend.main_page.data');
    Route::post('main-page/form', [MainPageController::class, 'form'])->name('backend.main_page.form');
    Route::post('main-page/delete', [MainPageController::class, 'delete'])->name('backend.main_page.delete');
    Route::post('main-page/status',  [MainPageController::class, 'status'])->name('backend.main_page.status');
    Route::post('main-page/remove-img',  [MainPageController::class, 'removeImg'])->name('backend.main_page.remove-image');


    // Years
    Route::get('year', [YearController::class, 'index'])->name('backend.year.index');
    Route::get('year/data', [YearController::class, 'data'])->name('backend.year.data');
    Route::post('year/form', [YearController::class, 'form'])->name('backend.year.form');
    Route::post('year/delete', [YearController::class, 'delete'])->name('backend.year.delete');

    // Help
    Route::get('help',  [HelpController::class, 'index'])->name('backend.help.index');
    Route::get('help/data',  [HelpController::class, 'data'])->name('backend.help.data');
    Route::post('help/form',  [HelpController::class, 'form'])->name('backend.help.form');
    Route::post('help/delete',  [HelpController::class, 'delete'])->name('backend.help.delete');

	// Payme setting
	Route::get('payme/settings', [PaymeSettingController::class, 'index'])->name('backend.payme-setting.index');
	Route::get('payme/settings/data', [PaymeSettingController::class, 'data'])->name('backend.payme-setting.data');
	Route::post('payme/settings/form', [PaymeSettingController::class, 'form'])->name('backend.payme-setting.form');
	Route::post('payme/settings/delete', [PaymeSettingController::class, 'delete'])->name('backend.payme-setting.delete');

    // Sliders
    Route::get('slider', [SliderController::class, 'index'])->name('backend.slider.index');
    Route::get('slider/data', [SliderController::class, 'data'])->name('backend.slider.data');
    Route::post('slider/form', [SliderController::class, 'form'])->name('backend.slider.form');
    Route::post('slider/delete', [SliderController::class, 'delete'])->name('backend.slider.delete');

    // Banners
    Route::get('banner',  [BannerController::class, 'index'])->name('backend.banner.index');
    Route::get('banner/data',  [BannerController::class, 'data'])->name('backend.banner.data');
    Route::post('banner/form',  [BannerController::class, 'form'])->name('backend.banner.form');
    Route::post('banner/delete',  [BannerController::class, 'delete'])->name('backend.banner.delete');
    Route::post('banner/status',  [BannerController::class, 'status'])->name('backend.banner.status');

    // Comments
    Route::get('comment',  [CommentController::class, 'index'])->name('backend.comment.index');
    Route::get('comment/data',  [CommentController::class, 'data'])->name('backend.comment.data');    
    Route::post('comment/delete',  [CommentController::class, 'delete'])->name('backend.comment.delete');
    Route::post('comment/status',  [CommentController::class, 'status'])->name('backend.comment.status');

    // Blogs
    Route::get('blog',  [BlogController::class, 'index'])->name('backend.blog.index');
    Route::get('blog/data',  [BlogController::class, 'data'])->name('backend.blog.data');
    Route::get('blog/form/{id?}',  [BlogController::class, 'getForm'])->name('backend.blog.getform');
    Route::post('blog/form/{id?}',  [BlogController::class, 'postForm'])->name('backend.blog.postform');
    Route::post('blog/delete',  [BlogController::class, 'delete'])->name('backend.blog.delete');
    Route::post('blog/status',  [BlogController::class, 'status'])->name('backend.blog.status');

    // Feedback
    Route::get('feedback',  [FeedbackController::class, 'index'])->name('backend.feedback.index');
    Route::get('feedback/data',  [FeedbackController::class, 'data'])->name('backend.feedback.data');
    Route::post('feedback/delete',  [FeedbackController::class, 'delete'])->name('backend.feedback.delete');
    Route::post('feedback/change',  [FeedbackController::class, 'change'])->name('backend.feedback.change');

    // Filemanager
    Route::get('fm', [PageController::class, 'filemanager'])->name('backend.page.filemanager');

    // Roles
    Route::get('role',  [RoleController::class, 'index'])->name('backend.role.index');
    Route::get('role/data',  [RoleController::class, 'data'])->name('backend.role.data');
    Route::post('role/form',  [RoleController::class, 'form'])->name('backend.role.form');
    Route::post('role/delete',  [RoleController::class, 'delete'])->name('backend.role.delete');

    // Order
    Route::get('order', [OrderController::class, 'index'])->name('backend.order.index');
    Route::get('order/data', [OrderController::class, 'data'])->name('backend.order.data');
    Route::get('order/view/{id}', [OrderController::class, 'view'])->name('backend.order.view');
    Route::post('order/delete', [OrderController::class, 'delete'])->name('backend.order.delete');
	Route::post('order/change/status', [OrderController::class, 'changeStatus'])->name('backend.order.change-status');