@extends('layouts.frontend')

@section('content')
    <section class="login pb-layout pt-layout-xs">
        <div class="container">
            <h1 class="title text-center">@lang('main.ver_text_1')</h1>
            <p class="text-center mb-md">
                @lang('main.ver_text_2')
            </p>
            <div class="row">
                <form action="{{ route('frontend.verify') }}" method="POST">
                    @csrf
                    <div class="col-lg-4 col-lg-push-4">
                        <div class="login__blog bg-white">
                            <input id="code" type="code" class="input @error('code') is-invalid @enderror"
                                name="code" value="{{ old('code') }}" required autocomplete="code" autofocus>
                            <div class="text-center mt-sm">
                                <div class="text-center text-secondary js-timer-area">
                                    @lang('main.reset.repeat_code_time') <span class="js-timer">-:-</span>
                                </div>
                                <button type="submit" class="btn mt-sm">@lang('main.reset.repeat_code')</button>
                            </div>
                        </div>
                        <div class="text-center mt-sm">
                            <a href="#" class="js-send-again text-blue" style="display:none">@lang('main.reset.repeat_send')</a>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="{{ asset('assets/js/verify.js') }}"></script>
    <script>
        new phoneVerify({
            sendCodeUrl: "{{ route('frontend.verify.send-code') }}",
            sendAgainBtn: $('.js-send-again'),
            timerArea: $('.js-timer-area'),
            timerSelect: $('.js-timer'),
            timeLeft: {{ $time_left }}
        });
    </script>
@endsection
