@extends('layouts.frontend')

@section('content')
    <section class="login pb-layout pt-layout-xs">
        <div class="container">
            <h1 class="title text-center">@lang('main.reset.text_1')</h1>
            <p class="text-center mb-md">
                @lang('main.reset.text_2')
            </p>
            <div class="row">
                <form action="#" method="POST" class="js-reset-password-form">
                    @csrf
                    <div class="col-lg-4 col-lg-push-4">
                        <div class="login__blog bg-white">
                            <div class="form-group">
                                <input type="text" name="phone" class="input js-phone-mask"
                                    value="{{ request()->old('phone', '998') }}" placeholder="@lang('main.phone_number')">
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn mt-sm js-send-phone">@lang('main.reset.get_code')</button>
                            </div>
                            <div class="js-send-code-container" style="display: none">
                                <input id="code" type="code" class="input @error('code') is-invalid @enderror"
                                    name="code" value="{{ old('code') }}" required autocomplete="code" autofocus>
                                <div class="text-center mt-sm">
                                    <div class="text-center text-secondary js-timer-area">
                                        @lang('main.reset.repeat_code_time') <span class="js-timer">-:-</span>
                                    </div>
                                    <button type="submit" class="btn mt-sm js-send-code-btn">@lang('main.reset.repeat_code')</button>
                                </div>
                            </div>
                        </div>
                        <div class="text-center mt-sm">
                            <a href="#" class="js-send-again text-blue" style="display:none">@lang('main.reset.repeat_send')</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="{{ asset('assets/js/reset.password.js?v=1.2') }}"></script>
    <script>
        new resetPassword({
            sendFormUrl: "{{ route('frontend.user.reset.form') }}",
            sendAgainUrl: "{{ route('frontend.user.reset.send-code') }}",
            sendCodeContainer: $('.js-send-code-container'),
            sendPhoneBtn: $('.js-send-phone'),
            sendCodeBtn: $('.js-send-code-btn'),
            sendAgainBtn: $('.js-send-again'),
            timerArea: $('.js-timer-area'),
            timerSelect: $('.js-timer')
        });
    </script>
@endsection
