@extends('layouts.frontend')

@section('content')
    <section class="login pb-layout pt-layout-xs">
        <div class="container">
            <h1 class="title text-center">@lang('auth.register.title')</h1>
            <div class="row">
                <form action="{{ route('frontend.user.postRegister') }}" method="POST">
                    @csrf
                    <div class="col-lg-6 col-lg-push-3">
                        <div class="login__blog bg-white">
                            <div class="form-group {{ $errors->has('first_name') ? 'form-group--error' : '' }}">
                                <input type="text" name="first_name" class="input" placeholder="@lang('auth.register.first_name')">
                                @error('first_name')
                                <label class="form-group__error">{{ $message }}</label>
                                @enderror
                            </div>
                            <div class="form-group {{ $errors->has('last_name') ? 'form-group--error' : '' }}">
                                <input type="text" name="last_name" class="input" placeholder="@lang('auth.register.last_name')">
                                @error('last_name')
                                <label class="form-group__error">{{ $message }}</label>
                                @enderror
                            </div>
                            <div class="form-group {{ $errors->has('phone') ? 'form-group--error' : '' }}">
                                <input type="text" name="phone" class="input js-phone-mask" value="{{ request()->old('phone', '998') }}" placeholder="Номер телефона">
                                @error('phone')
                                <label class="form-group__error">{{ $message }}</label>
                                @enderror
                            </div>
                            <div class="form-group pswd {{ $errors->has('password') ? 'form-group--error' : '' }}">
                                <input type="password" name="password" class="input" autocomplete="off" placeholder="@lang('auth.login.password')">
                                @error('password')
                                <label class="form-group__error">{{ $message }}</label>
                                @enderror
                                <div class="pswd__info">
                                    <ul>
                                        <li id="letter" class="invalid"><i class="fa icon-close"></i> @lang('main.pswd.letter')</li>
                                        <li id="capital" class="invalid"><i class="fa icon-close"></i> @lang('main.pswd.capital')</li>
                                        <li id="number" class="invalid"><i class="fa icon-close"></i> @lang('main.pswd.number')</li>
                                        <li id="length" class="invalid"><i class="fa icon-close"></i> @lang('main.pswd.length')</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="form-group {{ $errors->has('password_confirmation') ? 'form-group--error' : '' }}">
                                <input type="password" name="password_confirmation" class="input" placeholder="@lang('auth.register.password_confirm')">
                                @error('password_confirmation')
                                <label class="form-group__error">{{ $message }}</label>
                                @enderror
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn">@lang('auth.register.submit')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
<script src="{{ asset('assets/js/jquery.mask.min.js') }}"></script>
<script>
    $(".js-phone-mask").mask("+999(99)999-99-99", { autoclear: false });
    $('.pswd > input[type=password]').keyup(function() {
		var pswd = $(this).val();

		if ( pswd.length < 8 ) {
			$('#length').removeClass('valid').addClass('invalid');
			$('#length > i').removeClass('icon-gm-plus').addClass('icon-close')
		} else {
			$('#length').removeClass('invalid').addClass('valid');
			$('#length > i').removeClass('icon-close').addClass('icon-gm-plus')
		}

		if ( pswd.match(/[a-z]/) ) {
			$('#letter').removeClass('invalid').addClass('valid');
			$('#letter > i').removeClass('icon-close').addClass('icon-gm-plus')
		} else {
			$('#letter').removeClass('valid').addClass('invalid');
			$('#letter > i').removeClass('icon-gm-plus').addClass('icon-close')
		}

		if ( pswd.match(/[A-Z]/) ) {
			$('#capital').removeClass('invalid').addClass('valid');
			$('#capital > i').removeClass('icon-close').addClass('icon-gm-plus')
		} else {
			$('#capital').removeClass('valid').addClass('invalid');
			$('#capital > i').removeClass('icon-gm-plus').addClass('icon-close')
		}

		if ( pswd.match(/\d/) ) {
			$('#number').removeClass('invalid').addClass('valid');
			$('#number > i').removeClass('icon-close').addClass('icon-gm-plus')
		} else {
			$('#number').removeClass('valid').addClass('invalid');
			$('#number > i').removeClass('icon-gm-plus').addClass('icon-close')
		}

	}).focus(function() {
		$('.pswd > .pswd__info').fadeIn();
	}).blur(function() {
		$('.pswd > .pswd__info').fadeOut();
	});
</script>
@endsection