@extends('layouts.frontend')

@section('content')
    <section class="login pb-layout pt-layout-xs">
        <div class="container">
            <h1 class="title text-center">@lang('auth.login.title')</h1>
            <div class="row">
                <form action="{{ route('frontend.user.postLogin') }}" method="POST">
                    @csrf
                    <div class="col-lg-6 col-lg-push-3">
                        <div class="login__blog bg-white">
                            <div class="form-group">
                                <input type="text" name="phone" value="{{ request()->old('phone', '998') }}" class="input js-phone-mask" placeholder="@lang('auth.login.phone')">
                            </div>
                            <div class="form-group">
                                <input type="password" name="password" class="input" placeholder="@lang('auth.login.password')">                                
                            </div>
                            @if(session()->has('error'))
                                <div class="form-group--error">
                                    <label class="form-group__error">{{ session()->get('error') }}</label>
                                </div>
                            @endif
                            <div class="login__blog-checkbox">
                                <label class="checkbox">@lang('auth.login.remember')
                                    <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
                                    <span class="checkmark"></span>
                                </label>
                                {{-- <a href="{{ route('frontend.user.reset') }}">@lang('auth.login.forget_password')</a> --}}
                            </div>
                            <button type="submit" class="btn">@lang('auth.login.submit')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
<script src="{{ asset('assets/js/jquery.mask.min.js') }}"></script>
<script>
    $(".js-phone-mask").mask("+999(99)999-99-99", { autoclear: false });
</script>
@endsection