@extends('layouts.frontend')

@section('meta')
    <meta name="description" content="{{ $product->meta_description_ru }}">
    <meta name="keywords" content="{{ $product->meta_title_ru }}">
@endsection

@section('content')
    <section class="product py-layout-xs">
        {{-- breadcrumb --}}
        <div class="container">
            {!! $breadcrumbs !!}
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-9 col-md-8">
                    {{-- slider --}}
                    <div class="row">
                        <div class="col-lg-6">
                            {{-- sliderbig --}}
                            <div class="relative">
                                <div class="product__image js-product-big">
                                    @if (!empty($product) && Upload::hasFiles('product', $product->id))
                                        @foreach (Upload::getFiles('product', $product->id) as $key => $file)
                                            <div>
                                                <a href="#" class="xzoom-a" tabindex>
                                                    <img src="{!! asset($file) !!}?cacheimg={{ rand(11111, 99999) }}"
                                                        alt="" class="product__image-img "
                                                        xoriginal="{!! asset($file) !!}?cacheimg={{ rand(11111, 99999) }}">
                                                </a>
                                            </div>
                                        @endforeach
                                    @else
                                        <img src="{{ asset('assets/images/no-image.png?v=1.1') }}"
                                        alt="" class="">
                                    @endif
                                </div>
                                {{-- @if (Upload::hasFile('product_video', $product->id))
                                <div class="product__video">
                                    <button class="product__video-close">
                                        <i class="icon-close"></i>
                                    </button>
                                    <video controls="" muted>
                                        <source src="{{ Upload::getFile('product_video', $product->id) }}">
                                    </video>
                                </div>
                                @endif
                                @if (Upload::hasFile('product_video', $product->id))
                                <button class="product__video-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.7"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="feather feather-play-circle">
                                        <circle cx="12" cy="12" r="10" />
                                        <polygon points="10 8 16 12 10 16 10 8" />
                                    </svg>
                                    Видео
                                </button>
                                @endif --}}
                            </div>
                            {{-- slidersmall --}}
                            <div class="relative">
                                <div class="product__images js-product-small">
                                    @if (!empty($product) && Upload::hasFiles('product', $product->id))
                                        @foreach (Upload::getFiles('product', $product->id) as $key => $file)
                                            <div class="product__images-slick">
                                                <div class="product__images-item">
                                                    <img src="{!! asset($file) !!}?cacheimg={{ rand(11111, 99999) }}"
                                                        alt="" class="product__images-img"
                                                        xpreview="{!! asset($file) !!}?cacheimg={{ rand(11111, 99999) }}">
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="arrows arrows--second">
                                    <i class="icon-arrow-left arrows__left js-arrowl-product"></i>
                                    <i class="icon-arrow-right arrows__right js-arrowr-product"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 detail">
                            <h1 class="font-medium text-xl mb-lg line-height-sm">{{ $product->name }}</h1>
                            
                            {{-- <div class="product__text">{{ $product->short_description }}</div> --}}
                            <div class="redactor-content line-height-sm">
                                {!! $product->description !!}
                            </div>
                        </div>
                    </div>
                   
                    {{-- endslider --}}

                </div>
                <div class="col-lg-3 col-md-4">
                    <div class="product__price">
                        <div class="product__rateyo">
                            <div class="rateyo" data-rating="{{ $product->rating }}"></div>
                        </div>
                        @if ($product->discount > 0)
                            <div>
                                <p class="product__price-discount">{{ $product->price_format }}</p>
                                <h2 class="product__price-summ">
                                    {{ $product->discount_price_format }}</h2>
                            </div>
                        @else
                            <div>
                                <h2 class="product__price-summ">{{ $product->price_format }}</h2>
                            </div>
                        @endif
                        @if ($product->quantity > 0)
                            <p class="d-flex align-items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-package mr-xs"><line x1="16.5" y1="9.4" x2="7.5" y2="4.21"/><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/><polyline points="3.27 6.96 12 12.01 20.73 6.96"/><line x1="12" y1="22.08" x2="12" y2="12"/></svg>
                                @lang('main.in_stock') {{ $product->quantity }}
                            </p>
                            <button
                                {{ $product_cart && $product_cart->quantity >= $product->quantity ? 'disabled' : '' }}
                                class="btn d-block full-width mt-sm js-add-cart"
                                data-id="{{ $product->id }}">@lang('main.buy')</button>
                        @else
                            <p class="text-red d-flex align-items-center text-upper">
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-package mr-xs"><line x1="16.5" y1="9.4" x2="7.5" y2="4.21"/><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/><polyline points="3.27 6.96 12 12.01 20.73 6.96"/><line x1="12" y1="22.08" x2="12" y2="12"/></svg>
                                @lang('main.not_available')
                            </p>
                        @endif
                        <div class="d-flex align-items-center mt-sm">
                            <button
                                class="product__price-like mt-0 mr-xs {{ $product->is_favorite ? 'active' : '' }}"
                                data-favorite="{{ $product->is_favorite ? 'true' : 'false' }}"
                                data-id="{{ $product->id }}">
                                @if ($product->is_favorite)
                                    <svg data-v-57aaf377="" width="22" height="22" viewBox="0 0 19 16"
                                        fill="none" xmlns="http://www.w3.org/2000/svg" class="ui-icon ">
                                        <path
                                            d="M5.45 0.169434C8.01792 0.169434 9.5 2.32178 9.5 2.32178C9.5 2.32178 10.985 0.169434 13.55 0.169434C16.205 0.169434 18.5 2.23943 18.5 5.11943C18.5 9.34995 12.0604 13.7892 9.86509 15.7297C9.65819 15.9126 9.34179 15.9126 9.13488 15.7297C6.94056 13.7903 0.5 9.34976 0.5 5.11943C0.5 2.23943 2.795 0.169434 5.45 0.169434Z"
                                            fill="#193E85"></path>
                                    </svg>
                                @else
                                    <svg data-v-b3e9397c="" width="22" height="22" viewBox="0 0 20 20"
                                        fill="none" xmlns="http://www.w3.org/2000/svg" alt="like"
                                        class="ui-icon ">
                                        <path
                                            d="M5.95 2C8.51792 2 10 4.15234 10 4.15234C10 4.15234 11.485 2 14.05 2C16.705 2 19 4.07 19 6.95C19 11.1805 12.5604 15.6197 10.3651 17.5603C10.1582 17.7432 9.84179 17.7432 9.63488 17.5603C7.44056 15.6209 1 11.1803 1 6.95C1 4.07 3.295 2 5.95 2Z"
                                            fill="white" fill-opacity="0.8"></path>
                                        <path
                                            d="M1 6.86486C1 4.20297 3.15017 2 5.86486 2C7.98685 2 9.35921 3.35876 10 4.18673C10.6408 3.35876 12.0132 2 14.1351 2C16.8506 2 19 4.20302 19 6.86486C19 8.02987 18.5328 9.18622 17.8534 10.265C17.1716 11.3476 16.252 12.3903 15.29 13.3377C13.9567 14.6508 12.4757 15.8387 11.4134 16.6907C10.9618 17.0529 10.5859 17.3544 10.3293 17.579C10.1407 17.7439 9.85926 17.7439 9.67075 17.579C9.41405 17.3544 9.03815 17.0529 8.58659 16.6907C7.52431 15.8387 6.04326 14.6508 4.70997 13.3377C3.74802 12.3903 2.82836 11.3476 2.14659 10.265C1.46724 9.18622 1 8.02987 1 6.86486ZM5.86486 3C3.70929 3 2 4.74838 2 6.86486C2 7.76743 2.36553 8.73607 2.99277 9.73208C3.61759 10.7242 4.47833 11.706 5.41165 12.6252C6.71033 13.9042 8.08423 15.005 9.13396 15.8461C9.45728 16.1052 9.74985 16.3396 10 16.547C10.2501 16.3396 10.5427 16.1052 10.866 15.8461C11.9158 15.005 13.2897 13.9042 14.5883 12.6252C15.5217 11.706 16.3824 10.7242 17.0072 9.73208C17.6345 8.73607 18 7.76743 18 6.86486C18 4.74833 16.2914 3 14.1351 3C12.0406 3 10.8181 4.70211 10.5033 5.21028C10.2727 5.5825 9.72727 5.58249 9.4967 5.21027C9.1819 4.7021 7.95944 3 5.86486 3Z"
                                            fill="#15151A"></path>
                                    </svg>
                                @endif
                            </button>
                            <p>@lang('main.to_favorite')</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab" id="review">
                {{-- <ul class="tabs">
                    <li class="tab-link current" data-tab="tab-1">@lang('main.info_prod')</li>
                    @if (Upload::hasFile('product_video', $product->id))
                        <li class="tab-link" data-tab="tab-3">@lang('main.video')</li>
                    @endif
                    <li class="tab-link js-review-link" data-tab="tab-2">@lang('main.review') <span
                            class="tab-link__blue">{{ $product->count_comment }}</span></li>
                </ul> --}}

                <div id="tab-1" class="tab-content">
                    <div class="redactor-content line-height-sm">
                        {!! $product->description !!}
                    </div>
                </div>
                @if (Upload::hasFile('product_video', $product->id))
                    <div id="tab-3" class="tab-content current">
                        <video controls="" muted width="100%">
                            <source src="{{ Upload::getFile('product_video', $product->id) }}">
                        </video>
                    </div>
                @endif
                <div id="tab-2" class="tab-content js-review-content current">
                    <div class="review">
                        @if ($product->comments()->where('status', 1)->count() > 0)
                            <div class="review__comments">
                                @foreach ($product->comments()->where('status', 1)->orderBy('created_at', 'DESC')->get() as $comment)
                                    <div class="review__comments-item">
                                        <div class="d-flex align-items-center justify-content-between mb-sm">
                                            <p class="review__comments-name">{{ $comment->user->full_name ?? '' }}
                                            </p>
                                            <span
                                                class="text-sm text-silver">{{ $comment->created_at->format('d.m.Y | H:i') }}</span>
                                        </div>
                                        <div class="rateyo" data-rating="{{ $comment->rating ?? '' }}"></div>
                                        <p class="mt-sm">{{ $comment->review }}</p>
                                    </div>
                                @endforeach
                            </div>
                            @if ($open_comment)
                                <div class="text-center">
                                    <button class="btn mt-md js-review-modal-btn">@lang('main.feedback')</button>
                                </div>
                            @endif
                        @else
                            <div class="review__empty">
                                <i
                                    class="icon-chat-comment-oval-speech-bubble-with-text-lines review__empty-icon"></i>
                                <div class="text-center" style="display: none;">
                                    <p class="review__empty-title">@lang('main.empty_review').</p>
                                    <p class="text-silver mt-sm text-center">@lang('main.auth_review').</p>
                                    <a href="" class="btn mt-md">@lang('main.login')</a>
                                </div>
                                <div class="text-center">
                                    <p class="review__empty-title">@lang('main.empty_review').</p>
                                    @if (auth()->check())
                                        <button class="btn mt-md js-review-modal-btn">@lang('main.feedback')</button>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    @if ($open_comment)
        <div class="modal js-review-modal">
            <div class="modal__review rounded">
                <div class="d-flex justify-content-between align-items-center">
                    <p class="text-xl font-bold">@lang('main.feedback')</p>
                    <i class="icon-close"></i>
                </div>
                <form class="js-comment" action="{{ route('product.comment', $product->id) }}">
                    <div class="d-flex justify-content-between align-items-center mt-md mb-sm">
                        <p class="text-lg text-silver">@lang('main.your_mark'):</p>
                        <div class="js-comment-rateyo"></div>
                        <input type="hidden" name="rating" value="5" class="js-comment-rating">
                    </div>
                    <div class="d-flex align-items-center mb-sm">
                        <i class="icon-comment-black-oval-bubble-shape"></i>
                        <p class="font-bold ml-sm">@lang('main.rev')</p>
                    </div>
                    <div class="form-group mb-0">
                        <textarea class="input modal__review-textarea js-comment-review" name="review" id="" rows="5"
                            placeholder="Поделитесь общими впечатлениями о товаре"></textarea>
                    </div>
                    <button type="submit" class="btn mt-sm full-width js-comment-btn">@lang('main.feedback')</button>
                </form>
            </div>
        </div>
    @endif
@endsection
@section('scripts')
    <script src="{{ asset('assets/js/xzoom.min.js') }}"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $(function() {
                // звезды на комментах(modal)
                var ratingInput = $('.js-comment-rating');
                $('.js-comment-rateyo').rateYo({
                    rating: 5,
                    fullStar: true,
                    ratedFill: '#FAC917',
                    starWidth: '22px',
                    readOnly: false,
                    onSet: function(rating, rateYoInstance) {
                        ratingInput.val(rating);
                    }
                });
            });
            $(".js-product-small").slick({
                slidesToShow: 4,
                dots: false,
                arrows: true,
                autoplay: false,
                focusOnSelect: true,
                prevArrow: $('.js-arrowl-product'),
                nextArrow: $('.js-arrowr-product'),
                asNavFor: '.js-product-big',
            });

            $(".js-product-big").slick({
                slidesToShow: 1,
                dots: false,
                arrows: false,
                autoplay: false,
                fade: true,
                asNavFor: '.js-product-small'
            });

            $(".product__image-img").each(function() {
                $(this).xzoom({
                    tint: '#eee',
                    adaptive: true,
                    zoomWidth: 355,
                    zoomHeight: 400,
                    Xoffset: 90,
                    Yoffset: -88
                });
            });

            function scrollOnLoad(arr) {
                var x = location.hash;
                $.each(arr, function(key, val) {
                    var positionY = $(val).offset().top;
                    if (x == val) {
                        $('body, html').animate({
                            scrollTop: positionY
                        }, 500);
                    }
                })
                $('.js-review-btn').on('click', function(e) {
                    e.preventDefault();
                    $('ul.tabs li').removeClass('current');
                    $('.tab-content').removeClass('current');
                    $('.js-review-link').addClass('current');
                    $('.js-review-content').addClass('current');
                    var link = $(this).attr('href').replace(/\//, '');
                    $('body, html').animate({
                        scrollTop: $(link).offset().top
                    }, 500);

                });
            }
            scrollOnLoad(['#review']);

            $('.js-review-modal-btn').click(function(event) {
                $('.modal').fadeIn();
                $('.modal__review').addClass('open');
                $('body').addClass('o-hidden');
            });

            $('.icon-close').click(function() {
                $('.modal__review').removeClass('open');
                $('.modal').fadeOut();
                $('body').removeClass('o-hidden');
            });

            $('.modal').click(function(event) {
                if (event.target == this) {
                    $('.modal__review').removeClass('open');
                    $('.modal').fadeOut();
                    $('body').removeClass('o-hidden');
                }
            })

            // Comment 
            var comment_submit = $(".js-comment-btn"),
                comment_form = $('.js-comment'),
                review = comment_form.find($("textarea[name='review']"));

            var review_input = review.parent();

            review.keyup(function() {
                review_input.removeClass('form-group--error');
                review_input.find('.form-group__error').removeClass('form-group__error').remove();
            });

            comment_submit.on('click', function(e) {
                e.preventDefault();
                var data = comment_form.serialize();
                comment_submit.attr('disabled', true);

                $.ajax({
                    type: "POST",
                    url: comment_form.attr('action'),
                    dataType: 'JSON',
                    data: data,

                    success: function(data) {
                        comment_submit.attr('disabled', false);
                        if (data.success) {
                            $('.js-comment-review').val('');
                            $('.js-review-modal').hide();
                            $('.js-review-modal > .modal__review').removeClass('open');
                            $('body').removeClass('o-hidden');

                            var nodeElement = document.createElement("div");
                            nodeElement.className = "comment-success"
                            nodeElement.innerHTML =
                                '<img src="/assets/images/check.png" alt="" />' +
                                '@lang("main.success_review")';
                            Toastify({
                                node: nodeElement,
                                duration: 3000,
                                stopOnFocus: true,
                                gravity: "top",
                                position: "center",
                                offset: {
                                    y: 20 // vertical axis - can be a number or a string indicating unity. eg: '2em'
                                },
                                style: {
                                    background: "#fff",
                                }
                            }).showToast();

                            // window.location.reload();
                        } else {
                            if (!review_input.hasClass('form-group--error')) {
                                var review_error = $('<p class="form-group__error">' + data
                                    .errors.review + '</p>');
                                review_input.append(review_error).addClass('form-group--error');
                            }
                        }
                    }
                });
            });

            $('.product__video-btn').click(function() {
                $('.product__video').fadeIn(300)
            })

            $('.product__video-close').click(function() {
                $('.product__video').fadeOut(200)
                $('.product__video > video').get(0).pause();
                $('.product__video > video').get(0).currentTime = 0;
            })

            $('.product__images-item').click(function() {
                $('.product__video').fadeOut(200)
                $('.product__video > video').get(0).pause();
                $('.product__video > video').get(0).currentTime = 0;
            })


        });
    </script>
@endsection
