@extends('layouts.frontend')

@section('content')
    <div class="preloader js-filter-preloader">
        <div class="preloader-content">
            {{-- <span></span>
            <span></span>
            <span></span>
            <span></span> --}}
        </div>
    </div>
    <section class="products py-layout-xs">
        <div class="container">
            {!! $breadcrumbs !!}
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-3 products__sidebar">
                    <div class="products__filter">
                        <div class="products__filter-item">
                            @if ($category == 'all')
                                <p class="products__filter-title">@lang('main.categories')</p>
                                <ul class="products__filter-category">
                                    @foreach ($parent_categories as $parent_category)
                                        <li>
                                            <a
                                                href="{{ route('frontend.product.index', $parent_category->alias) }}">{{ $parent_category->name }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            @else
                                <ul class="products__filter-category mt-sm">
                                    <li>
                                        <a href="{{ route('frontend.product.index', 'all') }}"
                                            class="d-flex align-items-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-chevron-left mr-xxs">
                                                <polyline points="15 18 9 12 15 6" />
                                            </svg>
                                            @lang('main.all_category')
                                        </a>
                                    </li>
                                    <li>
                                        <a
                                            href="{{ route('frontend.product.index', $category->parent ? $category?->parent?->alias : $category->alias) }}"><b>
                                                {{ $category->parent ? $category?->parent?->name : $category->name }}
                                            </b></a>
                                    </li>
                                    @foreach ($category->parent ? $category?->parent?->children : $category->children as $child)
                                        <li class="pl-sm">
                                            <a href="{{ route('frontend.product.index', [$category->parent ? $category->parent->alias : $category->alias, $child->alias]) }}"
                                                class="{{ $category->id == $child->id ? 'active' : '' }}">{{ $child->name }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        <div class="products__filter-item">
                            <p class="products__filter-title">@lang('main.price')</p>
                            <div class="products__filter-summ">
                                <div class="relative">
                                    <input type="text" name="price_min" class="input js-filter js-filter-price"
                                        placeholder="@lang('main.from')" value="{{ $inputs['price_min'] ?? '' }}">
                                </div>
                                <div class="relative">
                                    <input type="text" value="{{ $inputs['price_max'] ?? '' }}" name="price_max"
                                        class="input js-filter js-filter-price" placeholder="@lang('main.to')">
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="categories[]"
                            value="{{ $category != 'all' ? $category->id : $category }}" class="js-filter">
                        @if (count($manufacturers) > 0)
                            <div class="products__filter-item">
                                <p class="products__filter-title">@lang('main.car_brands')</p>
                                @foreach ($manufacturers as $m_key => $manufacturer)
                                    <div class="mb-sm">
                                        <label class="checkbox" for="mnf_{{ $m_key }}">{{ $manufacturer->name }}
                                            <input type="checkbox" name="manufacturers[]" id="mnf_{{ $m_key }}"
                                                value="{{ $manufacturer->id }}"
                                                class="js-filter"{{ isset($inputs['manufacturers']) && in_array($manufacturer->id, $inputs['manufacturers']) ? ' checked="checked"' : '' }}>
                                            <span class="checkmark"></span>
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                        @if (count($cars) > 0)
                            <div class="products__filter-item">
                                <p class="products__filter-title">@lang('main.cars')</p>
                                <div class="js-list-filter">
                                    @foreach ($cars as $c_key => $car)
                                        <div class="mb-sm">
                                            <label class="checkbox" for="car_{{ $c_key }}">{{ $car->name }}
                                                <input type="checkbox" name="cars[]" id="car_{{ $c_key }}"
                                                    value="{{ $car->id }}"
                                                    class="js-filter"{{ isset($inputs['cars']) && in_array($car->id, $inputs['cars']) ? ' checked="checked"' : '' }}>
                                                <span class="checkmark"></span>
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        {{-- <div class="mb-sm">
                            <label class="checkbox" for="spare_part_1">@lang('main.to_1')
                                <input type="checkbox" name="spare_part[]" id="spare_part_1" value="1"
                                    class="js-filter"{{ isset($inputs['spare_part']) && in_array(1, $inputs['spare_part']) ? ' checked="checked"' : '' }}>
                                <span class="checkmark"></span>
                            </label>
                        </div>
                        <div class="mb-sm">
                            <label class="checkbox" for="spare_part_2">@lang('main.to_2')
                                <input type="checkbox" name="spare_part[]" id="spare_part_2" value="2"
                                    class="js-filter"{{ isset($inputs['spare_part']) && in_array(2, $inputs['spare_part']) ? ' checked="checked"' : '' }}>
                                <span class="checkmark"></span>
                            </label>
                        </div> --}}
                        <button class="full-width products__sidebar-btn">Показать</button>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="products__sort">
                        <div class="d-flex align-items-center">
                            <p class="products__sort-title">@lang('main.sort'):</p>
                            <select name="sort_by" class="js-select js-filter">
                                <option value="popular"
                                    {{ isset($inputs['sort_by']) && $inputs['sort_by'] == 'popular' ? 'selected' : '' }}>
                                    @lang('main.popularity')</option>
                                <option value="price_asc"
                                    {{ isset($inputs['sort_by']) && $inputs['sort_by'] == 'price_asc' ? 'selected' : '' }}>
                                    @lang('main.cheaper')</option>
                                <option value="price_desc"
                                    {{ isset($inputs['sort_by']) && $inputs['sort_by'] == 'price_desc' ? 'selected' : '' }}>
                                    @lang('main.expensive')</option>
                                <option value="rating"
                                    {{ isset($inputs['sort_by']) && $inputs['sort_by'] == 'rating' ? 'selected' : '' }}>
                                    @lang('main.high_rating')</option>
                            </select>
                        </div>
                        <div class="products__sort-toggle">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round"
                                stroke-linejoin="round" class="feather feather-filter js-filter-btn">
                                <polygon points="22 3 2 3 10 12.46 10 19 14 21 14 12.46 22 3" />
                            </svg>
                            <i class="icon-bullet-list products__sort-icons js-list"></i>
                            <i
                                class="icon-four-grid-layout-design-interface-symbol products__sort-icons js-grid active"></i>
                        </div>
                    </div>
                    <div class="products__content">
                        <div class="row js-products-container">
                            @foreach ($products as $product)
                                <div class="col-md-3 col-xs-6 js-blog">
                                    <div class="mb-md">
                                        @include('partials.product')
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="text-right mt-md js-pagination">
                        {!! $products->appends(array_filter(Request::except('categories')))->links('partials.paginate') !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="{{ mix('frontend/filter.min.js') }}"></script>
    <script src="{{ asset('assets/js/select.js') }}"></script>
    <script>
        $(document).ready(function() {
            new Filter({
                container: '.js-products-container',
                current_url: '{!! URL::current() !!}',
                url: '{{ route('frontend.product.filter') }}',
                trans: {
                    btn_reset: '@lang('filter.btn.reset')'
                }
            })
        });
        $(document).ready(function() {
            $('.js-list-filter').each(function() {
                var LiN = $(this).find('div').length;
                if (LiN > 4) {
                    $('div', this).eq(4).nextAll().hide().addClass('toggleable');
                    $(this).append(
                        '<div class="more">@lang("main.show_all") <i class="icon-dropdown ml-2"></i></div>');
                }
            });
            $('.js-list-filter').on('click', '.more', function() {
                if ($(this).hasClass('less')) {
                    $(this).html('@lang("main.show_all") <i class="icon-dropdown ml-2"></i>').removeClass('less');
                } else {
                    $(this).html('@lang("main.hide") <i class="icon-dropdown up ml-2"></i>').addClass('less');
                }
                $(this).siblings('div.toggleable').slideToggle(80);
            });
        });

        $('.js-select').niceSelect();
        $('.js-filter-btn').click(function() {
            $('.products__sidebar').slideDown(200)
        })
        $('.products__sidebar-btn').click(function() {
            $('.products__sidebar').slideUp(200)
        })
    </script>
@endsection
