@extends('layouts.frontend')

@section('content')
    <section class="car py-layout-xs">
        {{-- breadcrumb --}}
        <div class="container">
            <ul class="breadcrumb">
                <li class="breadcrumb__item">
                    <a href="{{ route('home') }}">@lang('main.home')</a>
                </li>
                <li class="breadcrumb__item">
                    <a href="#">{{ $manufacturer->name }}</a>
                </li>
            </ul>
        </div>
        <div class="container">
            <h2 class="title-lg text-upper">{{ $manufacturer->name }}</h2>
            <div class="row">
                <div class="car__content">
                    @if ($manufacturer->cars()->exists())
                        @foreach ($manufacturer->cars as $car)
                            <div class="col-md-3 col-sm-4 col-xs-6 mb-sm">
                                <a href="{{ route('frontend.product.category', [$manufacturer->alias, $car->alias]) }}">
                                    <div class="car__blog">
                                        <div class="car__blog-image">
                                            <img src="{{ Upload::hasFile('car', $car->id) ? Upload::getFile('car', $car->id) : asset('assets/images/toha.png') }}"
                                                alt="">
                                        </div>
                                        <p class="car__blog-text">{{ $car->name }}</p>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection
