@extends('layouts.frontend')

@section('content')
    <section class="main">
        {{-- BANNER --}}
        <div class="main__banner pb-layout-xs mt-sm">
            <div class="container">
                <div class="row">
                    <div class="col-lg-9 col-md-8">
                        <div class="js-main-slider main__banner-slider dots">
                            @foreach ($sliders as $slider)
                                <div>
                                    <a href="{{ $slider->url_format }}">
                                        <img src="{{ $slider->image_format }}" alt="">
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-4">
                        <div class="main__banner-slider js-main-banner dots">
                            @foreach ($banner as $item)
                                <a href="{{ $item->url_format }}">
                                    <img src="{{ $item->image_format }}">
                                </a>
                            @endforeach
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        {{-- ENDBANNER --}}

        {{-- MANUFACTURER --}}

        {{-- CAR --}}
        <div class="car pt-md pb-layout">
            <div class="container">
                <h2 class="title mb-sm">Популярные бренды</h2>
                <div class="">
                    <div class="car__content">
                        <div class="row">
                            @foreach ($manufacturers as $manufacturer)
                            <div class="col-md-2 col-xs-6">
                                <a href="{{ route('frontend.product.category', $manufacturer->alias) }}">
                                    <div class="car__blog">
                                        <div class="car__blog-image">
                                            <img src="{{ $manufacturer->image_format }}" alt="">
                                        </div>
                                        {{-- <p class="car__blog-text">Taheo</p> --}}
                                    </div>
                                </a>
                            </div>
                        @endforeach
                        </div>
                        {{-- <div class="arrows">
	                        <i class="icon-arrow-left arrows__left js-arrowl-car"></i>
	                        <i class="icon-arrow-right arrows__right js-arrowr-car"></i>
	                    </div> --}}
                    </div>
                </div>
            </div>
        </div>
        {{-- ENDCAR --}}

        {{-- <div class="main__product main__product--to bg-white pt-layout-xs pb-layout-xs">
            <div class="container">
                <div class="row">
                    <div class="col-sm-6">
                        <a href="{{ route('frontend.product.index', ['all', 'spare_part[]' => 1]) }}"
                            class="main__product--to__item">
                            <p>@lang('main.to_1')</p>
                            <img src="{{ asset('assets/images/to-1.jpg?v=1.1') }}" alt="" width="100%">
                        </a>
                    </div>
                    <div class="col-sm-6">
                        <a href="{{ route('frontend.product.index', ['all', 'spare_part[]' => 2]) }}"
                            class="main__product--to__item">
                            <p>@lang('main.to_2')</p>
                            <img src="{{ asset('assets/images/to-2.jpg?v=1.1') }}" alt="" width="100%">
                        </a>
                    </div>
                </div>
            </div>
        </div> --}}

        {{-- хит продаж --}}
        <div class="main__product bg-white py-layout-xs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-start mb-sm">
                    <h2 class="title">Рекомендуемые тоавары</h2>
                    <a href="{{ route('frontend.product.index', ['all']) }}" class="link">
                        Смотреть все
                    </a>
                </div>
                <div class="">
                    <div class="main__product-content">
                        <div class="js-main-product dots">
                            @foreach ($xits as $key => $product)
                                <div class="">
                                    @include('partials.product')
                                </div>
                            @endforeach
                        </div>
                        <div class="arrows">
	                        <i class="icon-arrow-left arrows__left js-arrowl-product"></i>
	                        <i class="icon-arrow-right arrows__right js-arrowr-product"></i>
	                    </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Акция --}}
        @if ($discounts->count() > 5)
            <div class="main__product bg-white pb-layout-xs">
                <div class="container">
                    <div class="d-flex justify-content-between align-items-start mb-sm">
                        <h2 class="title">@lang('main.promotion')</h2>
                        <a href="{{ route('frontend.product.index', ['all']) }}" class="link">
                            Смотреть все
                        </a>
                    </div>
                    <div class="">
                        <div class="main__product-content">
                            <div class="js-main-product dots">
                                @foreach ($discounts as $key => $product)
                                    <div class="">
                                        @include('partials.product')
                                    </div>
                                @endforeach
                            </div>
                            {{-- <div class="arrows">
	                        <i class="icon-arrow-left arrows__left js-arrowl-product"></i>
	                        <i class="icon-arrow-right arrows__right js-arrowr-product"></i>
	                    </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        @endif

        @foreach ($main_pages as $main)
            <div class="main__product pb-layout">
                <div class="container">
                    {{-- <a href="{{ $main->link_format }}"
                        class="{{ Upload::hasFile('main_page_' . app()->getLocale(), $main->id) ? '' : 'hide' }}">
                        <img src="{{ $main->image_format }}" alt="" class="full-width mb-md rounded">
                    </a> --}}

                    <div class="d-flex justify-content-between align-items-start mb-sm">
                        <h2 class="title">{{ $main->category->name ?? '' }}</h2>
                        <a href="{{ route('frontend.product.index', [$main->category->alias]) }}" class="link">
                            Смотреть все
                        </a>
                    </div>
                    @if(is_null($main->image_format))
                    <div class="">
                        <div class="main__product-content">
                            <div class="js-main-product dots">
                                @if ($main->category && $main->category->products()->exists())
                                    @foreach ($main->category->products()->where('quantity', '>', 0)->limit(15)->get() as $key => $product)
                                        <div class="">
                                            @include('partials.product')
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            {{-- <div class="arrows">
                                <i class="icon-arrow-left arrows__left js-arrowl-product"></i>
                                <i class="icon-arrow-right arrows__right js-arrowr-product"></i>
                            </div> --}}
                        </div>
                    </div>
                    @else
                    <div class="main__product-content">
                        <div class="row">
                            <div class="col-md-3">
                                <a class="main__product-content_baner" href="{{ $main->link_format }}"
                                    class="{{ Upload::hasFile('main_page_' . app()->getLocale(), $main->id) ? '' : 'hide' }}">
                                    <img src="{{ $main->image_format }}" alt="" class="">
                                </a>
                            </div>
                            <div class="col-md-9">
                                <div class="row js-main-product-sm dots">
                                    @foreach ($main->category->products()->where('quantity', '>', 0)->limit(8)->get() as $key => $product)
                                        <div class="col-md-3">
                                            @include('partials.product')
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        @endforeach

        <div class="bg-gray">
            <div class="py-layout pb-lg">
                <div class="container">
                    <div class="row">
                        <div class="col-md-7">
                            <h2 class="main__about-title">
                                Почему стоит купить запчасти для спецтехники у нас</h2>
                            <p class="mb-xs">Компания «Simma Auto Star» опытный поставщик запчастей и комплектующих для дорожно-строительной техники. Мы долгие годы напрямую сотрудничаем с ведущими производителями, что позволяет нам сдерживать рос цен и предлагать клиентам прогрессивные скидки. Продажа деталей – одно из направлений нашей работы, а значит – мы заинтересованы во взаимовыгодных отношениях с заказчиком. Если Вы обращаетесь к нам за ремонтом или техническим обслуживанием, мы поможем Вам купить детали для строительной техники экономно и быстро.
                            </p>
                        </div>
                        <div class="col-md-5">
                            <div class="text-center">
                                <img src="{{ asset('assets/images/about.png') }}" alt="" width="70%">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    
            {{-- <div class="pb-layout">
                <div class="container">
                    <h3 class="title mb-lg">Популярные бренды</h3>
                    <div class="js-slider-brand">
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/13/vmKUl47XvkKOk7JNiHYocpsqa8qG4BeqgsGUxu7n.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/12/Z80j1I28Qnlm9DlCA4syV4V6rnUAi7TA6LT2LU1v.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/11/SoNSp2iTkTwZFpnpgdkPG9Ujg360oJr0yDqStQ57.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/10/macH1IJIuJHJL0zZr9MuHwTeB0HCtHN9IcR0stEV.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/9/7aGocUdUZcJpLq3TcbBx4lXSecYOXDbOsTeuTKlt.jpg"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/8/zLAoGkZPrTvEc3iTUdTJZK5R60Hl1KRYPu7mnNGk.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/7/vYbe4sXxYTvhxcmKRrvufTXTH6olJHcqrupqUDgo.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/6/CzJq0AzV89MYEQZoMbFI9QXGCFXSycTZr27sIZU1.png"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/5/u1VKbNBG6knFoR5qQdFkPGf070vump4J0AdQ1hA4.jpg"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/4/oXakTjuTEUYxupVnFsuzCgNsvXdd6DwN4JuBepSE.jpg"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/3/Pt2bFUxNNf3zOfYR3ipDDWcvW0U36XslC58wKXZ3.jpg"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/2/bHqxZCoQPTBdn3TjNBpYrza7xloEgmwdvOEV2Unf.jpg"
                                    alt="">
                            </div>
                        </div>
    
                        <div>
                            <div class="main-brand">
                                <img src="https://flex.uz/storage/brand/logotype/1/aUsTxY04jgoqGPYLLvwsWtAnyHMbRQxbvCQZXTl8.jpg"
                                    alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}
        </div>
    </section>
@endsection
@section('styles')
    <link rel="stylesheet" href="{{ asset('assets/css/rpopup.min.css?v=1.1') }}">
@endsection
@section('scripts')
    <script src="{{ asset('assets/js/jquery.rPopup.js') }}"></script>
    <script>
        var $AcHostedPopup = $('.hosted-popup');
        if ($AcHostedPopup.length > 0) {
            $AcHostedPopup.rPopup({
                'video': {
                    embed: true,
                    autoplay: true,
                    image: true
                },
            });
        }

        $('.js-slider-brand').slick({
            slidesToShow: 8,
            arrows: false,
            variableWidth: true,
        })
    </script>
@endsection
