@extends('layouts.frontend')

@section('styles')
<link href="{{ asset('backend/plugins/sweet-alert/sweetalert2.min.css') }}" rel="stylesheet" type="text/css"/>
@endsection

@section('content')
	<section class="contact py-layout-xs">
		{{-- breadcrumb --}}
		<div class="container">
			<ul class="breadcrumb">
		    	<li class="breadcrumb__item">
		    		<a href="#">@lang('main.home')</a>
		    	</li>
		    	<li class="breadcrumb__item">
		    		<a href="#">@lang('main.top.contact')</a>
		    	</li>
		 	</ul>
		</div>
		{{-- endbreadcrumb --}}
		<div class="container">
			<h1 class="title">@lang('main.top.contact')</h1>
			<div class="row">
				<div class="col-lg-12">
					<div class="row">
						<div class="col-md-4">
							<div class="contact__info">
								<div class="contact__info-title">
									<i class="icon-phone-call"></i>
									<p>@lang('main.phone')</p>
								</div>
								<div class="contact__info-inf">
									<a href="tel:+998981158885">+998 98 115 88 85</a><br>
									<a href="tel:+998983142229">+998 98 314 22 29</a>
								</div>
							</div>
							<div class="contact__info">
								<div class="contact__info-title">
									<i class="icon-envelope"></i>
									<p>@lang('main.email')</p>
								</div>
								<div class="contact__info-inf">
									<a target="_blank" href="mailto:info@driversvillage.uz">simmastar@mail.ru</a>
								</div>
							</div>
							<div class="contact__info">
								<div class="contact__info-title">
									<i class="icon-facebook-placeholder-for-locate-places-on-maps"></i>
									<p>@lang('main.address')</p>
								</div>
								<div class="contact__info-inf">
									@lang('main.address_info')
								</div>
							</div>
                        </div>
						<div class="col-md-8">
							<div class="contact__map" id="map"></div>
							<form class="mt-md" action="{{ route('frontend.contact.form') }}" method="POST">
								@csrf
								<div class="row">
									<div class="form-group col-md-6 {{ $errors->has('name') ? 'form-group--error' : '' }}">
										<input type="text" name="name" class="input input--white" placeholder="@lang('main.full_name')">
										@error('name')
										<label for="name" class="form-group__error">{{ $message }}</label>
										@enderror
									</div>
									<div class="form-group col-md-6 {{ $errors->has('phone') ? 'form-group--error' : '' }}">
										<input type="text" name="phone" value="{{ request()->old('phone', '998') }}" class="input input--white js-phone-mask">
										@error('phone')
										<label for="phone" class="form-group__error">{{ $message }}</label>
										@enderror
									</div>
									<div class="form-group col-md-12 {{ $errors->has('message') ? 'form-group--error' : '' }}">
										<textarea name="message" class="input input--white" placeholder="@lang('main.message')"></textarea>
										@error('message')
										<label for="message" class="form-group__error">{{ $message }}</label>
										@enderror
									</div>
									<div class="col-md-12">
										<button type="submit" class="btn d-block full-width">@lang('main.send')</button>
									</div>
								</div>
							</form>
						</div>
                        
					</div>
				</div>
			</div>
			
		</div>
	</section>
@endsection
@section('scripts')
<script src="{{ asset('backend/plugins/sweet-alert/sweetalert2.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery.mask.min.js') }}"></script>
<script src="https://api-maps.yandex.ru/2.1/?apikey=52f2c420-0a04-4ca5-ae04-4468b3d29841&lang=ru_RU" type="text/javascript">
</script>
<script>
    @if(session()->has('success'))
        swal({
            title: '<i class="fa fa-thumbs-up"></i>',
            text: '{{ session()->get("success") }}',
            type: 'success',
            confirmButtonColor: '#4fa7f3'
        });
    @endif
    $(".js-phone-mask").mask("+999(99)999-99-99", { autoclear: false });
	ymaps.ready(init);

	function init() {
		var myMap = new ymaps.Map("map", {
			center: [41.223541, 69.199589],
			zoom: 16,
			controls: []
		});
		myMap.geoObjects.add(new ymaps.Placemark([41.223541, 69.199589], {
			balloonContent: '<span>Chevrolet</span>'
		}, {
			preset: 'islands'
		}));
	}
</script>
@endsection