@extends('layouts.frontend')

@section('content')
<section class="py-layout-xs">
    <div class="container">
        <ul class="breadcrumb">
            <li class="breadcrumb__item">
                <a href="{{ route('home') }}">@lang('main.home')</a>
            </li>
            <li class="breadcrumb__item">
                <a href="#">@lang('main.our_blog')</a>
            </li>
        </ul>
    </div>
    <div class="container">
        <div class="row">
            @foreach($blogs as $key => $blog)
            <div class="col-md-4 col-sm-6">
                <div class="news-card" style="background-image: url('{{ Upload::hasFile('main_blog', $blog->id) ? Upload::getFile('main_blog', $blog->id) : '' }}')">
                    <a href="{{ route('frontend.blog.show', ['alias' => $blog->alias]) }}">
                        <div class="news-card__content">
                            <p class="news-card__title">{{ $blog->title }}</p>
                            <div class="news-card__line"></div>
                            {{-- <p class="news-card__short-text">{{ Str::limit($blog->short_text, 140) }}</p> --}}
                            <span class="news-card__date">{{ $blog->created_at->isoFormat('D MMMM YYYY') }}</span>
                        </div>
                    </a>
                </div>
            </div>
            @endforeach
        </div>
        <div class="text-right mt-lg">
            {!! $blogs->links('partials.paginate') !!}	
        </div>
    </div>
</section>
@endsection