
@extends('layouts.frontend')

@section('content')
<section class="login pb-layout pt-layout-xs">
    <div class="container">
        {{-- <h1 class="title text-center">Номер заказа 101</h1> --}}
        <div class="row">
            
            <div class="col-lg-6 col-lg-push-3">
                <div class="login__blog bg-white">
                    <h1 class="text-center text-success">Ваш заказ сформирован</h1>
                    <h2 class="text-center text-blue">Номер заказа: {{ $order->id }}</h2>
                    @if(true)
                    <div class="text-center">
                        <img src="{{ asset('assets/images/comp-success.png') }}" alt="" height="200">
                    </div>
                    <div class="text-center">
                        Для завершения оформления заказа и оплаты, нажмите на кнопку «Оплатить» <br/>
                        @if (auth()->check())
                        Перейдите в личный кабинет, чтобы отслеживать статус заказов.
                        @endif
                    </div>
                    <div class="text-center mt-sm">
                        @if ($order->is_online_payment)
                            <form method="POST" action="https://checkout.paycom.uz/">
                                <input type="hidden" name="merchant" value="{{ config('payments.systems.paycom.merchant_id') }}"/>
                                <input type="hidden" name="amount" value="{{ $order->total_cost*100 }}"/>
                                <input type="hidden" name="account[order_id]" value="{{ $order->id }}"/>
                                <input type="hidden" name="lang" value="ru"/>
                                <input type="hidden" name="callback" value="{{ route('home') }}"/>
                                <input type="hidden" name="description" value="Driversvillage"/>
                                <button type="submit" class="btn">Оплатить</button>
                            </form>
                        @else
                            <a href="{{ route('home') }}" class="btn">@lang('main.back_to_home')</a>
                        @endif
                    </div>
                    @else
                    <div class="text-center mb-3">
                        <img src="{{ asset('assets/images/comp-error.png') }}" alt="" height="200">
                    </div>
                    <div class="text-center">
                        Lorem ipsum dolor sit amet consectetur, adipisicing elit. Autem amet aliquam nisi, explicabo odit quo, expedita maxime numquam.
                    </div>
                    <div class="text-center mt-sm">
                        <a href="" class="btn">Lorem</a>
                    </div>
                    @endif
                </div>
            </div>
            
    </div>
</section>
@endsection

