@extends('layouts.frontend')

@section('content')
    <div class="preloader js-checkout-preloader">
        <div class="preloader-content">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <section class="checkout py-layout-xs">
        <div class="container">
            <ul class="breadcrumb">
                <li class="breadcrumb__item">
                    <a href="{{ route('home') }}">@lang('main.home')</a>
                </li>
                <li class="breadcrumb__item">
                    <a href="{{ route('frontend.cart.list') }}">@lang('main.navbar.cart')</a>
                </li>
                <li class="breadcrumb__item">
                    <a href="#">@lang('main.checkout')</a>
                </li>
            </ul>
        </div>
        <form action="{{ route('cart.checkout-form') }}" method="POST" class="js-checkout-form">
            @csrf
            <div class="container">
                <h1 class="title text-black mb-lg">@lang('main.checkout')</h1>
                <div class="row">
                    <div class="col-md-8">
                        <div class="checkout__content box-shadow--silver rounded">
                            <h2 class="title-lg">@lang('main.contact_info')</h2>
                            <div class="row mb-sm">
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" value="{{ auth()->user()->last_name ?? '' }}" class="input"
                                            placeholder="@lang('cabinet.profile.last_name')" name="last_name">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" value="{{ auth()->user()->first_name ?? '' }}" class="input"
                                            placeholder="@lang('cabinet.profile.name')" name="first_name">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="relative">
                                            <input {{ auth()->check() ? 'disabled' : '' }} type="text"
                                                value="{{ auth()->user()->phone ?? old('phone', 998) }}"
                                                class="input js-phone-mask" placeholder="@lang('main.phone_number')"
                                                name="phone_number">
                                            {{-- <div class="lds-ring active"><div></div><div></div><div></div><div></div></div> --}}
                                        </div>
                                        {{-- <div class="relative text-center">
                                            <input type="text"
                                            class="input" placeholder="123456" name="phone_number">
                                            <p class="text-blue checkout__timer">Выслать код повторно через <span class="js-timer">-:-</span></p>
                                        </div> --}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" class="input js-phone-mask"
                                            value="{{ old('additional_number') }}"
                                            placeholder="@lang('main.phone_number_dop')" name="additional_number">
                                    </div>
                                </div>
                            </div>

                            <div class="checkout__access access-hide">
                                <h2 class="title-lg">@lang('main.choose_type_delivery')</h2>
                                <div class="checkout__pay">
                                    <div class="row mb-md">
                                        <div class="col-lg-6">
                                            <label class="js-check">
                                                <input type="radio" name="delivery_type"
                                                    class="checkout__pay-radio js-delivery-type" data-text="Самовывоз"
                                                    checked value="pickup" />
                                                <div class="checkout__pay-item">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="37"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"
                                                        class="feather feather-user-check checkout__pay-icon">
                                                        <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2" />
                                                        <circle cx="8.5" cy="7" r="4" />
                                                        <polyline points="17 11 19 13 23 9" />
                                                    </svg>
                                                    <p class="checkout__pay-title">
                                                        @lang('main.pick_up')<br>
                                                        <span>@lang('main.pick_up_desc')</span>
                                                    </p>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-lg-6">
                                            <label class="js-check">
                                                <input type="radio" name="delivery_type" data-text="Доставка"
                                                    class="checkout__pay-radio js-delivery-type" value="express" />
                                                <div class="checkout__pay-item">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="37" height="37"
                                                        viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                        stroke-width="1" stroke-linecap="round" stroke-linejoin="round"
                                                        class="feather feather-truck">
                                                        <rect x="1" y="3" width="15" height="13" />
                                                        <polygon points="16 8 20 8 23 11 23 16 16 16 16 8" />
                                                        <circle cx="5.5" cy="18.5" r="2.5" />
                                                        <circle cx="18.5" cy="18.5" r="2.5" />
                                                    </svg>
                                                    <p class="checkout__pay-title">
                                                        @lang('main.express')<br>
                                                        <span>@lang('main.express_desc')</span>
                                                    </p>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="js-delivery-address hide">
                                    <h2 class="title-lg">@lang('cabinet.address.add')</h2>
                                    <div class="row mb-sm">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <select name="region_id" class="input" disabled>
                                                    {{-- <option value="0" selected disabled>Выберите город</option> --}}
                                                    {{-- @foreach ($regions as $region) --}}
                                                    <option value="{{ $region->id }}" selected>{{ $region->name }}
                                                    </option>
                                                    {{-- @endforeach --}}
                                                </select>
                                            </div>
                                        </div>
                                        <input type="hidden" name="region_id" value="{{ $region->id }}">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <select name="district_id" class="input">
                                                    <option value="0" selected disabled>@lang('main.choose_region')</option>
                                                    @foreach ($cities as $city)
                                                        <option value="{{ $city->id }}">{{ $city->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="text" class="input" placeholder="Узбекистан, 100088, Ташкент, Янгихаётский район, ул. Навруз, 22"
                                                    name="address">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- <h2 class="title-lg">@lang('main.pay_method')</h2>
                                <div class="checkout__pay">
                                    <div class="row mb-md">
                                        <div class="col-lg-4">
                                            <label class="js-check-pay">
                                                <input type="radio"
                                                    {{ $cartTotal > config('payments.limit') ? 'disabled' : '' }}
                                                    name="payment_type" data-text="@lang('main.online_pay')"
                                                    class="checkout__pay-radio js-payment-type" value="online" />
                                                <div class="checkout__pay-item">
                                                    <i class="icon-shopping-cart checkout__pay-icon"></i>
                                                    <p class="checkout__pay-title">@lang('main.online_pay')</p>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-lg-4 js-hide-delivery">
                                            <label class="js-check">
                                                <input type="radio" name="payment_type"
                                                    class="checkout__pay-radio js-payment-type"
                                                    data-text="@lang('main.cash')"
                                                    {{ old('payment_type') == 'cash' ? 'checked' : 'checked' }}
                                                    value="cash" />
                                                <div class="checkout__pay-item">
                                                    <i class="icon-wallet checkout__pay-icon"></i>
                                                    <p class="checkout__pay-title">@lang('main.cash')</p>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-lg-4 js-hide-delivery">
                                            <label class="js-check">
                                                <input type="radio" name="payment_type" data-text="Оплата по терминалу"
                                                    class="checkout__pay-radio js-payment-type" value="terminal"
                                                    {{ old('payment_type') == 'terminal' ? 'checked' : '' }} />
                                                <div class="checkout__pay-item">
                                                    <i class="icon-credit-cards-payment checkout__pay-icon"></i>
                                                    <p class="checkout__pay-title">@lang('main.pay_ter')</p>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div> --}}
                                <div class="js-payment-types hide">
                                    <div class="checkout__systems">
                                        {{-- <label class="radio d-flex align-items-center mr-md"><img
                                                src="{{ asset('assets/images/click.svg') }}"
                                                class="checkout__systems-image" alt="">
                                            <input type="radio" name="payment_type" value="click">
                                            <span class="radio__checkmark"></span>
                                        </label> --}}
                                        <label class="radio d-flex align-items-center mr-md"><img
                                                src="{{ asset('assets/images/payme.svg') }}"
                                                class="checkout__systems-image" alt="">
                                            <input type="radio" name="payment_type" value="payme">
                                            <span class="radio__checkmark"></span>
                                        </label>
                                        {{-- <label class="radio d-flex align-items-center"><img
                                                src="{{ asset('assets/images/uzum.svg') }}" height="30"
                                                class="checkout__systems-image" alt="">
                                            <input type="radio" name="payment_type" value="uzum">
                                            <span class="radio__checkmark"></span>
                                        </label> --}}
                                    </div>
                                </div>
                                <h2 class="title-lg">@lang('main.order_feedback')</h2>
                                <textarea name="comment" cols="30" rows="5" class="input"
                                    placeholder="@lang('main.order_feedback_desc')">{{ old('comment') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="checkout__info box-shadow--silver rounded" id="sticker">
                            <h2 class="title-lg font-roboto">@lang('main.acc_summ')</h2>
                            {{-- <div class="d-flex align-items-center justify-content-between mb-sm b-b pb-sm">
                                <p class="text-silver text">@lang('main.pay_method'):</p>
                                <p class="js-payment-type-text"></p>
                            </div> --}}
                            <div class="d-flex align-items-center justify-content-between mb-sm b-b pb-sm">
                                <p class="text-silver text">@lang('main.type_delivery'):</p>
                                <p class="js-delivery-type-text"></p>
                            </div>
                            {{-- <div class="d-flex align-items-center justify-content-between mb-sm b-b pb-sm">
                                <p class="text-silver text">Доставка:</p>
                                <p>30 000 сум</p>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-sm b-b pb-sm">
                                <p class="text-silver text">Товары с учетом скидки:</p>
                                <p>2 116 700 сум</p>
                            </div> --}}
                            <div class="d-flex align-items-center justify-content-between">
                                <p class="title-lg font-medium">@lang('main.total_pay'):</p>
                                <p class="title-lg font-medium js-total-text">
                                    {{ number_format($cartTotal, 0, ',', ' ') }} @lang('main.summ')</p>
                            </div>
                            <label class="checkbox text-sm mb-sm">@lang('main.offer_info') <a
                                    href="{{ route('page.show', 'publicnaia-oferat') }}" class="text-blue text-xs checkout__info-link">@lang('main.offer_btn')</a>
                                <input type="checkbox" name="check" class="js-check-oferta">
                                <span class="checkmark"></span>
                            </label>
                            <button class="btn text-upper js-send-btn full-width" disabled>@lang('main.go_checkout')</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/jquery.mask.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.sticky.js') }}"></script>
    <script src="{{ mix('frontend/checkout.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            new Checkout({
                checkoutForm: '.js-checkout-form',
                deliveryType: '.js-delivery-type',
                deliveryTypeText: '.js-delivery-type-text',
                deliveryAddress: '.js-delivery-address',
                paymentType: '.js-payment-type',
                paymentTypeText: '.js-payment-type-text',
                paymentTypes: '.js-payment-types',
                checkOferta: '.js-check-oferta',
                sendBtn: '.js-send-btn',
                preloader: '.js-checkout-preloader'
            })
        })
        if ($(window).width() > 992) {
            $("#sticker").sticky({
                topSpacing: 20,
                bottomSpacing: 400
            });
        }
    </script>
@endsection
