@extends('layouts.frontend')

@section('content')
    <div id="app">
        <section class="cabinet py-layout-xs">
            {{-- breadcrumb --}}
            <div class="container">
                <ul class="breadcrumb">
                    <li class="breadcrumb__item">
                        <a href="{{ route('home') }}">@lang('main.home')</a>
                    </li>
                    <li class="breadcrumb__item">
                        <a href="{{ route('frontend.cabinet.index') }}">@lang('main.navbar.cabinet')</a>
                    </li>
                </ul>
            </div>
            {{-- endbreadcrumb --}}
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-4">
                        <div class="cabinet__content rounded b-a">
                            <div class="cabinet__user p-sm ml-xs mt-xs">
                                <h1 class="cabinet__user-title">{{ $user->full_name }}</h1>
                                <p class="cabinet__user-id">ID: {{ $user->id }}</p>
                            </div>
                            <ul class="cabinet__nav">
                                <li class="cabinet__nav-item b-b">
                                    <router-link :to="{ name: 'orders' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <i class="icon-box"></i>
                                        @lang('cabinet.navbar.order')
                                    </router-link>
                                </li>
                                <li class="cabinet__nav-item b-b">
                                    <router-link :to="{ name: 'mycar' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <img src="{{ asset('assets/images/sidebar-car.png') }}" alt=""
                                            height="21px">
                                        @lang('main.my_cars')
                                    </router-link>
                                </li>
                                <li class="cabinet__nav-item b-b">
                                    <router-link :to="{ name: 'profile' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <i class="icon-resume"></i>
                                        @lang('cabinet.navbar.profile')
                                    </router-link>
                                </li>
                                {{-- <li class="cabinet__nav-item b-b">								
                                <router-link :to="{ name: 'address'}" class="cabinet__nav-link"
                                    exact-active-class="active">
                                    <i class="icon-location-point"></i>
                                    @lang('cabinet.navbar.address')
                                </router-link>								
							</li> --}}
                                <li class="cabinet__nav-item">
                                    <router-link :to="{ name: 'notification' }" class="cabinet__nav-link"
                                        exact-active-class="active">
                                        <i class="icon-alarm"></i>
                                        @lang('cabinet.navbar.notification')
                                    </router-link>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-9 col-md-8">
                        <!-- set router view -->
                        <router-view></router-view>
                        <vue-progress-bar></vue-progress-bar>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('scripts')
    <script>
        window.trans = <?php
        $lang_files = File::glob(resource_path('lang/' . App::getLocale() . '/*'));
        $trans = [];
        foreach ($lang_files as $f) {
            $filename = basename($f, '.php');
            $trans[$filename] = trans($filename);
        }
        echo json_encode($trans);
        ?>;
        window.lang = '{{ App::getLocale() }}';
    </script>
    <script src="{{ mix('js/cabinet.js') }}"></script>
@endsection
