@extends('layouts.backend')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card-box">            
            <h4 class="header-title m-t-0 m-b-30">{{ $id == null ? 'Добавить' : 'Редактировать' }}</h4>
            <ul class="nav nav-tabs nav-justified">                
                @foreach(config()->get('app.supported_locales') as $i=>$v)                
                <li class="nav-item">
                    <a href="#{{$v}}" role="tab" data-toggle="tab" style="text-transform: uppercase"
                     aria-controls="{{$v}}" class="nav-link {{ $i==0 ? 'active show' : '' }}">
                     {{$v}}
                    </a>
                </li>
                @endforeach
            </ul>                    
            <form action="{{ route('backend.setting.postform', ['id' => $id]) }}" method="POST" enctype="multipart/form-data">
                @csrf   
                
                <div class="tab-content">
                    @foreach(config()->get('app.supported_locales') as $i=>$v)
                    <div class="tab-pane fade @if($i==0) show active @endif" id="{{$v}}" role="tabpanel">
                        <div class="form-group">                            
                            <label for="meta_description">Значение ({{$v}})</label>
                            <input type="text" name="value_{{$v}}" value="{{ empty($setting) ? null : $setting->{'value_'.$v} }}" class="form-control">
                        </div>
                    </div>                        
                    @endforeach
                </div>
                
                <hr>
                
                <!--<div class="form-group">                            
                    <label for="atribute">Параметр</label>
                    <input type="text" name="atribute" value="{{ empty($setting) ? null : $setting->atribute }}" class="form-control">
                </div>-->
                
                <div class="form-group">                            
                    <label for="value_one">Значение</label>
                    <input type="text" name="value_one" value="{{ empty($setting) ? null : $setting->value_one }}" class="form-control">
                </div>
                

                <div class="form-group text-right m-b-0">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        Сохранить
                    </button>
                    <a href="{{ route('backend.setting.index') }}" class="btn btn-secondary waves-effect waves-light m-l-5">
                        Отменить
                    </a>
                </div>
            </form>
        </div>
    </div><!-- end col -->
</div>
@endsection