@extends('layouts.backend')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <div class="row m-0">
                <div class="col-sm-6">
                    <h4 class="m-t-0 m-b-30 header-title">Регионы</h4>            
                </div>
                <div class="col-sm-6">
                    <button type="button" class="btn btn-success m-b-sm btn-add pull-right" data-toggle="modal" data-target="#formModal">
                        <i class="fa fa-plus"></i> Добавить
                    </button>
                </div>
            </div>
            <div class="row m-0">
                <div class="col-sm-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            @foreach($breadcrumbs['list'] as $key=>$name)
                                @if($breadcrumbs['last_key'] == $key)
                                    <li class="breadcrumb-item active">{{ $name }}</li>
                                @else
                                    @if($key == '')
                                        <li class="breadcrumb-item">
                                            <a href="{{ route('backend.region.index') }}">{{ $name }}</a>
                                    </li>
                                    @else
                                        <li class="breadcrumb-item">
                                            <a href="{{ route('backend.region.index', ['parent_id' => $key]) }}">{{ $name }}</a>
                                        </li>
                                    @endif
                                @endif
                            @endforeach
                        </ol>
                    </nav>
                </div>
            </div>                                 
            <table id="datatable" class="table table-bordered table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                <thead>
                    <tr>                        
                        <th>ID</th>                        
                        <th>Название</th>                        
                        <th style="width:110px;"></th>                   
                    </tr>
                </thead>
                <tbody>                   
                </tbody>
            </table>
        </div>
    </div>
</div> <!-- end row -->
<!-- Form Modal -->
<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel">Добавить</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs nav-justified">                
                    @foreach(config()->get('app.supported_locales') as $i=>$v)                
                    <li class="nav-item">
                        <a href="#{{$v}}" role="tab" data-toggle="tab" style="text-transform: uppercase"
                            aria-controls="{{$v}}" class="nav-link {{ $i==0 ? 'active show' : '' }}">
                            {{$v}}
                        </a>
                    </li>
                    @endforeach      
                </ul>               
                <form action="" id="form" enctype="multipart/form-data">                    
                    <input type="hidden" name="id" value="null">
                    <input type="hidden" name="parent_id" value="{{ request()->input('parent_id') }}" class="js-non-editable">
                    <div class="tab-content">
                        @foreach(config()->get('app.supported_locales') as $i=>$v)
                            <div class="tab-pane fade @if($i==0) show active @endif" id="{{$v}}" role="tabpanel">
                                <div class="form-group">                        
                                    <label for="title">Название ({{$v}})</label>
                                    <input type="text" name="name_{{$v}}" class="form-control">                        
                                </div>
                            </div>
                        @endforeach
                    </div>                    
                    <div class="js-progress-bar d-none text-left">
                        <div class="progress progress-lg">
                            <div class="progress-bar progress-bar-info"></div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Отменить</button>
                <button type="submit" class="btn btn-success ajax-form">Сохранить</button>
            </div>
        </div>
    </div>
</div>
@include('partials.ajax-delete')
@endsection
@section('styles')
<link href="{{ asset('backend/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css"/>
<link href="{{ asset('backend/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css"/>
@endsection
@section('scripts')
<script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('backend/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('backend/js/crud.js') }}"></script>
<script>         
    var crud = new Crud({
        filter: true,
        form: {
            url: "{{ route('backend.region.form') }}",
        },
        list: {
            url: "{{ route('backend.region.data') }}",
            @if(request()->has("parent_id"))
            data: {
                'parent_id': {{ request()->input('parent_id') }}
            },
            @endif
            datatable: {            
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'name_ru', name: 'name_ru'}                    
                ],
                columnDefs: [                   
                    {
                        targets: 2,
                        data: null,
                        searchable:false, 
                        render: function (row, type, val, meta) {                                                        
                            return '<a href="{{ route("backend.region.index") }}?parent_id=' + val.id + '" class="btn btn-success"> <i class="fa fa-arrow-right"></i></a> '
                            + crud.makeButton(val, 'btn-primary btn-edit', '<i class="fa fa-pencil"></i>', [
                                    ['toggle', 'modal'],
                                    ['target', '#formModal']
                                ]) +
                                crud.makeButton(val, 'btn-danger', '<i class="fa fa-trash"></i>', [
                                    ['toggle', 'modal'],
                                    ['target', '#removeModal']
                                ]);
                        }                        
                    }
                ]
            }
        },

        remove: {
            url: "{{ route('backend.region.delete') }}",
        }
    });
</script>
@endsection