@extends('layouts.backend')

@section('styles')
    <link rel="stylesheet" href="{{ asset('backend/css/select2.min.css') }}">
    <style>
        .box {
            padding: 18px;
            border: 1px solid rgba(0, 0, 0, .125);
            background-color: #fff;
            position: relative;
            overflow: hidden;
            margin-bottom: 30px;
        }

        .product-img {
            position: relative;
            display: inline-block;
        }

        .product-img:hover {
            border: 1px solid #0000cc;
        }

        .product-remove {
            right: 0;
            padding: 3px 9px;
            font-size: 12px;

        }

        .product-remove,
        .product-label {
            position: absolute;
            top: 0;
        }

        .product-label {
            left: 0;
        }

        .product-remove {
            right: 0;
        }

        body.dragging,
        body.dragging * {
            cursor: move !important;
        }

        .dragged {
            position: absolute;
            opacity: 0.5;
            z-index: 2000;
        }
    </style>
@stop


@section('content')


    <form action="{{ route('backend.product.postform', ['id' => $id]) }}" method="POST" enctype="multipart/form-data">

        @csrf
        <div class="card">
            <div class="card-body">
                <!-- Title and language start  -->
                <div class="row">
                    <div class="col-sm-10 big-input">
                        <div class="tab-content">
                            @foreach (config()->get('app.supported_locales') as $i => $v)
                                <div role="tabpanel" class="tab-pane js-lang js-lang-{{ $v }}">
                                    <div class="form-group mb-0 {{ $errors->has('name_' . $v) ? 'has-error' : '' }}">
                                        <input type="text" name="name_{{ $v }}"
                                            value="{{ empty($product) ? null : $product->{'name_' . $v} }}"
                                            class="form-control" placeholder="Введите название продукта">
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <select class="form-control js-lang-selector">
                                @foreach (config()->get('app.supported_locales') as $lang)
                                    <option value="{{ $lang }}">{{ strtoupper($lang) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <!-- Title and language end  -->
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a href="#basic" aria-controls="basic" role="tab" data-toggle="tab"
                            class="nav-link active show">Основной</a>
                    </li>
                    <li class="nav-item">
                        <a href="#seo" aria-controls="seo" role="tab" data-toggle="tab" class="nav-link">SEO</a>
                    </li>
                    <li class="nav-item">
                        <a href="#payme_setting" aria-controls="payme_setting" role="tab" data-toggle="tab" class="nav-link">Настройка Payme</a>
                    </li>
                </ul>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="tab-content">
                            <!-- Basic start -->
                            <div role="tabpanel" class="tab-pane fade show active" id="basic">
                                <div class="row">
                                    <div class="col-sm-8">
                                        <div class="form-group">
                                            <label for="image">Изображения (600x600)px</label>
                                            <input type="file" name="images[]" class="form-control" multiple>
                                        </div>
                                        
                                        <div class="tab-content">
                                            @if (!empty($product) && Upload::hasFiles('product', $product->id))
                                                <div class="box">
                                                    @foreach (Upload::getFiles('product', $product->id) as $key => $file)
                                                        <a href="#" class="img-thumbnail product-img"
                                                            data-key="{{ $key }}">
                                                            <img src="{!! asset($file) !!}?cacheimg={{ rand(11111, 99999) }}"
                                                                class="js-product-img" height="100">
                                                            <button type="button"
                                                                class="btn btn-xs btn-danger product-remove js-product-remove"><i
                                                                    class="fa fa-trash" tabindex="-1"></i></button>
                                                        </a>
                                                    @endforeach
                                                </div>
                                            @endif
                                            <div class="form-group">
                                                <label for="image">Видео (600x600)px</label>
                                                <input type="file" name="video" class="form-control">
                                                @error('video')
                                                    <div class="error">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            @if (!empty($product) && Upload::hasFiles('product_video', $product->id))
                                            <video controls="" muted height="150">
                                                <source src="{{ Upload::getFile('product_video', $product->id) }}">
                                            </video>
                                            @endif
                                            <input type="hidden" name="main_image" class="js-main-image">
                                            <input type="hidden" name="removed_images" class="js-removed-images">
                                            @foreach (config()->get('app.supported_locales') as $i => $v)
                                                <div role="tabpanel" class="tab-pane js-lang js-lang-{{ $v }}">

                                                    <div
                                                        class="form-group {{ $errors->has('short_description_' . $v) ? 'has-error' : '' }}">
                                                        <label for="short_description">Краткий текст</label>
                                                        <textarea name="short_description_{{ $v }}" cols="4" rows="3" class="form-control">{{ empty($product) ? null : $product->{'short_description_' . $v} }}</textarea>
                                                    </div>

                                                    <div
                                                        class="form-group {{ $errors->has('description_' . $v) ? 'has-error' : '' }}">
                                                        <label for="description">Описание</label>
                                                        <input type="text" name="description_{{ $v }}"
                                                            value="{{ empty($product) ? null : $product->{'description_' . $v} }}"
                                                            class="js-selector">
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="category">Категории</label><br />
                                            <div class="box mb-0"
                                                style="border-color: {{ $errors->has('category') ? '#ff5b5b' : '' }}">
                                                <small class="pull-right">Основной</small>
                                                <hr>
                                                @foreach ($categories as $category)
                                                    {!! App\Library\Helper::renderNode(
                                                        $category,
                                                        'category',
                                                        empty($product)
                                                            ? []
                                                            : $product->categories()->pluck('id')->toArray(),
                                                        empty($product) ? 0 : $product->category_id,
                                                    ) !!}
                                                @endforeach
                                            </div>
                                            @if ($errors->has('category'))
                                                <span class="help-block" style="color: #ff5b5b; margin-top: 5px">
                                                    Выберите категорию
                                                </span>
                                            @endif
                                        </div>
                                        <div class="form-group">
                                            <label for="manufacturer">Производитель</label>
                                            <select name="manufacturers[]" class="form-control js-cars" multiple>
                                                @if (!empty($product))
                                                    @foreach ($manufacturers as $manufacturer)
                                                        <option value="{{ $manufacturer->id }}"
                                                            {{ $product->manufacturers->contains($manufacturer->id) ? 'selected' : '' }}>
                                                            {{ $manufacturer->name }}</option>
                                                    @endforeach
                                                @else
                                                    @foreach ($manufacturers as $manufacturer)
                                                        <option value="{{ $manufacturer->id }}">{{ $manufacturer->name }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="car">Автомобили</label>
                                            <select name="cars[]" class="form-control js-cars" multiple>
                                                @if (!empty($product))
                                                    @foreach ($cars as $car)
                                                        <option value="{{ $car->id }}"
                                                            {{ $product->cars->contains($car->id) ? 'selected' : '' }}>
                                                            {{ $car->name }}</option>
                                                    @endforeach
                                                @else
                                                    @foreach ($cars as $car)
                                                        <option value="{{ $car->id }}">{{ $car->name }}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                        {{-- <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="checkbox-second checkbox-second--textless">
                                                        <input type="checkbox" name="to_1" value="1"
                                                            {{ !empty($product->to_1) ? 'checked' : '' }}>
                                                        <span></span>
                                                    </label>
                                                    ТО 1
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="checkbox-second checkbox-second--textless">
                                                        <input type="checkbox" name="to_2" value="1"
                                                            {{ !empty($product->to_2) ? 'checked' : '' }}>
                                                        <span></span>
                                                    </label>
                                                    ТО 2
                                                </div>
                                            </div>
                                        </div> --}}
                                        <div class="row">
                                            <div class="col-md-9">
                                                <div class="form-group {{ $errors->has('price') ? 'has-error' : '' }}">
                                                    <label for="price">Цена</label>
                                                    <input type="text" name="price"
                                                        value="{{ empty($product) ? null : $product->price }}"
                                                        class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group {{ $errors->has('discount') ? 'has-error' : '' }}">
                                                    <label for="discount">Скидка %</label>
                                                    <input type="text" name="discount"
                                                        value="{{ empty($product) ? null : $product->discount }}"
                                                        class="form-control">
                                                </div>
                                            </div>											
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Basic end -->

                            <!-- SEO fields start -->
                            <div role="tabpanel" class="tab-pane fade" id="seo">
                                <div class="tab-content">
                                    @foreach (config()->get('app.supported_locales') as $i => $v)
                                        <div role="tabpanel" class="tab-pane js-lang js-lang-{{ $v }}">

                                            <div class="form-group">
                                                <label for="meta_description">Meta - Описание</label>
                                                <textarea name="meta_description_{{ $v }}" rows="2" class="form-control">{{ empty($product) ? null : $product->{'meta_description_' . $v} }}</textarea>
                                            </div>

                                            <div class="form-group">
                                                <label for="meta_title">Meta - Заголовок</label>
                                                <input type="text" name="meta_title_{{ $v }}"
                                                    value="{{ empty($product) ? null : $product->{'meta_title_' . $v} }}"
                                                    class="form-control">
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <!-- SEO fields end -->
							{{-- Payment setting start --}}
							<div role="tabpanel" class="tab-pane fade" id="payme_setting">
								<div class="col-md-12">
									<div class="form-group {{ $errors->has('payme_setting_id') ? 'has-error' : '' }}">
										<label for="payme_setting_id">Настройка Payme</label>
										<select name="payme_setting_id" class="form-control">
										<option value="" selected disabled>Выберите</option>
										@foreach($payme_settings as $payme_setting_key=>$payme_setting)
										<option value="{{ $payme_setting_key }}" {{ !empty($product) && $product->payme_setting_id == $payme_setting_key ? 'selected' : '' }}>{{ $payme_setting }}</option>
										@endforeach
										</select>
									</div>
								</div>
                            </div>
							{{-- Payment setting end --}}
                        </div>
                        <div class="form-group m-b-0">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Сохранить
                            </button>
                            <a href="{{ route('backend.product.index') }}"
                                class="btn btn-secondary waves-effect waves-light m-l-5">
                                Отменить
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection

@section('scripts')
    <script src="{{ asset('backend/js/product.form.js') }}"></script>
    <script>
        $('.js-cars').select2();
        ProductForm.init();
    </script>
@endsection
