@extends('layouts.backend')

@section('content')
    <div class="row">
        <div class="col-xl-4 col-md-6">
            <a href="{{ route('backend.order.index') }}">
                <div class="card-box widget-user">
                    <div class="card-box-wrap">
                        <div class="card-box-circle bg-warning">
                            <i class="fa fa-cart-plus font-30"></i>
                        </div>
                        <div class="card-box-info">
                            <p class="text-muted m-b-5 font-15 text-center">Заказы</p>
                            <h2 class="m-0 text-center">{{ $count['product'] }}</h2>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-6">
            <a href="{{ route('backend.product.index') }}">
                <div class="card-box widget-user">
                    <div class="card-box-wrap">
                        <div class="card-box-circle bg-warning">
                            <i class="fa fa-product-hunt font-30"></i>
                        </div>
                        <div class="card-box-info">
                            <p class="text-muted m-b-5 font-15 text-center">Товары</p>
                            <h2 class="m-0 text-center">{{ $count['product'] }} {{ App\Models\NewProduct::count() }}</h2>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <!-- end col -->
        <div class="col-xl-4 col-md-6">
            <a href="{{ route('backend.user.index') }}">
                <div class="card-box widget-user">
                    <div class="card-box-wrap">
                        <div class="card-box-circle bg-success">
                            <i class="fa fa-user font-30"></i>
                        </div>
                        <div class="card-box-info">
                            <p class="text-muted m-b-5 font-15 text-center">Пользователи</p>
                            <h2 class="m-0 text-center">{{ $count['user'] }}</h2>
                        </div>
                    </div>
                </div>
            </a>
        </div><!-- end col -->
        <div class="col-xl-4 col-md-6">
            <a href="{{ route('backend.comment.index') }}">
                <div class="card-box widget-user">
                    <div class="card-box-wrap">
                        <div class="card-box-circle bg-primary">
                            <i class="fa fa-comment font-30"></i>
                        </div>
                        <div class="card-box-info">
                            <p class="text-muted m-b-5 font-15 text-center">Отзывы</p>
                            <h2 class="m-0 text-center">{{ $count['comment'] }}</h2>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-6">
            <a href="{{ route('backend.car.index') }}">
                <div class="card-box widget-user">
                    <div class="card-box-wrap">
                        <div class="card-box-circle bg-primary">
                            <i class="fa fa-car font-30"></i>
                        </div>
                        <div class="card-box-info">
                            <p class="text-muted m-b-5 font-15 text-center">Автомобили</p>
                            <h2 class="m-0 text-center">{{ $count['car'] }}</h2>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-xl-4 col-md-6">
            <a href="{{ route('backend.manufacturer.index') }}">
                <div class="card-box widget-user">
                    <div class="card-box-wrap">
                        <div class="card-box-circle bg-primary">
                            <i class="fa fa-industry font-30"></i>
                        </div>
                        <div class="card-box-info">
                            <p class="text-muted m-b-5 font-15 text-center">Производители</p>
                            <h2 class="m-0 text-center">{{ $count['manufacturer'] }}</h2>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <!-- end col -->
    </div>

    <div class="row">
        <div class="col-sm-4">
            <div class="card-box">
                <p class="text-muted m-b-5 font-15 text-center">Бухгалтерия</p>
                <canvas class="js-chart-pie" width="400"></canvas>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card-box">
                <p class="text-muted m-b-5 font-15 text-center">Заказы по статусам</p>
                <canvas class="js-bar-chart" width="400"></canvas>
            </div>
        </div>
    </div>
    <br>
    {{-- <div class="row">
    <div class="col-sm-6">
        <h4>Какие страницы просматривают пользователи?</h4>
        <div class="table-responsive">
            <table class="table table-hover thead-light dt-responsive">
                <thead>
                    <tr>
                        <th>№</th>
                        <th>Страница</th>
                        <th width="100">Просмотры страниц</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($most_visited_pages as $key => $visited_page)
                    <tr>
                        <td>
                            {{ $key+1 }}
                        </td>
                        <td>
                            {{ $visited_page['url'] }}
                        </td>
                        <td>
                            {{ $visited_page['pageViews'] }}
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="col-sm-6">
        <h4>Источник трафика</h4>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>№</th>
                        <th>Источник или канал</th>
                        <th width="100">Просмотры страниц</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($top_referrers as $key => $ref)
                    <tr>
                        <td>
                            {{ $key+1 }}
                        </td>
                        <td>
                            {{ $ref['url'] }}
                        </td>
                        <td>
                            {{ $ref['pageViews'] }}
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div> --}}
@endsection
@section('scripts')
    <script src="{{ asset('backend/js/chart.min.js') }}"></script>
    <script src="{{ asset('backend/js/chart.bundle.min.js') }}"></script>
    <script src="{{ asset('backend/js/dashboard.js?v=1.1') }}"></script>
    <script>
        Dashboard.init({
            doughnutChart: {
                selector: ".js-chart-pie",
                labels: "{{ $orders['labels'] }}",
                data: "{{ $orders['data'] }}"
            },
            barChart: {
                selector: ".js-bar-chart",
                labels: "{{ $order_statuses['labels'] }}",
                data: "{{ $order_statuses['data'] }}"
            },
        });
    </script>
@endsection
