@extends('layouts.backend')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card-box">
				<div class="row">
					<div class="col-md-6">
						<h4 class="header-title m-t-0 m-b-30">Заказ №:{{ $order->id }}</h4>
					</div>
					<div class="col-md-6 text-right">
						<a href="{{ route('backend.order.index') }}" class="btn btn-primary">Назад</a>
					</div>				
				</div>                
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-group pr-3">
                            <li class="list-group-item"><span class="font-bold">Ф.И.Ш:</span> <span
                                    class="ml-2">{{ $order->full_name }}</span></li>
                            <li class="list-group-item"><span class="font-bold">Номер телефона:</span> <span
                                    class="ml-2">{{ $order->phone_number }}</span></li>
                            <li class="list-group-item"><span class="font-bold">Дополнительный номер телефона:</span> <span
                                    class="ml-2">{{ $order->additional_number }}</span></li>
                            @if ($order->delivery_type == 'express')
                                <li class="list-group-item"><span class="font-bold">Адрес:</span> <span
                                        class="ml-2">{{ $order->address_format }}</span></li>
                            @endif
                            <li class="list-group-item"><span class="font-bold">Комментарий:</span> <span
                                    class="ml-2">{{ $order->comment }}</span></li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="list-group pl-3">
                            <li class="list-group-item"><span class="font-bold">Время заказа:</span> <span
                                    class="ml-2">{{ $order->created_at_format }}</span></li>
                            <li class="list-group-item"><span class="font-bold">Вид доставки:</span> <span
                                    class="ml-2">{{ $order->delivery_type_format }}</span></li>
                            <li class="list-group-item"><span class="font-bold">Способы оплаты:</span> <span
                                    class="ml-2">{{ $order->payment_type_format }} 
									@if ($detail)
									<button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#formModal">
									<i class="fa fa-cog"></i> Детали</button>
									@endif
									</span></li>
                            <li class="list-group-item"><span class="font-bold">Общая стоимость:</span> <span
                                    class="ml-2">{{ $order->total_cost_format }} сум</span></li>
                            <li class="list-group-item"><span class="font-bold">Статус:</span> <span
                                    class="ml-2">{{ $order->status_format }}</span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
	@if ($detail)
	<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title" id="myModalLabel">Детали платежа</h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
				</div>
				<div class="modal-body">
					<ul class="list-group pl-3">
						<li class="list-group-item"><span class="font-bold">Общая стоимость:</span> <span class="ml-2">{{ number_format($detail->amount, 0, ',', ' ') }} сум</span></li>						
						<li class="list-group-item"><span class="font-bold">ID транзакции:</span> <span class="ml-2">{{ $detail->system_transaction_id ?? '' }}</span></li>
						<li class="list-group-item"><span class="font-bold">Статус:</span> <span class="ml-2">{{ $detail->status ?? '' }}</span></li>
						<li class="list-group-item"><span class="font-bold">Время создания в системе Paycom:</span> <span class="ml-2">{{ $detail->paycom_system_time_created }}</span></li>
						<li class="list-group-item"><span class="font-bold">Время создания в нашей системе:</span> <span class="ml-2">{{ $detail->paycom_time_created }}</span></li>
						<li class="list-group-item"><span class="font-bold">Время подтверждения:</span> <span class="ml-2">{{ $detail->paycom_time_preform }}</span></li>
						@if (in_array($detail->state, ['canceled_after_commit', 'canceled']) && $detail->paycom_cancel_reason != '-')
						<li class="list-group-item"><span class="font-bold">Время отмены:</span> <span class="ml-2">{{ $detail->paycom_time_canceled }}</span></li>
						<li class="list-group-item"><span class="font-bold">Причина отказа:</span> <span class="ml-2">{{ $detail->cancel_reason }}</span></li>
						@endif
					</ul>						
				</div>            
			</div>
		</div>
	</div>
	@endif

    <div class="card-box">
        <h4 class="header-title m-t-0 m-b-30">Продукты</h4>
        <table class="table">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Изображения</th>
                    <th scope="col">Название</th>
                    <th scope="col">Цена</th>
                    <th scope="col">Скидка %</th>
                    <th scope="col">Цена со скидкой</th>
                    <th scope="col">Количество</th>
                    <th scope="col">Общая стоимость</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($order->products as $key => $product)
                    <tr>
                        <th scope="row">{{ $key + 1 }}</th>
                        <td>
                            @if (Upload::hasFile('product', $product->product?->id))
                                <img src="{{ $product->product->image }}" alt="" height="70" width="70">
                            @endif
                        </td>
                        <td>
                            {{ $product?->product?->name ?? 'Удалено' }}
                        </td>
                        <td>
                            {{ $product->original_price_format }} сум
                        </td>
                        <td>
                            {{ $product->discount }}
                        </td>
                        <td>
                            {{ $product->price_format }} сум
                        </td>
                        <td>{{ $product->quantity }}</td>
                        <td>{{ $product->total_cost_format }} сум</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="card-box">
        <div class="row">
            <div class="col-md-8">
                <h4 class="header-title m-t-0 m-b-30">История заказа</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Пользователь</th>
                            <th scope="col">Статус</th>
                            <th scope="col">Дата и время изменения</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($order->histories()->latest()->get() as $key => $history)
                            <tr>
                                <th scope="row">{{ $key + 1 }}</th>
                                <td>{{ $history->user->full_name ?? $history->order->full_name }}</td>
                                <td>{{ $history->status_format }}</td>
                                <td>{{ $history->created_at_format }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="col-md-4">
                <h4 class="header-title m-t-0 m-b-30">Изменить статус</h4>
                <form action="{{ route('backend.order.change-status') }}" method="POST">
                    <input type="hidden" name="order_id" value="{{ $order->id }}">
                    @csrf
                    <div class="form-group">
                        <label for="manufacturer">Статус</label>
                        <select name="status" class="form-control" {{ !$can_change_status ? 'disabled' : '' }}>
                            @foreach (__('cabinet.order.statuses') as $status_key => $status)
                                <option {{ $status_key == 'pending' ? 'disabled' : '' }} value="{{ $status_key }}"
                                    {{ $order->status == $status_key ? 'selected' : '' }}>
                                    {{ $status }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                        <button type="submit" class="btn btn-primary waves-effect waves-light">
                            Сохранить
                        </button>
                   
                </form>
            </div>
        </div>
    </div>
@endsection

@section('styles')
    <style>
        .list-group-item {
            border-color: #ccc;
        }
    </style>
@endsection
