@extends('layouts.backend')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card-box table-responsive">
                <div class="row m-0">
                    <div class="col-sm-6">
                        <h4 class="m-t-0 m-b-30 header-title">Заказы</h4>
                    </div>
                </div>
                <table id="datatable" class="table table-bordered table-bordered dt-responsive nowrap" cellspacing="0"
                    width="100%">
                    <thead>
						<tr>
							<th><input type="text" class="form-control input-sm"></th>
							<th><input type="text" class="form-control input-sm"></th>
							<th><input type="text" class="form-control input-sm"></th>
							<th><input type="text" class="form-control input-sm"></th>
							<th>
								<select name="payment_type" class="form-control">
									<option value="" selected>Все</option>
									@foreach ($payment_types as $p_key=>$payment_type) 
									<option value="{{ $p_key }}">{{ $payment_type }}</option>
									@endforeach
								</select>
							</th>
							<th>
								<select name="status" class="form-control">
									<option value="" selected>Все</option>
									@foreach ($statuses as $key=>$status) 
									<option value="{{ $key }}">{{ $status }}</option>
									@endforeach
								</select>
							</th>
							<th></th>
						</tr>
                        <tr>
                            <th>ID</th>
                            <th>Заказчик</th>
                            <th>Номер телефона</th>
                            <th>Общая стоимость (сум)</th>
                            <th>Вид оплаты</th>
                            <th>Статус</th>
                            <th style="width:50px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div> <!-- end row -->
    @include('partials.ajax-delete')
@endsection
@section('styles')
    <link href="{{ asset('backend/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('backend/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('scripts')
    <script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('backend/js/crud.js') }}"></script>
    <script>
        var is_waiting = false;
        var crud = new Crud({
            filter: true,
            list: {
                url: "{{ route('backend.order.data') }}",
                datatable: {
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'full_name',
                            name: 'full_name'
                        },
                        {
                            data: 'phone_number',
                            name: 'phone_number'
                        },
                        {
                            data: 'total_cost_format',
                            name: 'total_cost'
                        },
                        {
                            data: 'payment_type_format',
                            name: 'payment_type'
                        },
                        {
                            data: 'status_label_format',
                            name: 'status'
                        },
                    ],
                    columnDefs: [{
                        targets: 6,
                        data: null,
                        searchable: false,
                        render: function(row, type, val, meta) {
                            return '<a href="order/view' + '/' + val.id +
                                '" class="btn btn-primary"><i class="fa fa-eye"></i></a> ';
                        }
                    }, ]
                }
            },

            remove: {
                url: "{{ route('backend.order.delete') }}",
            }
        });
    </script>
@endsection
