@extends('layouts.backend')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <div class="row m-0">
                <div class="col-sm-6">
                    <h4 class="m-t-0 m-b-30 header-title">Производители </h4>            
                </div>
                <div class="col-sm-6">
                    <button type="button" class="btn btn-success m-b-sm btn-add pull-right" data-toggle="modal" data-target="#formModal">
                        <i class="fa fa-plus"></i> Добавить
                    </button>
                </div>
            </div>                                   
            <table id="datatable" class="table table-bordered table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                <thead>
                    <tr>                        
                        <th>ID</th>      
                        <th>Изображение</th>                   
                        <th>Название</th>
                        <th>Автомобили</th>                      
                        <th style="width:110px;"></th>                   
                    </tr>
                </thead>
                <tbody>                   
                </tbody>
            </table>
        </div>
    </div>
</div> <!-- end row -->
<!-- Form Modal -->
<div class="modal fade" id="formModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel">Добавить</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body">                      
                <form action="" id="form" enctype="multipart/form-data">                    
                    <input type="hidden" name="id" value="null">                     
                    <div class="form-group">                        
                        <label for="title">Название</label>
                        <input type="text" name="name" class="form-control">                        
                    </div>
                    <div class="form-group">                        
                        <label for="title">Изображение</label>
                        <input type="file" name="image" class="form-control">                        
                    </div>
                    <div class="form-group">
                        <label for="cars">Автомобили</label>
                        <select name="cars[]" class="form-control select2 car" multiple>                            
                            <option value="null" selected>Выберите</option>
                            @forelse ($cars as $car)
                                <option value="{{ $car->id }}">{{ $car->name }}</option>
                            @empty
                                <option value="null" disabled>Пожалуйста добавьте автомобил в разделе "Автомобили"</option>
                            @endforelse
                        </select>
                    </div>                                                                                   
                    <div class="js-progress-bar d-none text-left">
                        <div class="progress progress-lg">
                            <div class="progress-bar progress-bar-info"></div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Отменить</button>
                <button type="submit" class="btn btn-success ajax-form">Сохранить</button>
            </div>
        </div>
    </div>
</div>
@include('partials.ajax-delete')
@endsection
@section('styles')
<link href="{{ asset('backend/plugins/datatables/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css"/>
<link href="{{ asset('backend/plugins/datatables/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css"/>
@endsection
@section('scripts')
<script src="{{ asset('backend/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('backend/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('backend/js/crud.js') }}"></script>
<script>         
    var crud = new Crud({
        filter: true,
        form: {
            url: "{{ route('backend.manufacturer.form') }}",
        },
        list: {
            url: "{{ route('backend.manufacturer.data') }}",            
            datatable: {            
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'image', name: 'image'},
                    {data: 'name', name: 'name'},
                    {data: 'display_cars', name: 'display_cars'}                   
                ],
                columnDefs: [                   
                    {
                        targets: 4,
                        data: null,
                        searchable:false, 
                        render: function (row, type, val, meta) {                                                        
                            return crud.makeButton(val, 'btn-primary btn-edit', '<i class="fa fa-pencil"></i>', [
                                    ['toggle', 'modal'],
                                    ['target', '#formModal']
                                ]) +
                                (!val.exist ? crud.makeButton(val, 'btn-danger', '<i class="fa fa-trash"></i>', [
                                    ['toggle', 'modal'],
                                    ['target', '#removeModal']
                                ]) : '<button class="btn btn-danger" disabled><i class="fa fa-trash"></i></button>');
                        }                        
                    },
                    {
                        targets: 1,
                        data: null,
                        searchable:false, 
                        render: function (row, type, val, meta) {
                            if(val.image) {
                                return '<img src="'+ val.image +'" style="width:50px" class="img-thumbnail">';                                
                            } else {
                                return '';
                            }
                        }
                    }, 
                ]
            }
        },

        remove: {
            url: "{{ route('backend.manufacturer.delete') }}",
        }
    });
    
    $(document).on('click', '.btn-edit', function() {
        var data = crud.datatable.row($(this).closest('tr')).data();
        var ids = data.cars.split(',');
        $('.car').val(ids).select2();
    });
</script>
@endsection