@extends('layouts.backend')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card-box">            
            <h4 class="header-title m-t-0 m-b-30">{{ $id == null ? 'Добавить' : 'Редактировать' }}</h4>
            <ul class="nav nav-tabs nav-justified">                
                @foreach(config()->get('app.supported_locales') as $i=>$v)                
                <li class="nav-item">
                    <a href="#{{$v}}" role="tab" data-toggle="tab" style="text-transform: uppercase"
                     aria-controls="{{$v}}" class="nav-link {{ $i==0 ? 'active show' : '' }}">
                     {{$v}}
                    </a>
                </li>
                @endforeach
            </ul>                    
            <form action="{{ route('backend.blog.postform', ['id' => $id]) }}" method="POST" enctype="multipart/form-data">
                @csrf                
                <div class="tab-content">
                    @foreach(config()->get('app.supported_locales') as $i=>$v)
                    <div class="tab-pane fade @if($i==0) show active @endif" id="{{$v}}" role="tabpanel">                                             
                        <div class="form-group">
                            <label for="title">Заголовок ({{$v}})*</label>
                            <input type="text" name="title_{{$v}}" value="{{ empty($blog) ? null : $blog->{'title_'.$v} }}" class="form-control">
                            @if ($errors->has('title_'.$v))
                                <span class="help-block" style="color: #ff5b5b; margin-top: 5px">
                                    Поле Заголовок обязательно для заполнения
                                </span>
                            @endif
                        </div>
                        {{-- <div class="form-group">
                            <label for="short_text">Краткое описание ({{$v}})*</label>
                            <input type="text" name="short_text_{{$v}}" value="{{ empty($blog) ? null : $blog->{'short_text_'.$v} }}" class="form-control">
                        </div> --}}
                        <div class="form-group">
                            <label for="description">Описание ({{$v}})*</label>
                            <input type="text" name="description_{{$v}}" value="{{ empty($blog) ? null : $blog->{'description_'.$v} }}" class="js-selector">
                            @if ($errors->has('description_'.$v))
                                <span class="help-block" style="color: #ff5b5b; margin-top: 5px">
                                    Поле Описание обязательно для заполнения
                                </span>
                            @endif
                        </div>
                        <div class="form-group">                            
                            <label for="meta_description">META - Описание ({{$v}})*</label>
                            <input type="text" name="meta_description_{{$v}}" value="{{ empty($blog) ? null : $blog->{'meta_description_'.$v} }}" class="form-control">
                        </div>
    
                        <div class="form-group">                            
                            <label for="meta_description">META - Заголовок ({{$v}})*</label>
                            <input type="text" name="meta_keywords_{{$v}}" value="{{ empty($blog) ? null : $blog->{'meta_keywords_'.$v} }}" class="form-control">
                        </div>
                    </div>                        
                    @endforeach
                </div>
                <div class="form-group">
                    <label for="main_image">Главное фото (390x270)px</label>
                    <input type="file" name="main_image" class="form-control">
                </div>

                @if(!empty($blog))
                    <div class="form-group">
                        @if(Upload::hasFile('main_blog', $blog->id))
                            <div class="row">
                                <div class="col-sm-6">
                                    <img style="width:200px" src="{!! Upload::getFile('main_blog', $blog->id) !!}" width="70%">
                                </div>
                            </div>
                        @endif
                    </div>
                @endif
                
                {{-- <div class="form-group">
                    <label for="inner_image">Изображение</label>
                    <input type="file" name="inner_image" class="form-control">
                </div>

                @if(!empty($blog))
                    <div class="form-group">
                        @if(Upload::hasFile('inner_blog', $blog->id))
                            <div class="row">
                                <div class="col-sm-6">
                                    <img style="width:200px" src="{!! Upload::getFile('inner_blog', $blog->id) !!}" width="70%">
                                </div>
                            </div>
                        @endif
                    </div>
                @endif  --}}

                <div class="form-group text-right m-b-0">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        Сохранить
                    </button>
                    <a href="{{ route('backend.blog.index') }}" class="btn btn-secondary waves-effect waves-light m-l-5">
                        Отменить
                    </a>
                </div>
            </form>
        </div>
    </div><!-- end col -->
</div>
@endsection