import axios from 'axios'
import { resolve } from 'path'
export default {
    state: {
        user: {},
				regions:[],
				districts: [],
        errors: [],
        loadingProfile: true
    },

    mutations: {
        setUser(state, user) {
            state.user = user
        },
        setRegions(state, regions) {
            state.regions = regions
        },
        setDistricts(state, districts) {
            state.districts = districts
        },
        setLoading(state, loading) {
            state.loadingProfile = loading
        },
        setErrors(state, error) {
            state.errors = error
        }          
    },
    
    actions: {
        getProfile({commit, dispatch}, payload) {						
					axios.post('/cabinet/profile', payload).then((response) => {
						commit('setUser', response.data.user)
						commit('setRegions', response.data.regions)
						commit('setDistricts', response.data.districts)
						commit('setLoading', false)                						
					})
        },
				getDistricts({commit,dispatch}, payload) {
					axios.post('/cabinet/profile/get/districts', payload).then((response) => {
						commit('setDistricts', response.data)
						commit('setLoading', false)
					})
				},
        updateProfile({commit, dispatch}, payload) {
            commit('setLoading', true)
            return new Promise((resolve, reject) => {
                axios.post('/cabinet/profile/update', payload).then((response) => {
									if (response.data.status) {                    
										dispatch('getProfile')                        
										commit('setLoading', false)
										commit('setErrors', [])
										resolve(response)
									} else {                    
										commit('setErrors', response.data.errors)
										commit('setLoading', false)
									}
                })
            })            
        }
    },
    getters: {
        loadingProfile: state => state.loadingProfile,             
        user: state => state.user,
				regions: state => state.regions,
				districts: state => state.districts,
        errors: state => state.errors                  
    }
}