import axios from 'axios'

export default {
    state: {
        favorites: [],
        loadingFavorite: true        
    },

    mutations: {
        setFavorites(state, favorites) {
            state.favorites = favorites
        },
        setLoading(state, loading) {
            state.loadingFavorite = loading
        }
    },
    
    actions: {
        getFavorites({commit}, payload) {
            axios.post('/cabinet/favorite').then((response) => {                
                commit('setFavorites', response.data)
                commit('setLoading', false)
            })
        },
        removeFavorite({commit, dispatch}, payload) {
            commit('setLoading', true)
            axios.post('/cabinet/favorite/remove/' + payload).then((response) => {                
                if (response.data.deleted) {
                    dispatch('getFavorites')
                    commit('setLoading', false)
                }          
            })
        }
    },
    getters: {
        loadingFavorite: state => state.loadingFavorite,             
        favorites: state => state.favorites            
    }
}