import Vue from 'vue'
import VueRouter from 'vue-router'
import Favorite from './views/favorite/index'
import Order from './views/order/index'
import Profile from './views/profile/index'
import Notification from './views/notification/index'
import MyCar from './views/mycar/index'
import MyCarForm from './views/mycar/form'

Vue.use(VueRouter)

export default new VueRouter({    
    routes: [       
        {
            path: '/orders',
            name: 'orders',
            component: Order                               
        },
        {
            path: '/favorite',
            name: 'favorite',
            component: Favorite                           
        },
        {
            path: '/profile',
            name: 'profile',
            component: Profile           
        },        
        {
            path:'/notifications',
            name: 'notification',
            component: Notification
        }, 
        {
            path:'/mycars',
            name: 'mycar',
            component: MyCar
        },
				{
            path: '/mycars/form',
            name: 'createCar',
            component: MyCarForm                     
        },
        {
            path:'/mycars/form/:id',
            name: 'editCar',
            component: MyCarForm,
						meta: {mode: 'edit'}
        },
        {
            path: '*',            
            redirect: '/orders'
        }      
    ]
})