Main = function (options) {
	var _ = {}
    _.options = options
		_.is_animating = false
		_.is_animating2 = false

		_.initSlick = function() {
			$(".js-main-slider").slick({
				autoplay: true,
				dots: true,
				arrows:false,
				speed: 400
			});

			$(".js-main-banner").slick({
				autoplay: true,
				dots: true,
				arrows:false,
				speed: 400
			});
			
			$(".js-main-car").slick({
				slidesToShow: 4,
				slidesToScroll: 1,
				autoplay: false,
				dots: false,
				arrows:true,
				speed: 500,
				prevArrow: $('.js-arrowl-car'),
				nextArrow: $('.js-arrowr-car'),
				responsive: [
					{
						breakpoint: 992,
						settings: {
							slidesToShow: 3,
							dots: true,
						}
					},
					{
						breakpoint: 768,
						settings: {
							slidesToShow: 2,
							dots: true,
						}
					}
				]
			});
			$(".js-main-product").slick({
				slidesToShow: 5,
				slidesToScroll: 4,
				autoplay: true,
				dots: true,
				arrows: true,
				speed: 1000,
				autoplaySpeed: 4000,
				prevArrow: $('.js-arrowl-product'),
				nextArrow: $('.js-arrowr-product'),
				responsive: [
					{
						breakpoint: 992,
						settings: {
							slidesToShow: 3,
							slidesToScroll: 2,
							arrows:false,
						}
					},
					{
						breakpoint: 768,
						settings: {
							slidesToShow: 2,
							slidesToScroll: 1,
							autoplay: false,
							arrows:false,
						}
					}
				]
			});
			if ($(window).width() < 768) {
				$(".js-main-product-sm").slick({
					slidesToShow: 5,
					slidesToScroll: 4,
					autoplay: true,
					dots: true,
					arrows: false,
					speed: 1000,
					autoplaySpeed: 4000,
					prevArrow: $('.js-arrowl-product'),
					nextArrow: $('.js-arrowr-product'),
					responsive: [
						{
							breakpoint: 992,
							settings: {
								slidesToShow: 3,
								slidesToScroll: 2,
								arrows:false,
							}
						},
						{
							breakpoint: 768,
							settings: {
								slidesToShow: 2,
								slidesToScroll: 1,
								autoplay: false,
								arrows:false,
							}
						}
					]
				});
		 }
		}

		_.initRateyo = function() {
			$(".js-rateyo").rateYo({
				rating: 4,
					starWidth: "18px",
					normalFill: "#D7D9DB",
					ratedFill: "#FAC917"
			});
		}	

		_.initPlugins = function() {
			$(".js-phone-mask").mask("+999(99)999-99-99", {
				autoclear: false
			});

			$(".rateyo").each( function() {
				var _this = $(this),
						rating = $(this).attr("data-rating");
				if (_this.attr("data-comment-rating")) {
						rating = $(this).attr("data-comment-rating");
						_this.rateYo(
								{
										rating: rating,
										fullStar: true,
										ratedFill: '#FAC917',
										starWidth: '20px',
										readOnly: true,
										normalFill: "#D7D9DB",
								}
						);
				} else {
						_this.rateYo(
								{
										rating: rating,
										fullStar: true,
										ratedFill: '#FAC917',
										starWidth: '20px',
										readOnly: true,
										normalFill: "#D7D9DB",
								}
						);
				}
			});			

			if ($(window).width() > 992) {
				$('.menu__nav-item').first().addClass('active');
				$('.menu__content-item').first().show();

					$('.menu__nav-item').mouseenter(function(){
						var tab_id = $(this).attr('data-menu');

						$('.menu__nav-item').removeClass('active');
						$('.menu__content-item').hide();

						$(this).addClass('active');
						$("#"+tab_id).fadeIn(300);
					});
			} else {
				$('.menu__nav-item').click(function(){
						$('.menu__nav-sub').slideUp();

						if($(this).hasClass('active')) {
							$(this).removeClass('active')
							$(this).find('.menu__nav-sub').slideUp();
						} else {
							$('.menu__nav-item').removeClass('active')
							$(this).addClass('active')
							$(this).find('.menu__nav-sub').slideDown();
						}
						
				});
			}

			window.price_format = function(comma, period) {
				comma = comma || ',';
				period = period || '.';
				var split = this.toString().split('.');
				var numeric = split[0];
				var decimal = split.length > 1 ? period + split[1] : '';
				var reg = /(\d+)(\d{3})/;
				while (reg.test(numeric)) {
						numeric = numeric.replace(reg, '$1' + comma + '$2');
				}
				return numeric + decimal;
			}
		}

		_.onClickMinus = function() {
			$(document).on('click', '.js-minus', function() {
				var $input = $(this).parent().find('input');
				var count = parseInt($input.val()) - 1;
				count = count < 1 ? 1 : count;
				$input.val(count);
				$input.change();
				return false;
			})
		}
		_.onClickPlus = function() {
			$(document).on('click', '.js-plus', function() {
				var $input = $(this).parent().find('input');
				$input.val(parseInt($input.val()) + 1);
				$input.change();
				return false;
			})
		}

		_.tabClick = function() {
			$(document).on('click', 'ul.tabs li', function() {
				var tab_id = $(this).attr('data-tab');
				$('ul.tabs li').removeClass('current');
				$('.tab-content').removeClass('current');

				$(this).addClass('current');
				$("#"+tab_id).addClass('current');
			})
		}

		_.loginClick = function() {
			$(document).on('click', '.js-login', function() {
				if (!_.is_animating) {
					_.is_animating = true
					if ($(this).hasClass('header__bottom-activ')) {
						$(this).removeClass('header__bottom-activ')
						$('.js-login-modal').fadeOut(200, function() {
							_.is_animating = false;
						});
					} else {
						$(this).addClass('header__bottom-activ')
						$('.js-login-modal').fadeIn(200, function() {
							_.is_animating = false;
						});
					}
				}
			})
		}

		_.bodyTouchClick = function() {
			$('body').on('touchend click', function(e) {
				if ((e.type == 'touchend' || e.type == 'click') && !$(e.target).closest('.js-login-modal').length && !$(e.target).closest('.js-login').length) 
				{
					$('.js-login').removeClass('header__bottom-activ')									
					$('.js-login-modal').fadeOut(200, function() {
						_.is_animating = false;
					});
				}
			});
		}

		_.onClickMenu = function() {
			$('.js-menu').on('click', function() {
				var hamburger = $('.hamburger');

				if (!_.is_animating2) {
					_.is_animating2 = true
					if (hamburger.hasClass('open')) {
						$('.overlay').removeClass('open');
						$(this).removeClass('text-blue')
						hamburger.removeClass('open')
						$('.menu').removeClass('open');
						$('body') .removeClass('o-hidden')
					} else {
						$('.overlay').addClass('open');
						$(this).addClass('text-blue')
						hamburger.addClass('open')
						$('.menu').addClass('open');
						$('body') .addClass('o-hidden')
					}

					setTimeout(function() {
						_.is_animating2 = false;
					}, 300)
				}
			});
		}

		_.init = function () {
			_.o = options;
			_.initPlugins()
			_.onClickMinus()
			_.tabClick()
			_.loginClick()
			_.bodyTouchClick()
			_.onClickMenu()
			_.initSlick()
			_.initRateyo()
		}
		_.init()
    return _
}