Checkout = function (options) {
	var _ = {}
	_.options = options
	
	_.onChangeDeliveryType = function() {
		$('body').on('change', _.o.deliveryType, function(e) {
			$(_.o.deliveryTypeText).html($(this).data('text'))
			if ($(this).val() == 'express') {
				$(_.o.deliveryAddress).slideDown()
				$('.js-hide-delivery').hide()
				$('.js-hide-delivery input').prop('disabled', true);
			} else {
				$(_.o.deliveryAddress).slideUp()
				$('.js-hide-delivery').show()
				$('.js-hide-delivery input').prop('disabled', false);
			}			
		})
	}

	_.onChangePaymentType = function() {
		$('body').on('change', _.o.paymentType, function(e) {
			$(_.o.paymentTypeText).html($(this).data('text'))
			if ($(this).val() == 'online') {
				$(_.o.paymentTypes).slideDown()
			} else {
				$(_.o.paymentTypes).slideUp()
			}
		})
	}	

	_.onClickOferta = function() {
		$('body').on('click', _.o.checkOferta, function(e) {
			 if ($(this).is(':checked'))
				$(_.o.sendBtn).attr('disabled', false);
			else
				$(_.o.sendBtn).attr('disabled', true);
		})		
	}

	_.onSubmitForm = function() {
			$(document).on('submit', _.o.checkoutForm, function(e) {
				$(_.o.preloader).show()
				e.preventDefault()
				let data = new FormData($(this)[0]),
					url = $(this).attr('action');
				_.sendRequest(url, data)
				e.stopImmediatePropagation()
    		return false
			})			
		}

	_.sendRequest = function(url,data) {
		$.ajax({
				method: "POST",
				url: url,
				data: data,
				contentType: false,
				cache: false,
				processData: false
				}).done(function (data) {
					$(_.o.preloader).hide()
					_.cleanError()
					Toastify({
            text: data.message,
            className: "toastify",
            duration: 8000,
						gravity: "top",
						position: "center",
						close: true,
						newWindow: true,
						style: {
							background: '#0643DA',
						}
						}).showToast()
					setTimeout(function(){location.href=data.url} , 2000);
				}).fail(function (response) {
					$(_.o.preloader).hide()
					if (response.status == 422) {
						var res = JSON.parse(response.responseText)
						_.cleanError()
						$.each(res.errors, function (elem, item) {
								$.each(item, function (i, error) {
									if ($('[name="' + elem + '"]').attr('type') == 'radio') {
										$('[name="' + elem + '"]').closest('.form-group').addClass("form-group--error")
										$('[name="' + elem + '"]').closest('.radio-group-btn').after('<label class="form-group__error">' + error + "</label>")
									} else {
										$('[name="' + elem + '"]').after('<label class="form-group__error">' + error + "</label>").parent().addClass("form-group--error")
									}									
								})									
						})
						$('html, body').animate({
							scrollTop: ($('.form-group--error').offset().top - 300)
						}, 500)
					} else {
						$(_.o.preloader).hide()
						alert("Ошибка!")
					}					
			})
	}

	_.cleanError = function() {
		$(".form-group__error").remove()
		$(".form-group--error").removeClass("form-group--error")
	}

	_.initDefaultValues = function() {
		let checked_delivery = $(_.o.deliveryType + ':checked').data('text')
		$(_.o.deliveryTypeText).html(checked_delivery)
		let checked_payment = $(_.o.paymentType + ':checked').data('text')
		$(_.o.paymentTypeText).html(checked_payment)
		$(".js-phone-mask").mask("+999(99)999-99-99", { autoclear: false });
	}

	_.init = function () {
			_.o = options;
			_.onChangeDeliveryType()
			_.onChangePaymentType()
			_.initDefaultValues()
			_.onClickOferta()
			_.onSubmitForm()
		}
		_.init()
    return _
}