require('./bootstrap.js');
import Vue from 'vue'
import router from './router'
import store from './store'
import sweetalert from 'vue-sweetalert2'
import VueProgressBar from 'vue-progressbar';
import _ from 'lodash'
import Pagination from './components/pagination'

Vue.prototype.trans = (key) => {	
  return _.get(window.trans, key, key)
}

Vue.component('pagination', Pagination);

Vue.use(VueProgressBar, {
  color: 'green',
  failedColor: 'red',
  thickness: '5px',
	transition: {
		speed: '1s', opacity: '1s', termination: 1000
	}
});

Vue.use(sweetalert)

export default new Vue({
    el: '#app',    
    router,
    store: store,
})
