/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 1);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./resources/assets/js/frontend/filter.js":
/*!************************************************!*\
  !*** ./resources/assets/js/frontend/filter.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

Filter = function Filter(options) {
  var _ = {};
  _.options = options;
  _.preloader = $('.js-filter-preloader');
  _.total = $('.js-total-result');
  _.pagination = $('.js-filter-pagination');
  _.filterTags = $('.js-filter-tags');
  _.inputs = [];

  _.sendRequest = function () {
    _.preloader.show();

    _.changeUrl();

    $.ajax({
      method: 'POST',
      url: this.o.url,
      data: _.inputs,
      success: function success(data) {
        _.container.html(data.view);

        _.total.html(data.total);

        _.pagination.html(data.pagination);

        _.preloader.hide();

        _.generateTags();
      }
    });
  };

  _.generateTags = function (filters) {
    var tag,
        checkboxes = $('.js-filter:checked'),
        _reset = $('<button/>', {
      text: _.o.trans.btn_reset,
      "class": 'btn filter__reset js-reset-filter'
    }),
        _this,
        _name;

    _.filterTags.html('');

    checkboxes.each(function (i, item) {
      _this = $(this);
      _name = _this.parent().find('.checkbox__spacer').clone();

      _name.find('span, i').remove();

      tag = $('<button/>', {
        text: _name.html(),
        "class": 'btn btn--green filter__dismisser rounded'
      }).attr('data-id', _this.attr('id')).append('<i class="icon-cancel filter__icon-dismisser js-tag-dismisser"></i>');

      _.filterTags.prepend(tag);
    });

    if (checkboxes.length > 0) {
      _.filterTags.append(_reset);
    }
  };

  _.onTagDismisserClick = function () {
    var _this;

    $('body').on('click', '.js-tag-dismisser', function (e) {
      _this = $(this);
      $('#' + _this.parent().data('id')).prop('checked', false);
      _.inputs = $('.js-filter:input').serializeArray();

      _.sendRequest();
    });
  };

  _.change = function () {
    $('.js-filter').on('change keyup', function () {
      _.inputs = $('.js-filter:input').serializeArray();

      _.sendRequest();
    });
  };

  _.changeUrl = function () {
    // History SEO//
    var url = _.o.current_url + _.friendlyUrl(_.inputs),
        title = $('head title').html();

    history.pushState({
      url: url,
      title: title
    }, title, url);
    document.title = title;
  };

  _.friendlyUrl = function (filters) {
    var cleanArray = [];
    $.each(filters, function (i, item) {
      if (item.value != '' && item.name != 'categories[]') {
        item.value = item.value.replace(/\s+/g, '');
        cleanArray.push(item);
      }
    });

    if (cleanArray.length > 0) {
      return '?' + $.param(cleanArray);
    }

    return '';
  };

  _.onClickSort = function () {
    var _sortInput = $('.js-sort-input');

    $('.js-sort-btn').on('click', function (e) {
      _sortInput.val($(this).data('val'));

      _.inputs = $('.js-filter:input').serializeArray();

      _.sendRequest();
    });
  };

  _.onClickList = function () {
    $('.js-list').on('click', function (e) {
      $('.products__sort-icons').removeClass('active');
      $(this).addClass('active');
      $('.js-blog').removeClass('col-md-4').addClass('col-md-12');
      $('.product-blog').addClass('product-blog--favorite');
    });
  };

  _.onClickGrid = function () {
    $('.js-grid').on('click', function (e) {
      $('.products__sort-icons').removeClass('active');
      $(this).addClass('active');
      $('.js-blog').removeClass('col-md-12').addClass('col-md-4');
      $('.product-blog').removeClass('product-blog--favorite');
    });
  };

  _.initPlugins = function () {
    var index = 1;

    var on = function on(listener, query, fn) {
      document.querySelectorAll(query).forEach(function (item) {
        item.addEventListener(listener, function (el) {
          fn(el);
        });
      });
    };

    $('.js-filter-price').each(function (i, item) {
      $(this).val(price_format.call($(this).val().split(' ').join(''), ' ', '.'));
    });
    $('.js-filter-price').on('keyup', function () {
      $(this).val(price_format.call($(this).val().split(' ').join(''), ' ', '.'));
    });
  };

  _.onClickReset = function () {
    $('body').on('click', '.js-reset-filter', function (e) {
      _.reset();

      _.inputs = $('.js-filter:input').serializeArray();

      _.sendRequest();

      e.preventDefault();
    });
  };

  _.reset = function () {
    $('input[type=checkbox].js-filter').prop('checked', false);
    $('input[type=text].js-filter').val('');
  };

  _.init = function () {
    _.o = options;
    _.container = $(this.o.container);

    _.change();

    _.onClickSort();

    _.onClickReset();

    _.generateTags();

    _.onTagDismisserClick();

    _.initPlugins();

    _.onClickList();

    _.onClickGrid();
  };

  _.init();

  return _;
};

/***/ }),

/***/ 1:
/*!******************************************************!*\
  !*** multi ./resources/assets/js/frontend/filter.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /Users/macbook/domains/simma/resources/assets/js/frontend/filter.js */"./resources/assets/js/frontend/filter.js");


/***/ })

/******/ });