/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 3);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./resources/assets/js/frontend/checkout.js":
/*!**************************************************!*\
  !*** ./resources/assets/js/frontend/checkout.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

Checkout = function Checkout(options) {
  var _ = {};
  _.options = options;

  _.onChangeDeliveryType = function () {
    $('body').on('change', _.o.deliveryType, function (e) {
      $(_.o.deliveryTypeText).html($(this).data('text'));

      if ($(this).val() == 'express') {
        $(_.o.deliveryAddress).slideDown();
        $('.js-hide-delivery').hide();
        $('.js-hide-delivery input').prop('disabled', true);
      } else {
        $(_.o.deliveryAddress).slideUp();
        $('.js-hide-delivery').show();
        $('.js-hide-delivery input').prop('disabled', false);
      }
    });
  };

  _.onChangePaymentType = function () {
    $('body').on('change', _.o.paymentType, function (e) {
      $(_.o.paymentTypeText).html($(this).data('text'));

      if ($(this).val() == 'online') {
        $(_.o.paymentTypes).slideDown();
      } else {
        $(_.o.paymentTypes).slideUp();
      }
    });
  };

  _.onClickOferta = function () {
    $('body').on('click', _.o.checkOferta, function (e) {
      if ($(this).is(':checked')) $(_.o.sendBtn).attr('disabled', false);else $(_.o.sendBtn).attr('disabled', true);
    });
  };

  _.onSubmitForm = function () {
    $(document).on('submit', _.o.checkoutForm, function (e) {
      $(_.o.preloader).show();
      e.preventDefault();
      var data = new FormData($(this)[0]),
          url = $(this).attr('action');

      _.sendRequest(url, data);

      e.stopImmediatePropagation();
      return false;
    });
  };

  _.sendRequest = function (url, data) {
    $.ajax({
      method: "POST",
      url: url,
      data: data,
      contentType: false,
      cache: false,
      processData: false
    }).done(function (data) {
      $(_.o.preloader).hide();

      _.cleanError();

      Toastify({
        text: data.message,
        className: "toastify",
        duration: 8000,
        gravity: "top",
        position: "center",
        close: true,
        newWindow: true,
        style: {
          background: '#0643DA'
        }
      }).showToast();
      setTimeout(function () {
        location.href = data.url;
      }, 2000);
    }).fail(function (response) {
      $(_.o.preloader).hide();

      if (response.status == 422) {
        var res = JSON.parse(response.responseText);

        _.cleanError();

        $.each(res.errors, function (elem, item) {
          $.each(item, function (i, error) {
            if ($('[name="' + elem + '"]').attr('type') == 'radio') {
              $('[name="' + elem + '"]').closest('.form-group').addClass("form-group--error");
              $('[name="' + elem + '"]').closest('.radio-group-btn').after('<label class="form-group__error">' + error + "</label>");
            } else {
              $('[name="' + elem + '"]').after('<label class="form-group__error">' + error + "</label>").parent().addClass("form-group--error");
            }
          });
        });
        $('html, body').animate({
          scrollTop: $('.form-group--error').offset().top - 300
        }, 500);
      } else {
        $(_.o.preloader).hide();
        alert("Ошибка!");
      }
    });
  };

  _.cleanError = function () {
    $(".form-group__error").remove();
    $(".form-group--error").removeClass("form-group--error");
  };

  _.initDefaultValues = function () {
    var checked_delivery = $(_.o.deliveryType + ':checked').data('text');
    $(_.o.deliveryTypeText).html(checked_delivery);
    var checked_payment = $(_.o.paymentType + ':checked').data('text');
    $(_.o.paymentTypeText).html(checked_payment);
    $(".js-phone-mask").mask("+999(99)999-99-99", {
      autoclear: false
    });
  };

  _.init = function () {
    _.o = options;

    _.onChangeDeliveryType();

    _.onChangePaymentType();

    _.initDefaultValues();

    _.onClickOferta();

    _.onSubmitForm();
  };

  _.init();

  return _;
};

/***/ }),

/***/ 3:
/*!********************************************************!*\
  !*** multi ./resources/assets/js/frontend/checkout.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! /Users/macbook/domains/simma/resources/assets/js/frontend/checkout.js */"./resources/assets/js/frontend/checkout.js");


/***/ })

/******/ });