// Create shuffle method for array
Array.prototype.shuffle = function() {
    var j, x, i;

    for (i = this.length; i; i--) {
        j = Math.floor(Math.random() * i);
        x = this[i - 1];
        this[i - 1] = this[j];
        this[j] = x;
    }

    return this;
}

var Dashboard = {
    colors: [
        '#3e70c9',
        '#43b968',
        '#20b9ae',
        '#f59345',
        '#f44236',
        '#a567e2',
        '#F18701',
        '#7678ED',
        '#F25F5C',
        '#FFE066',
        '#247BA0',
        '#70C1B3',
        '#FF6978',
        '#FFD972',
        '#FCAF58',
        '#FF8C42',
        '#4E598C',
        '#1098F7',
        '#60AFFF',
        '#427AA1'
    ],

    initdoughnutChart(data) {        
        new Chart($(data.selector)[0], {
            type: 'doughnut',
            options: {
              responsive: true
            },
            data: {
                labels: data.labels.split(','),
                datasets: [
									{
										backgroundColor: Dashboard.colors.shuffle().slice(0, data.labels.length),
										data: data.data.split(',').map(Number),
										label: 'Orders',
									},
                ]
            }
        });
    },

    barChart: function(data) {

        new Chart($(data.selector)[0], {
            type: 'bar',
            data: {
                labels: data.labels.split(','),
                datasets: [{
                    label: "К-во заказов",
                    borderColor: Dashboard.colors.shuffle().slice(0, data.labels.length),
                    backgroundColor: 'rgb(255, 99, 132)',
                    data: data.data.split(',').map(Number),                    
                }]
            },
            options: {
							scales: {
								y: {
									beginAtZero: true
								}
							}
						},
        });
    },

    init: function(options) {
        this.initdoughnutChart(options.doughnutChart);
        this.barChart(options.barChart);
    }

};


	// var chart = new Chart($('#chart')[0], {
	//     type: 'line',

	//     options: {
	//         responsive: true
	//     },

	//     data: {
 //        	labels: [],
 //        	datasets: [{
 //            	label: 'Продажа',
 //            	data: [],
 //                fill: true,
 //                borderColor: "#20b9ae",
 //                pointHoverBorderWidth: 2,
 //                backgroundColor: 'rgba(32, 185, 174, 0.6)',
 //                pointBackgroundColor: "#20b9ae",
 //        	}]
 //    	},
	// });

